/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.elk.owl.predefined.PredefinedElkEntityFactory;
import org.semanticweb.elk.reasoner.indexing.classes.CachedIndexedOwlBottomObjectPropertyImpl;
import org.semanticweb.elk.reasoner.indexing.classes.CachedIndexedOwlNothingImpl;
import org.semanticweb.elk.reasoner.indexing.classes.CachedIndexedOwlThingImpl;
import org.semanticweb.elk.reasoner.indexing.classes.CachedIndexedOwlTopObjectPropertyImpl;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedClassExpressionList;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedComplexClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedComplexPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedDataHasValue;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObject;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObjectComplementOf;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObjectHasSelf;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObjectUnionOf;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedOwlBottomObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedOwlNothing;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedOwlThing;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedOwlTopObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectCache;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedObjectCache;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.collections.entryset.Entry;
import org.semanticweb.elk.util.collections.entryset.EntryCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModifiableIndexedObjectCacheImpl
implements ModifiableIndexedObjectCache {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ModifiableIndexedObjectCacheImpl.class);
    private final EntryCollection<CachedIndexedComplexClassExpression<?>> cachedComplexClassExpressions_;
    private final EntryCollection<CachedIndexedComplexPropertyChain> cachedBinaryPropertyChains_;
    private final EntryCollection<CachedIndexedClassExpressionList> cachedClassExpressionLists_;
    private final EntryCollection<CachedIndexedClass> cachedClasses_;
    private final EntryCollection<CachedIndexedObjectProperty> cachedObjectProperties_;
    private final EntryCollection<CachedIndexedIndividual> cachedIndividuals_;
    private final CachedIndexedObject.Filter resolver_;
    private final CachedIndexedObject.Filter inserter_;
    private final CachedIndexedObject.Filter deleter_;
    private final CachedIndexedOwlThing owlThing_;
    private final CachedIndexedOwlNothing owlNothing_;
    private final CachedIndexedOwlTopObjectProperty owlTopObjectProperty_;
    private final CachedIndexedOwlBottomObjectProperty owlBottomObjectProperty_;
    private final List<IndexedObjectCache.ChangeListener> listeners_;

    public ModifiableIndexedObjectCacheImpl(PredefinedElkEntityFactory elkFactory, int initialSize) {
        this.cachedComplexClassExpressions_ = new EntryCollection(initialSize);
        this.cachedBinaryPropertyChains_ = new EntryCollection(initialSize);
        this.cachedClassExpressionLists_ = new EntryCollection(initialSize);
        this.cachedClasses_ = new EntryCollection(initialSize);
        this.cachedObjectProperties_ = new EntryCollection(initialSize);
        this.cachedIndividuals_ = new EntryCollection(initialSize);
        this.resolver_ = new Resolver_();
        this.inserter_ = new Inserter_();
        this.deleter_ = new Deleter_();
        this.owlThing_ = new CachedIndexedOwlThingImpl(elkFactory.getOwlThing());
        this.owlNothing_ = new CachedIndexedOwlNothingImpl(elkFactory.getOwlNothing());
        this.owlTopObjectProperty_ = new CachedIndexedOwlTopObjectPropertyImpl(elkFactory.getOwlTopObjectProperty());
        this.owlBottomObjectProperty_ = new CachedIndexedOwlBottomObjectPropertyImpl(elkFactory.getOwlBottomObjectProperty());
        this.listeners_ = new ArrayList<IndexedObjectCache.ChangeListener>();
        this.add(this.owlThing_);
        this.add(this.owlNothing_);
        this.add(this.owlTopObjectProperty_);
        this.add(this.owlBottomObjectProperty_);
    }

    public ModifiableIndexedObjectCacheImpl(PredefinedElkEntityFactory elkFactory) {
        this(elkFactory, 1024);
    }

    @Override
    public final Collection<? extends IndexedClass> getClasses() {
        return this.cachedClasses_;
    }

    @Override
    public final Collection<? extends IndexedIndividual> getIndividuals() {
        return this.cachedIndividuals_;
    }

    @Override
    public final Collection<? extends IndexedObjectProperty> getObjectProperties() {
        return this.cachedObjectProperties_;
    }

    @Override
    public final Collection<? extends IndexedClassExpression> getClassExpressions() {
        return Operations.getCollection((Iterable)Operations.concat((Iterable[])new Iterable[]{this.cachedClasses_, this.cachedIndividuals_, this.cachedComplexClassExpressions_}), (int)(this.cachedClasses_.size() + this.cachedIndividuals_.size() + this.cachedComplexClassExpressions_.size()));
    }

    @Override
    public final Collection<? extends IndexedPropertyChain> getPropertyChains() {
        return Operations.getCollection((Iterable)Operations.concat((Iterable[])new Iterable[]{this.cachedObjectProperties_, this.cachedBinaryPropertyChains_}), (int)(this.cachedObjectProperties_.size() + this.cachedBinaryPropertyChains_.size()));
    }

    @Override
    public final CachedIndexedOwlThing getOwlThing() {
        return this.owlThing_;
    }

    @Override
    public final CachedIndexedOwlNothing getOwlNothing() {
        return this.owlNothing_;
    }

    @Override
    public CachedIndexedOwlTopObjectProperty getOwlTopObjectProperty() {
        return this.owlTopObjectProperty_;
    }

    @Override
    public CachedIndexedOwlBottomObjectProperty getOwlBottomObjectProperty() {
        return this.owlBottomObjectProperty_;
    }

    @Override
    public <T extends CachedIndexedObject<T>> T resolve(CachedIndexedObject<T> input) {
        return input.accept(this.resolver_);
    }

    @Override
    public void add(CachedIndexedObject<?> input) {
        LOGGER_.trace("{}: adding to cache", input);
        input.accept(this.inserter_);
    }

    @Override
    public void remove(CachedIndexedObject<?> input) {
        LOGGER_.trace("{}: removing from cache", input);
        input.accept(this.deleter_);
    }

    @Override
    public final boolean addListener(IndexedObjectCache.ChangeListener listener) {
        return this.listeners_.add(listener);
    }

    @Override
    public final boolean removeListener(IndexedObjectCache.ChangeListener listener) {
        return this.listeners_.remove(listener);
    }

    private class Resolver_
    implements CachedIndexedObject.Filter {
        private Resolver_() {
        }

        @Override
        public CachedIndexedClass filter(CachedIndexedClass element) {
            return (CachedIndexedClass)ModifiableIndexedObjectCacheImpl.this.cachedClasses_.findStructural((Entry)element);
        }

        @Override
        public CachedIndexedIndividual filter(CachedIndexedIndividual element) {
            return (CachedIndexedIndividual)ModifiableIndexedObjectCacheImpl.this.cachedIndividuals_.findStructural((Entry)element);
        }

        @Override
        public CachedIndexedObjectComplementOf filter(CachedIndexedObjectComplementOf element) {
            return (CachedIndexedObjectComplementOf)ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_.findStructural((Entry)element);
        }

        @Override
        public CachedIndexedObjectIntersectionOf filter(CachedIndexedObjectIntersectionOf element) {
            return (CachedIndexedObjectIntersectionOf)ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_.findStructural((Entry)element);
        }

        @Override
        public CachedIndexedObjectSomeValuesFrom filter(CachedIndexedObjectSomeValuesFrom element) {
            return (CachedIndexedObjectSomeValuesFrom)ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_.findStructural((Entry)element);
        }

        @Override
        public CachedIndexedObjectHasSelf filter(CachedIndexedObjectHasSelf element) {
            return (CachedIndexedObjectHasSelf)ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_.findStructural((Entry)element);
        }

        @Override
        public CachedIndexedObjectUnionOf filter(CachedIndexedObjectUnionOf element) {
            return (CachedIndexedObjectUnionOf)ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_.findStructural((Entry)element);
        }

        @Override
        public CachedIndexedDataHasValue filter(CachedIndexedDataHasValue element) {
            return (CachedIndexedDataHasValue)ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_.findStructural((Entry)element);
        }

        @Override
        public CachedIndexedObjectProperty filter(CachedIndexedObjectProperty element) {
            return (CachedIndexedObjectProperty)ModifiableIndexedObjectCacheImpl.this.cachedObjectProperties_.findStructural((Entry)element);
        }

        @Override
        public CachedIndexedComplexPropertyChain filter(CachedIndexedComplexPropertyChain element) {
            return (CachedIndexedComplexPropertyChain)ModifiableIndexedObjectCacheImpl.this.cachedBinaryPropertyChains_.findStructural((Entry)element);
        }

        @Override
        public CachedIndexedClassExpressionList filter(CachedIndexedClassExpressionList element) {
            return (CachedIndexedClassExpressionList)ModifiableIndexedObjectCacheImpl.this.cachedClassExpressionLists_.findStructural((Entry)element);
        }
    }

    private class Inserter_
    implements CachedIndexedObject.Filter {
        private Inserter_() {
        }

        @Override
        public CachedIndexedClass filter(CachedIndexedClass element) {
            ModifiableIndexedObjectCacheImpl.this.cachedClasses_.addStructural((Entry)element);
            for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                IndexedObjectCache.ChangeListener listener = (IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i);
                listener.classAddition(element);
                listener.classExpressionAddition(element);
            }
            return null;
        }

        @Override
        public CachedIndexedIndividual filter(CachedIndexedIndividual element) {
            ModifiableIndexedObjectCacheImpl.this.cachedIndividuals_.addStructural((Entry)element);
            for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                IndexedObjectCache.ChangeListener listener = (IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i);
                listener.individualAddition(element);
                listener.classExpressionAddition(element);
            }
            return null;
        }

        private <T extends CachedIndexedComplexClassExpression<T>> T defaultFilter(T element) {
            ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_.addStructural(element);
            for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                ((IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i)).classExpressionAddition(element);
            }
            return null;
        }

        @Override
        public CachedIndexedObjectComplementOf filter(CachedIndexedObjectComplementOf element) {
            return this.defaultFilter(element);
        }

        @Override
        public CachedIndexedObjectIntersectionOf filter(CachedIndexedObjectIntersectionOf element) {
            return this.defaultFilter(element);
        }

        @Override
        public CachedIndexedObjectSomeValuesFrom filter(CachedIndexedObjectSomeValuesFrom element) {
            return this.defaultFilter(element);
        }

        @Override
        public CachedIndexedObjectHasSelf filter(CachedIndexedObjectHasSelf element) {
            return this.defaultFilter(element);
        }

        @Override
        public CachedIndexedObjectUnionOf filter(CachedIndexedObjectUnionOf element) {
            return this.defaultFilter(element);
        }

        @Override
        public CachedIndexedDataHasValue filter(CachedIndexedDataHasValue element) {
            return this.defaultFilter(element);
        }

        @Override
        public CachedIndexedObjectProperty filter(CachedIndexedObjectProperty element) {
            ModifiableIndexedObjectCacheImpl.this.cachedObjectProperties_.addStructural((Entry)element);
            for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                IndexedObjectCache.ChangeListener listener = (IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i);
                listener.objectPropertyAddition(element);
                listener.propertyChainAddition(element);
            }
            return null;
        }

        @Override
        public CachedIndexedComplexPropertyChain filter(CachedIndexedComplexPropertyChain element) {
            ModifiableIndexedObjectCacheImpl.this.cachedBinaryPropertyChains_.addStructural((Entry)element);
            for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                ((IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i)).propertyChainAddition(element);
            }
            return null;
        }

        @Override
        public CachedIndexedClassExpressionList filter(CachedIndexedClassExpressionList element) {
            ModifiableIndexedObjectCacheImpl.this.cachedClassExpressionLists_.addStructural((Entry)element);
            return null;
        }
    }

    private class Deleter_
    implements CachedIndexedObject.Filter {
        private Deleter_() {
        }

        @Override
        public CachedIndexedClass filter(CachedIndexedClass element) {
            CachedIndexedClass result = (CachedIndexedClass)ModifiableIndexedObjectCacheImpl.this.cachedClasses_.removeStructural((Entry)element);
            if (result != null) {
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    IndexedObjectCache.ChangeListener listener = (IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i);
                    listener.classRemoval(result);
                    listener.classExpressionRemoval(result);
                }
            }
            return result;
        }

        @Override
        public CachedIndexedIndividual filter(CachedIndexedIndividual element) {
            CachedIndexedIndividual result = (CachedIndexedIndividual)ModifiableIndexedObjectCacheImpl.this.cachedIndividuals_.removeStructural((Entry)element);
            if (result != null) {
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    IndexedObjectCache.ChangeListener listener = (IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i);
                    listener.individualRemoval(result);
                    listener.classExpressionRemoval(result);
                }
            }
            return result;
        }

        private <T extends CachedIndexedComplexClassExpression<T>> T defaultFilter(T element) {
            CachedIndexedComplexClassExpression result = (CachedIndexedComplexClassExpression)ModifiableIndexedObjectCacheImpl.this.cachedComplexClassExpressions_.removeStructural(element);
            if (result != null) {
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    ((IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i)).classExpressionRemoval(element);
                }
            }
            return (T)result;
        }

        @Override
        public CachedIndexedObjectComplementOf filter(CachedIndexedObjectComplementOf element) {
            return this.defaultFilter(element);
        }

        @Override
        public CachedIndexedObjectIntersectionOf filter(CachedIndexedObjectIntersectionOf element) {
            return this.defaultFilter(element);
        }

        @Override
        public CachedIndexedObjectSomeValuesFrom filter(CachedIndexedObjectSomeValuesFrom element) {
            return this.defaultFilter(element);
        }

        @Override
        public CachedIndexedObjectHasSelf filter(CachedIndexedObjectHasSelf element) {
            return this.defaultFilter(element);
        }

        @Override
        public CachedIndexedObjectUnionOf filter(CachedIndexedObjectUnionOf element) {
            return this.defaultFilter(element);
        }

        @Override
        public CachedIndexedDataHasValue filter(CachedIndexedDataHasValue element) {
            return this.defaultFilter(element);
        }

        @Override
        public CachedIndexedObjectProperty filter(CachedIndexedObjectProperty element) {
            CachedIndexedObjectProperty result = (CachedIndexedObjectProperty)ModifiableIndexedObjectCacheImpl.this.cachedObjectProperties_.removeStructural((Entry)element);
            if (result != null) {
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    IndexedObjectCache.ChangeListener listener = (IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i);
                    listener.objectPropertyRemoval(result);
                    listener.propertyChainRemoval(result);
                }
            }
            return result;
        }

        @Override
        public CachedIndexedComplexPropertyChain filter(CachedIndexedComplexPropertyChain element) {
            CachedIndexedComplexPropertyChain result = (CachedIndexedComplexPropertyChain)ModifiableIndexedObjectCacheImpl.this.cachedBinaryPropertyChains_.removeStructural((Entry)element);
            if (result != null) {
                for (int i = 0; i < ModifiableIndexedObjectCacheImpl.this.listeners_.size(); ++i) {
                    ((IndexedObjectCache.ChangeListener)ModifiableIndexedObjectCacheImpl.this.listeners_.get(i)).propertyChainRemoval(element);
                }
            }
            return result;
        }

        @Override
        public CachedIndexedClassExpressionList filter(CachedIndexedClassExpressionList element) {
            return (CachedIndexedClassExpressionList)ModifiableIndexedObjectCacheImpl.this.cachedClassExpressionLists_.removeStructural((Entry)element);
        }
    }
}

