/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.reasoner.indexing.classes.DelegatingCachedIndexedObjectFactory;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkIndexingException;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObject;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedSubObject;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedAxiom;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedSubObject;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;

class UpdatingCachedIndexedObjectFactory
extends DelegatingCachedIndexedObjectFactory {
    private final OccurrenceIncrement increment_;
    private final ModifiableOntologyIndex index_;

    public UpdatingCachedIndexedObjectFactory(CachedIndexedObject.Factory baseFactory, ModifiableOntologyIndex index, OccurrenceIncrement increment) {
        super(baseFactory);
        this.index_ = index;
        this.increment_ = increment;
    }

    @Override
    <T extends CachedIndexedSubObject<T>> T filter(T input) {
        T result = this.resolve(input);
        this.update(result);
        if (!result.occurs()) {
            this.index_.remove(result);
        }
        return result;
    }

    <T extends CachedIndexedObject<T>> T resolve(T input) {
        Object result = this.index_.resolve(input);
        if (result == null) {
            result = input;
        }
        if (!result.occurs()) {
            this.index_.add((CachedIndexedObject<?>)result);
        }
        return result;
    }

    <T extends ModifiableIndexedSubObject> T update(T input) {
        if (!input.updateOccurrenceNumbers(this.index_, this.increment_)) {
            throw new ElkIndexingException(input.toString() + ": cannot update in Index for " + this.increment_ + " occurrences!");
        }
        return input;
    }

    <T extends ModifiableIndexedAxiom> T update(T input) {
        int i;
        if (this.increment_.totalIncrement > 0) {
            for (i = 0; i < this.increment_.totalIncrement; ++i) {
                if (input.addOccurrence(this.index_)) continue;
                throw new ElkIndexingException(input.toString() + ": cannot be added to Index!");
            }
        }
        if (this.increment_.totalIncrement < 0) {
            for (i = 0; i < -this.increment_.totalIncrement; ++i) {
                if (input.removeOccurrence(this.index_)) continue;
                throw new ElkIndexingException(input.toString() + ": cannot be removed from Index!");
            }
        }
        return input;
    }
}

