/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.conversion;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.liveontologies.puli.Producer;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDeclarationAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDifferentIndividualsAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointUnionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyChain;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkReflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSameIndividualAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkTransitiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.predefined.ElkPolarity;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.owl.visitors.ElkEntityVisitor;
import org.semanticweb.elk.owl.visitors.ElkIndividualVisitor;
import org.semanticweb.elk.owl.visitors.ElkObjectPropertyExpressionVisitor;
import org.semanticweb.elk.owl.visitors.ElkSubObjectPropertyExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.classes.ModifiableIndexedObjectBaseFactory;
import org.semanticweb.elk.reasoner.indexing.classes.ResolvingModifiableIndexedObjectFactory;
import org.semanticweb.elk.reasoner.indexing.classes.UpdatingModifiableIndexedObjectFactory;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkEntityConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkEntityConverterImpl;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverterImpl;
import org.semanticweb.elk.reasoner.indexing.conversion.FailingElkAxiomConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.ModifiableIndexedAxiomInferenceConclusionVisitingFactory;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObject;
import org.semanticweb.elk.reasoner.indexing.model.IndexedAxiomInference;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexingListener;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedAxiomInference;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpressionList;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedEntity;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedObject;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.Occurrence;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;

public class ElkAxiomConverterImpl
extends FailingElkAxiomConverter {
    private final PredefinedElkClassFactory elkFactory_;
    private final ModifiableIndexedAxiomInference.Factory axiomInferenceFactory_;
    private final ModifiableIndexedObject.Factory positiveFactory_;
    private final ModifiableIndexedObject.Factory negativeFactory_;
    private final ElkPolarityExpressionConverter positiveConverter_;
    private final ElkPolarityExpressionConverter negativeConverter_;
    private final ElkPolarityExpressionConverter dualConverter_;
    private final ElkEntityConverter entityConverter_;
    private final IndexingListener indexingListener_;
    private static final int DISJOINT_AXIOM_BINARIZATION_THRESHOLD = 2;
    private final ElkDisjointClassesAxiomDisjointnessIndexer elkDisjointClassesAxiomDisjointnessIndexer = new ElkDisjointClassesAxiomDisjointnessIndexer();
    private final ElkDisjointUnionAxiomDisjointnessIndexer elkDisjointUnionAxiomDisjointnessIndexer = new ElkDisjointUnionAxiomDisjointnessIndexer();
    private final ElkDifferentIndividualsAxiomDisjointnessIndexer elkDifferentIndividualsAxiomDisjointnessIndexer = new ElkDifferentIndividualsAxiomDisjointnessIndexer();

    public ElkAxiomConverterImpl(PredefinedElkClassFactory elkFactory, ModifiableIndexedObject.Factory neutralFactory, ModifiableIndexedObject.Factory positiveFactory, ModifiableIndexedObject.Factory negativeFactory, ModifiableIndexedObject.Factory dualFactory, IndexingListener indexingListener, Producer<? super IndexedAxiomInference> producer) {
        this.elkFactory_ = elkFactory;
        this.axiomInferenceFactory_ = new ModifiableIndexedAxiomInferenceConclusionVisitingFactory(producer, neutralFactory);
        this.positiveFactory_ = positiveFactory;
        this.negativeFactory_ = negativeFactory;
        this.positiveConverter_ = new ElkPolarityExpressionConverterImpl(ElkPolarity.POSITIVE, elkFactory, positiveFactory, negativeFactory, indexingListener);
        this.negativeConverter_ = this.positiveConverter_.getComplementaryConverter();
        this.dualConverter_ = new ElkPolarityExpressionConverterImpl(elkFactory, dualFactory, indexingListener);
        this.entityConverter_ = new ElkEntityConverterImpl(neutralFactory);
        this.indexingListener_ = indexingListener;
    }

    public ElkAxiomConverterImpl(PredefinedElkClassFactory elkFactory, ModifiableIndexedObject.Factory factory, IndexingListener indexingListener, Producer<? super IndexedAxiomInference> producer) {
        this(elkFactory, factory, factory, factory, factory, indexingListener, producer);
    }

    public ElkAxiomConverterImpl(PredefinedElkClassFactory elkFactory, ModifiableOntologyIndex index) {
        this(elkFactory, new ResolvingModifiableIndexedObjectFactory(index), (IndexingListener)index, (Producer<? super IndexedAxiomInference>)Producer.Dummy.get());
    }

    <F extends CachedIndexedObject.Factory & ModifiableIndexedObject.Factory> ElkAxiomConverterImpl(PredefinedElkClassFactory elkFactory, F baseFactory, ModifiableOntologyIndex index, int increment) {
        this(elkFactory, new UpdatingModifiableIndexedObjectFactory(baseFactory, index, OccurrenceIncrement.getNeutralIncrement(increment)), new UpdatingModifiableIndexedObjectFactory(baseFactory, index, OccurrenceIncrement.getPositiveIncrement(increment)), new UpdatingModifiableIndexedObjectFactory(baseFactory, index, OccurrenceIncrement.getNegativeIncrement(increment)), new UpdatingModifiableIndexedObjectFactory(baseFactory, index, OccurrenceIncrement.getDualIncrement(increment)), index, (Producer<? super IndexedAxiomInference>)Producer.Dummy.get());
    }

    public ElkAxiomConverterImpl(PredefinedElkClassFactory elkFactory, ModifiableOntologyIndex index, int increment) {
        this(elkFactory, new ModifiableIndexedObjectBaseFactory(), index, increment);
    }

    @Override
    public Void visit(ElkObjectPropertyDomainAxiom axiom) {
        ModifiableIndexedClass indexedOwlThing = this.negativeFactory_.getIndexedClass(this.elkFactory_.getOwlThing());
        this.axiomInferenceFactory_.getElkObjectPropertyDomainAxiomConversion(axiom, this.negativeFactory_.getIndexedObjectSomeValuesFrom((ModifiableIndexedObjectProperty)((ElkObjectPropertyExpression)axiom.getProperty()).accept((ElkObjectPropertyExpressionVisitor)this.negativeConverter_), indexedOwlThing), (ModifiableIndexedClassExpression)((ElkClassExpression)axiom.getDomain()).accept((ElkClassExpressionVisitor)this.positiveConverter_));
        return null;
    }

    @Override
    public Void visit(ElkObjectPropertyRangeAxiom axiom) {
        this.indexingListener_.onIndexing(Occurrence.OCCURRENCE_OF_OBJECT_PROPERTY_RANGE);
        this.axiomInferenceFactory_.getElkObjectPropertyRangeAxiomConversion(axiom, (ModifiableIndexedObjectProperty)((ElkObjectPropertyExpression)axiom.getProperty()).accept((ElkObjectPropertyExpressionVisitor)this.negativeConverter_), (ModifiableIndexedClassExpression)((ElkClassExpression)axiom.getRange()).accept((ElkClassExpressionVisitor)this.positiveConverter_));
        return null;
    }

    @Override
    public Void visit(ElkReflexiveObjectPropertyAxiom axiom) {
        this.axiomInferenceFactory_.getElkReflexiveObjectPropertyAxiomConversion(axiom, this.negativeFactory_.getIndexedClass(this.elkFactory_.getOwlThing()), this.positiveFactory_.getIndexedObjectHasSelf((ModifiableIndexedObjectProperty)((ElkObjectPropertyExpression)axiom.getProperty()).accept((ElkObjectPropertyExpressionVisitor)this.positiveConverter_)));
        return null;
    }

    @Override
    public Void visit(ElkSubObjectPropertyOfAxiom axiom) {
        this.axiomInferenceFactory_.getElkSubObjectPropertyOfAxiomConversion(axiom, (ModifiableIndexedPropertyChain)axiom.getSubObjectPropertyExpression().accept((ElkSubObjectPropertyExpressionVisitor)this), (ModifiableIndexedObjectProperty)axiom.getSuperObjectPropertyExpression().accept((ElkObjectPropertyExpressionVisitor)this.positiveConverter_));
        return null;
    }

    @Override
    public Void visit(ElkEquivalentObjectPropertiesAxiom axiom) {
        ModifiableIndexedObjectProperty first = null;
        List members = axiom.getObjectPropertyExpressions();
        for (int pos = 0; pos < members.size(); ++pos) {
            ElkObjectPropertyExpression pe = (ElkObjectPropertyExpression)members.get(pos);
            if (first == null) {
                first = (ModifiableIndexedObjectProperty)pe.accept((ElkObjectPropertyExpressionVisitor)this.dualConverter_);
                continue;
            }
            ModifiableIndexedObjectProperty other = (ModifiableIndexedObjectProperty)pe.accept((ElkObjectPropertyExpressionVisitor)this.dualConverter_);
            this.axiomInferenceFactory_.getElkEquivalentObjectPropertiesAxiomConversion(axiom, 0, pos, first, other);
            this.axiomInferenceFactory_.getElkEquivalentObjectPropertiesAxiomConversion(axiom, pos, 0, other, first);
        }
        return null;
    }

    @Override
    public Void visit(ElkTransitiveObjectPropertyAxiom axiom) {
        ModifiableIndexedObjectProperty p = (ModifiableIndexedObjectProperty)((ElkObjectPropertyExpression)axiom.getProperty()).accept((ElkObjectPropertyExpressionVisitor)this.dualConverter_);
        this.axiomInferenceFactory_.getElkTransitiveObjectPropertyAxiomConversion(axiom, this.negativeFactory_.getIndexedComplexPropertyChain(p, p), p);
        return null;
    }

    @Override
    public Void visit(ElkEquivalentClassesAxiom axiom) {
        ModifiableIndexedClassExpression first = null;
        boolean firstIsAClass = false;
        List members = axiom.getClassExpressions();
        for (int pos = 0; pos < members.size(); ++pos) {
            ElkClassExpression c = (ElkClassExpression)members.get(pos);
            if (first == null) {
                first = (ModifiableIndexedClassExpression)c.accept((ElkClassExpressionVisitor)this.dualConverter_);
                if (!(first instanceof IndexedClass)) continue;
                firstIsAClass = true;
                continue;
            }
            ModifiableIndexedClassExpression other = (ModifiableIndexedClassExpression)c.accept((ElkClassExpressionVisitor)this.dualConverter_);
            if (!firstIsAClass && other instanceof ModifiableIndexedClass) {
                this.axiomInferenceFactory_.getElkEquivalentClassesAxiomEquivalenceConversion(axiom, pos, 0, other, first);
                continue;
            }
            this.axiomInferenceFactory_.getElkEquivalentClassesAxiomEquivalenceConversion(axiom, 0, pos, first, other);
        }
        return null;
    }

    @Override
    public Void visit(ElkSameIndividualAxiom axiom) {
        ModifiableIndexedIndividual first = null;
        List members = axiom.getIndividuals();
        for (int pos = 0; pos < members.size(); ++pos) {
            ElkIndividual ind = (ElkIndividual)members.get(pos);
            if (first == null) {
                first = (ModifiableIndexedIndividual)ind.accept((ElkIndividualVisitor)this.dualConverter_);
                continue;
            }
            ModifiableIndexedIndividual other = (ModifiableIndexedIndividual)ind.accept((ElkIndividualVisitor)this.dualConverter_);
            this.axiomInferenceFactory_.getElkSameIndividualAxiomConversion(axiom, 0, pos, first, other);
            this.axiomInferenceFactory_.getElkSameIndividualAxiomConversion(axiom, pos, 0, other, first);
        }
        return null;
    }

    @Override
    public Void visit(ElkSubClassOfAxiom axiom) {
        this.axiomInferenceFactory_.getElkSubClassOfAxiomConversion(axiom, (ModifiableIndexedClassExpression)axiom.getSubClassExpression().accept((ElkClassExpressionVisitor)this.negativeConverter_), (ModifiableIndexedClassExpression)axiom.getSuperClassExpression().accept((ElkClassExpressionVisitor)this.positiveConverter_));
        return null;
    }

    private <A extends ElkAxiom, M extends ElkObject> void indexDisjointMembers(DisjointnessIndexer<A, M> indexer, A axiom, List<? extends M> members) {
        ModifiableIndexedClass indexedOwlNothing = this.positiveFactory_.getIndexedClass(this.elkFactory_.getOwlNothing());
        if (members.size() > 2) {
            ArrayList<ModifiableIndexedClassExpression> indexedMembers = new ArrayList<ModifiableIndexedClassExpression>(members.size());
            for (ElkObject member : members) {
                indexedMembers.add(indexer.convert(member));
            }
            indexer.indexNary(axiom, this.positiveFactory_.getIndexedClassExpressionList(indexedMembers));
            return;
        }
        for (int firstPos = 0; firstPos < members.size(); ++firstPos) {
            ElkObject first = (ElkObject)members.get(firstPos);
            ModifiableIndexedClassExpression firstIndexed = indexer.convert(first);
            for (int secondPos = firstPos + 1; secondPos < members.size(); ++secondPos) {
                ElkObject second = (ElkObject)members.get(secondPos);
                ModifiableIndexedClassExpression secondIndexed = indexer.convert(second);
                indexer.indexBinary(axiom, firstPos, secondPos, this.negativeFactory_.getIndexedObjectIntersectionOf(firstIndexed, secondIndexed), indexedOwlNothing);
            }
        }
    }

    @Override
    public Void visit(ElkDisjointClassesAxiom axiom) {
        this.indexDisjointMembers(this.elkDisjointClassesAxiomDisjointnessIndexer, axiom, axiom.getClassExpressions());
        return null;
    }

    @Override
    public Void visit(ElkDisjointUnionAxiom axiom) {
        List disjoint = axiom.getClassExpressions();
        this.indexDisjointMembers(this.elkDisjointUnionAxiomDisjointnessIndexer, axiom, disjoint);
        int size = disjoint.size();
        switch (size) {
            case 0: {
                ModifiableIndexedClass defined = (ModifiableIndexedClass)axiom.getDefinedClass().accept((ElkClassExpressionVisitor)this.positiveConverter_);
                this.axiomInferenceFactory_.getElkDisjointUnionAxiomOwlNothingConversion(axiom, defined, this.positiveFactory_.getIndexedClass(this.elkFactory_.getOwlNothing()));
                break;
            }
            case 1: {
                ModifiableIndexedClass defined = (ModifiableIndexedClass)axiom.getDefinedClass().accept((ElkClassExpressionVisitor)this.dualConverter_);
                ModifiableIndexedClassExpression member = (ModifiableIndexedClassExpression)((ElkClassExpression)disjoint.iterator().next()).accept((ElkClassExpressionVisitor)this.dualConverter_);
                this.axiomInferenceFactory_.getElkDisjointUnionAxiomEquivalenceConversion(axiom, defined, member);
                break;
            }
            default: {
                this.indexingListener_.onIndexing(Occurrence.OCCURRENCE_OF_DISJOINT_UNION);
                ModifiableIndexedClass defined = (ModifiableIndexedClass)axiom.getDefinedClass().accept((ElkClassExpressionVisitor)this.positiveConverter_);
                for (int pos = 0; pos < size; ++pos) {
                    ElkClassExpression c = (ElkClassExpression)disjoint.get(pos);
                    ModifiableIndexedClassExpression member = (ModifiableIndexedClassExpression)c.accept((ElkClassExpressionVisitor)this.negativeConverter_);
                    this.axiomInferenceFactory_.getElkDisjointUnionAxiomSubClassConversion(axiom, pos, member, defined);
                }
            }
        }
        return null;
    }

    @Override
    public Void visit(ElkDifferentIndividualsAxiom axiom) {
        this.indexDisjointMembers(this.elkDifferentIndividualsAxiomDisjointnessIndexer, axiom, axiom.getIndividuals());
        return null;
    }

    @Override
    public Void visit(ElkClassAssertionAxiom axiom) {
        this.axiomInferenceFactory_.getElkClassAssertionAxiomConversion(axiom, (ModifiableIndexedIndividual)axiom.getIndividual().accept((ElkIndividualVisitor)this.negativeConverter_), (ModifiableIndexedClassExpression)axiom.getClassExpression().accept((ElkClassExpressionVisitor)this.positiveConverter_));
        return null;
    }

    @Override
    public Void visit(ElkObjectPropertyAssertionAxiom axiom) {
        this.indexingListener_.onIndexing(Occurrence.OCCURRENCE_OF_OBJECT_PROPERTY_RANGE);
        this.axiomInferenceFactory_.getElkObjectPropertyAssertionAxiomConversion(axiom, (ModifiableIndexedClassExpression)((ElkIndividual)axiom.getSubject()).accept((ElkIndividualVisitor)this.negativeConverter_), this.positiveFactory_.getIndexedObjectSomeValuesFrom((ModifiableIndexedObjectProperty)((ElkObjectPropertyExpression)axiom.getProperty()).accept((ElkObjectPropertyExpressionVisitor)this.positiveConverter_), (ModifiableIndexedClassExpression)((ElkIndividual)axiom.getObject()).accept((ElkIndividualVisitor)this.positiveConverter_)));
        return null;
    }

    @Override
    public Void visit(ElkDeclarationAxiom axiom) {
        this.axiomInferenceFactory_.getElkDeclarationAxiomConversion(axiom, (ModifiableIndexedEntity)axiom.getEntity().accept((ElkEntityVisitor)this.entityConverter_));
        return null;
    }

    @Override
    public ModifiableIndexedPropertyChain visit(ElkObjectProperty expression) {
        return (ModifiableIndexedPropertyChain)expression.accept((ElkObjectPropertyExpressionVisitor)this.negativeConverter_);
    }

    @Override
    public ModifiableIndexedPropertyChain visit(ElkObjectPropertyChain elkObjectPropertyChain) {
        ModifiableIndexedPropertyChain result = null;
        ListIterator iterator = elkObjectPropertyChain.getObjectPropertyExpressions().listIterator(elkObjectPropertyChain.getObjectPropertyExpressions().size());
        while (iterator.hasPrevious()) {
            ModifiableIndexedObjectProperty iop = (ModifiableIndexedObjectProperty)((ElkObjectPropertyExpression)iterator.previous()).accept((ElkObjectPropertyExpressionVisitor)this.negativeConverter_);
            if (result == null) {
                result = iop;
                continue;
            }
            result = this.negativeFactory_.getIndexedComplexPropertyChain(iop, result);
        }
        return result;
    }

    private class ElkDisjointClassesAxiomDisjointnessIndexer
    implements DisjointnessIndexer<ElkDisjointClassesAxiom, ElkClassExpression> {
        private ElkDisjointClassesAxiomDisjointnessIndexer() {
        }

        @Override
        public ModifiableIndexedClassExpression convert(ElkClassExpression member) {
            return (ModifiableIndexedClassExpression)member.accept((ElkClassExpressionVisitor)ElkAxiomConverterImpl.this.negativeConverter_);
        }

        @Override
        public void indexNary(ElkDisjointClassesAxiom axiom, ModifiableIndexedClassExpressionList members) {
            ElkAxiomConverterImpl.this.axiomInferenceFactory_.getElkDisjointClassesAxiomNaryConversion(axiom, members);
        }

        @Override
        public void indexBinary(ElkDisjointClassesAxiom axiom, int firstMemberPosition, int secondMemberPosition, ModifiableIndexedObjectIntersectionOf memberConunction, ModifiableIndexedClass bottom) {
            ElkAxiomConverterImpl.this.axiomInferenceFactory_.getElkDisjointClassesAxiomBinaryConversion(axiom, firstMemberPosition, secondMemberPosition, memberConunction, bottom);
        }
    }

    private class ElkDisjointUnionAxiomDisjointnessIndexer
    implements DisjointnessIndexer<ElkDisjointUnionAxiom, ElkClassExpression> {
        private ElkDisjointUnionAxiomDisjointnessIndexer() {
        }

        @Override
        public ModifiableIndexedClassExpression convert(ElkClassExpression member) {
            return (ModifiableIndexedClassExpression)member.accept((ElkClassExpressionVisitor)ElkAxiomConverterImpl.this.negativeConverter_);
        }

        @Override
        public void indexNary(ElkDisjointUnionAxiom axiom, ModifiableIndexedClassExpressionList members) {
            ElkAxiomConverterImpl.this.axiomInferenceFactory_.getElkDisjointUnionAxiomNaryConversion(axiom, members);
        }

        @Override
        public void indexBinary(ElkDisjointUnionAxiom axiom, int firstMemberPosition, int secondMemberPosition, ModifiableIndexedObjectIntersectionOf memberConunction, ModifiableIndexedClass bottom) {
            ElkAxiomConverterImpl.this.axiomInferenceFactory_.getElkDisjointUnionAxiomBinaryConversion(axiom, firstMemberPosition, secondMemberPosition, memberConunction, bottom);
        }
    }

    private class ElkDifferentIndividualsAxiomDisjointnessIndexer
    implements DisjointnessIndexer<ElkDifferentIndividualsAxiom, ElkIndividual> {
        private ElkDifferentIndividualsAxiomDisjointnessIndexer() {
        }

        @Override
        public ModifiableIndexedClassExpression convert(ElkIndividual member) {
            return (ModifiableIndexedClassExpression)member.accept((ElkIndividualVisitor)ElkAxiomConverterImpl.this.negativeConverter_);
        }

        @Override
        public void indexNary(ElkDifferentIndividualsAxiom axiom, ModifiableIndexedClassExpressionList members) {
            ElkAxiomConverterImpl.this.axiomInferenceFactory_.getElkDifferentIndividualsAxiomNaryConversion(axiom, members);
        }

        @Override
        public void indexBinary(ElkDifferentIndividualsAxiom axiom, int firstMemberPosition, int secondMemberPosition, ModifiableIndexedObjectIntersectionOf memberConunction, ModifiableIndexedClass bottom) {
            ElkAxiomConverterImpl.this.axiomInferenceFactory_.getElkDifferentIndividualsAxiomBinaryConversion(axiom, firstMemberPosition, secondMemberPosition, memberConunction, bottom);
        }
    }

    private static interface DisjointnessIndexer<A extends ElkAxiom, M extends ElkObject> {
        public ModifiableIndexedClassExpression convert(M var1);

        public void indexNary(A var1, ModifiableIndexedClassExpressionList var2);

        public void indexBinary(A var1, int var2, int var3, ModifiableIndexedObjectIntersectionOf var4, ModifiableIndexedClass var5);
    }
}

