/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.conversion;

import java.util.ArrayList;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataHasValue;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectComplementOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasValue;
import org.semanticweb.elk.owl.interfaces.ElkObjectIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectOneOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkObjectUnionOf;
import org.semanticweb.elk.owl.predefined.ElkPolarity;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.owl.visitors.ElkIndividualVisitor;
import org.semanticweb.elk.owl.visitors.ElkObjectPropertyExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.classes.ModifiableIndexedObjectBaseFactory;
import org.semanticweb.elk.reasoner.indexing.classes.ResolvingModifiableIndexedObjectFactory;
import org.semanticweb.elk.reasoner.indexing.classes.UpdatingModifiableIndexedObjectFactory;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.FailingElkPolarityExpressionConverter;
import org.semanticweb.elk.reasoner.indexing.model.IndexingListener;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedObject;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.Occurrence;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;

public class ElkPolarityExpressionConverterImpl
extends FailingElkPolarityExpressionConverter {
    private final PredefinedElkClassFactory elkFactory_;
    private final ModifiableIndexedObject.Factory factory_;
    private final ElkPolarityExpressionConverter complementaryConverter_;
    private final IndexingListener indexingListener_;

    ElkPolarityExpressionConverterImpl(ElkPolarity polarity, PredefinedElkClassFactory elkFactory, ModifiableIndexedObject.Factory factory, ElkPolarityExpressionConverter complementaryConverter, IndexingListener indexingListener) {
        super(polarity);
        this.elkFactory_ = elkFactory;
        this.factory_ = factory;
        this.complementaryConverter_ = complementaryConverter;
        this.indexingListener_ = indexingListener;
    }

    public ElkPolarityExpressionConverterImpl(ElkPolarity polarity, PredefinedElkClassFactory elkFactory, ModifiableIndexedObject.Factory factory, ModifiableIndexedObject.Factory complementaryFactory, IndexingListener indexingListener) {
        super(polarity);
        this.elkFactory_ = elkFactory;
        this.factory_ = factory;
        this.complementaryConverter_ = new ElkPolarityExpressionConverterImpl(polarity.getComplementary(), elkFactory, complementaryFactory, this, indexingListener);
        this.indexingListener_ = indexingListener;
    }

    public ElkPolarityExpressionConverterImpl(PredefinedElkClassFactory elkFactory, ModifiableIndexedObject.Factory dualFactory, IndexingListener indexingListener) {
        super(ElkPolarity.DUAL);
        this.elkFactory_ = elkFactory;
        this.factory_ = dualFactory;
        this.complementaryConverter_ = this;
        this.indexingListener_ = indexingListener;
    }

    public ElkPolarityExpressionConverterImpl(PredefinedElkClassFactory elkFactory, ModifiableOntologyIndex index, int increment) {
        this(elkFactory, new UpdatingModifiableIndexedObjectFactory(new ModifiableIndexedObjectBaseFactory(), index, OccurrenceIncrement.getDualIncrement(increment)), index);
    }

    public ElkPolarityExpressionConverterImpl(PredefinedElkClassFactory elkFactory, ModifiableOntologyIndex index) {
        this(elkFactory, new ResolvingModifiableIndexedObjectFactory(index), index);
    }

    @Override
    public ElkPolarityExpressionConverter getComplementaryConverter() {
        return this.complementaryConverter_;
    }

    @Override
    public ModifiableIndexedIndividual visit(ElkNamedIndividual elkNamedIndividual) {
        return this.factory_.getIndexedIndividual(elkNamedIndividual);
    }

    @Override
    public ModifiableIndexedObjectProperty visit(ElkObjectProperty elkObjectProperty) {
        return this.factory_.getIndexedObjectProperty(elkObjectProperty);
    }

    @Override
    public ModifiableIndexedClassExpression visit(ElkClass elkClass) {
        return this.factory_.getIndexedClass(elkClass);
    }

    @Override
    public ModifiableIndexedClassExpression visit(ElkObjectHasValue elkObjectHasValue) {
        return this.factory_.getIndexedObjectSomeValuesFrom((ModifiableIndexedObjectProperty)((ElkObjectPropertyExpression)elkObjectHasValue.getProperty()).accept((ElkObjectPropertyExpressionVisitor)this), (ModifiableIndexedClassExpression)((ElkIndividual)elkObjectHasValue.getFiller()).accept((ElkIndividualVisitor)this));
    }

    @Override
    public ModifiableIndexedClassExpression visit(ElkObjectComplementOf elkObjectComplementOf) {
        return this.factory_.getIndexedObjectComplementOf((ModifiableIndexedClassExpression)elkObjectComplementOf.getClassExpression().accept((ElkClassExpressionVisitor)this.complementaryConverter_));
    }

    @Override
    public ModifiableIndexedClassExpression visit(ElkObjectIntersectionOf elkObjectIntersectionOf) {
        int size = elkObjectIntersectionOf.getClassExpressions().size();
        switch (size) {
            case 0: {
                return this.factory_.getIndexedClass(this.elkFactory_.getOwlThing());
            }
        }
        ModifiableIndexedClassExpression result = null;
        for (ElkClassExpression conjunct : elkObjectIntersectionOf.getClassExpressions()) {
            ModifiableIndexedClassExpression ice = (ModifiableIndexedClassExpression)conjunct.accept((ElkClassExpressionVisitor)this);
            if (result == null) {
                result = ice;
                continue;
            }
            result = this.factory_.getIndexedObjectIntersectionOf(result, ice);
        }
        return result;
    }

    @Override
    public ModifiableIndexedClassExpression visit(ElkObjectSomeValuesFrom elkObjectSomeValuesFrom) {
        return this.factory_.getIndexedObjectSomeValuesFrom((ModifiableIndexedObjectProperty)((ElkObjectPropertyExpression)elkObjectSomeValuesFrom.getProperty()).accept((ElkObjectPropertyExpressionVisitor)this), (ModifiableIndexedClassExpression)((ElkClassExpression)elkObjectSomeValuesFrom.getFiller()).accept((ElkClassExpressionVisitor)this));
    }

    @Override
    public ModifiableIndexedClassExpression visit(ElkObjectOneOf elkObjectOneOf) {
        int size = elkObjectOneOf.getIndividuals().size();
        switch (size) {
            case 0: {
                return this.factory_.getIndexedClass(this.elkFactory_.getOwlNothing());
            }
            case 1: {
                this.indexingListener_.onIndexing(Occurrence.OCCURRENCE_OF_NOMINAL);
                return (ModifiableIndexedClassExpression)((ElkIndividual)elkObjectOneOf.getIndividuals().iterator().next()).accept((ElkIndividualVisitor)this);
            }
        }
        ArrayList<Object> disjuncts = new ArrayList<Object>(size);
        for (ElkIndividual member : elkObjectOneOf.getIndividuals()) {
            disjuncts.add(member.accept((ElkIndividualVisitor)this));
        }
        return this.factory_.getIndexedObjectUnionOf(disjuncts);
    }

    @Override
    public ModifiableIndexedClassExpression visit(ElkObjectUnionOf elkObjectUnionOf) {
        int size = elkObjectUnionOf.getClassExpressions().size();
        switch (size) {
            case 0: {
                return this.factory_.getIndexedClass(this.elkFactory_.getOwlNothing());
            }
            case 1: {
                return (ModifiableIndexedClassExpression)((ElkClassExpression)elkObjectUnionOf.getClassExpressions().iterator().next()).accept((ElkClassExpressionVisitor)this);
            }
        }
        ArrayList<Object> disjuncts = new ArrayList<Object>(size);
        for (ElkClassExpression disjunct : elkObjectUnionOf.getClassExpressions()) {
            disjuncts.add(disjunct.accept((ElkClassExpressionVisitor)this));
        }
        return this.factory_.getIndexedObjectUnionOf(disjuncts);
    }

    @Override
    public ModifiableIndexedClassExpression visit(ElkDataHasValue elkDataHasValue) {
        this.indexingListener_.onIndexing(Occurrence.OCCURRENCE_OF_DATA_HAS_VALUE);
        return this.factory_.getIndexedDataHasValue(elkDataHasValue);
    }
}

