/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.liveontologies.puli.Proof;
import org.liveontologies.puli.Proofs;
import org.semanticweb.elk.reasoner.entailments.model.Entailment;
import org.semanticweb.elk.reasoner.entailments.model.EntailmentInference;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.query.AbstractIndexedEntailmentQuery;
import org.semanticweb.elk.reasoner.query.ElkQueryException;
import org.semanticweb.elk.reasoner.query.IndexedEntailmentQuery;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SaturationConclusion;
import org.semanticweb.elk.reasoner.saturation.context.Context;

public abstract class AbstractEntailmentQueryWithPremises<E extends Entailment, P extends IndexedEntailmentQuery<? extends Entailment>>
extends AbstractIndexedEntailmentQuery<E> {
    private final List<P> premises_;

    public AbstractEntailmentQueryWithPremises(E query, List<P> premises) {
        super(query);
        this.premises_ = premises;
    }

    public List<P> getPremises() {
        return this.premises_;
    }

    @Override
    public Collection<? extends IndexedContextRoot> getPositivelyIndexed() {
        ArrayList<IndexedContextRoot> result = new ArrayList<IndexedContextRoot>(this.premises_.size());
        for (IndexedEntailmentQuery subsumption : this.premises_) {
            result.addAll(subsumption.getPositivelyIndexed());
        }
        return result;
    }

    @Override
    public <C extends Context> Proof<EntailmentInference> getEvidence(boolean atMostOne, SaturationState<C> saturationState, SaturationConclusion.Factory conclusionFactory) throws ElkQueryException {
        ArrayList<Proof<EntailmentInference>> proofs = new ArrayList<Proof<EntailmentInference>>();
        for (IndexedEntailmentQuery premise : this.premises_) {
            proofs.add(premise.getEvidence(atMostOne, saturationState, conclusionFactory));
        }
        proofs.add(new Proof<EntailmentInference>(){

            public Collection<? extends EntailmentInference> getInferences(Object conclusion) {
                if (!AbstractEntailmentQueryWithPremises.this.getQuery().equals(conclusion)) {
                    return Collections.emptyList();
                }
                return AbstractEntailmentQueryWithPremises.this.getEntailmentInference();
            }
        });
        return Proofs.union(proofs);
    }

    protected abstract Collection<? extends EntailmentInference> getEntailmentInference();
}

