/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.query;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDifferentIndividualsAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectOneOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSameIndividualAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.predefined.ElkPolarity;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.owl.visitors.DummyElkAxiomVisitor;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.owl.visitors.ElkIndividualVisitor;
import org.semanticweb.elk.reasoner.entailments.impl.ClassAssertionAxiomEntailmentImpl;
import org.semanticweb.elk.reasoner.entailments.impl.DifferentIndividualsAxiomEntailmentImpl;
import org.semanticweb.elk.reasoner.entailments.impl.DisjointClassesAxiomEntailmentImpl;
import org.semanticweb.elk.reasoner.entailments.impl.EquivalentClassesAxiomEntailmentImpl;
import org.semanticweb.elk.reasoner.entailments.impl.ObjectPropertyAssertionAxiomEntailmentImpl;
import org.semanticweb.elk.reasoner.entailments.impl.ObjectPropertyDomainAxiomEntailmentImpl;
import org.semanticweb.elk.reasoner.entailments.impl.SameIndividualAxiomEntailmentImpl;
import org.semanticweb.elk.reasoner.entailments.impl.SubClassOfAxiomEntailmentImpl;
import org.semanticweb.elk.reasoner.entailments.model.Entailment;
import org.semanticweb.elk.reasoner.indexing.classes.ModifiableIndexedObjectBaseFactory;
import org.semanticweb.elk.reasoner.indexing.classes.UpdatingModifiableIndexedObjectFactory;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkIndexingUnsupportedException;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverterImpl;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.IndexingListener;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedObject;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.semanticweb.elk.reasoner.query.ClassAssertionEntailmentQuery;
import org.semanticweb.elk.reasoner.query.DifferentIndividualsEntailmentQuery;
import org.semanticweb.elk.reasoner.query.DisjointClassesEntailmentQuery;
import org.semanticweb.elk.reasoner.query.EquivalentClassesEntailmentQuery;
import org.semanticweb.elk.reasoner.query.IndexedEntailmentQuery;
import org.semanticweb.elk.reasoner.query.ObjectPropertyAssertionEntailmentQuery;
import org.semanticweb.elk.reasoner.query.ObjectPropertyDomainEntailmentQuery;
import org.semanticweb.elk.reasoner.query.SameIndividualEntailmentQuery;
import org.semanticweb.elk.reasoner.query.SubClassOfEntailmentQuery;

public class EntailmentQueryConverter
extends DummyElkAxiomVisitor<IndexedEntailmentQuery<? extends Entailment>> {
    private final ElkObject.Factory elkFactory_;
    private final ElkPolarityExpressionConverter positiveConverter_;
    private final ElkPolarityExpressionConverter negativeConverter_;

    public EntailmentQueryConverter(ElkObject.Factory elkFactory, ModifiableOntologyIndex index, int increment) {
        this.elkFactory_ = elkFactory;
        ModifiableIndexedObjectBaseFactory baseFactory = new ModifiableIndexedObjectBaseFactory();
        UpdatingModifiableIndexedObjectFactory positiveFactory = new UpdatingModifiableIndexedObjectFactory(baseFactory, index, OccurrenceIncrement.getPositiveIncrement(increment));
        UpdatingModifiableIndexedObjectFactory negativeFactory = new UpdatingModifiableIndexedObjectFactory(baseFactory, index, OccurrenceIncrement.getNegativeIncrement(increment));
        this.positiveConverter_ = new ElkPolarityExpressionConverterImpl(ElkPolarity.POSITIVE, (PredefinedElkClassFactory)elkFactory, (ModifiableIndexedObject.Factory)positiveFactory, negativeFactory, (IndexingListener)index);
        this.negativeConverter_ = this.positiveConverter_.getComplementaryConverter();
    }

    protected IndexedEntailmentQuery<? extends Entailment> defaultVisit(ElkAxiom axiom) {
        throw new ElkIndexingUnsupportedException((ElkObject)axiom);
    }

    public ClassAssertionEntailmentQuery visit(ElkClassAssertionAxiom axiom) {
        IndexedIndividual individual = (IndexedIndividual)axiom.getIndividual().accept((ElkIndividualVisitor)this.positiveConverter_);
        IndexedClassExpression classExpression = (IndexedClassExpression)axiom.getClassExpression().accept((ElkClassExpressionVisitor)this.negativeConverter_);
        return new ClassAssertionEntailmentQuery(new ClassAssertionAxiomEntailmentImpl(axiom), individual, classExpression);
    }

    public DifferentIndividualsEntailmentQuery visit(ElkDifferentIndividualsAxiom axiom) {
        List individuals = axiom.getIndividuals();
        ArrayList<ElkObjectOneOf> nominals = new ArrayList<ElkObjectOneOf>(individuals.size());
        for (ElkIndividual individual : individuals) {
            nominals.add(this.elkFactory_.getObjectOneOf(individual, new ElkIndividual[0]));
        }
        DisjointClassesEntailmentQuery disjointness = this.visit(this.elkFactory_.getDisjointClassesAxiom(nominals));
        return new DifferentIndividualsEntailmentQuery(new DifferentIndividualsAxiomEntailmentImpl(axiom), disjointness);
    }

    public DisjointClassesEntailmentQuery visit(ElkDisjointClassesAxiom axiom) {
        List disjoint = axiom.getClassExpressions();
        int size = disjoint.size();
        ArrayList<SubClassOfEntailmentQuery> premises = new ArrayList<SubClassOfEntailmentQuery>(size);
        for (int first = 0; first < size - 1; ++first) {
            for (int second = first + 1; second < size; ++second) {
                SubClassOfEntailmentQuery subsumption = this.visit(this.elkFactory_.getSubClassOfAxiom((ElkClassExpression)this.elkFactory_.getObjectIntersectionOf((ElkClassExpression)disjoint.get(first), (ElkClassExpression)disjoint.get(second), new ElkClassExpression[0]), (ElkClassExpression)this.elkFactory_.getOwlNothing()));
                premises.add(subsumption);
            }
        }
        return new DisjointClassesEntailmentQuery(new DisjointClassesAxiomEntailmentImpl(axiom), (List<SubClassOfEntailmentQuery>)premises);
    }

    public EquivalentClassesEntailmentQuery visit(ElkEquivalentClassesAxiom axiom) {
        List elkClassExpressions = axiom.getClassExpressions();
        ArrayList<SubClassOfEntailmentQuery> subsumptionCycle = new ArrayList<SubClassOfEntailmentQuery>(elkClassExpressions.size());
        ElkClassExpression elkSubclass = (ElkClassExpression)elkClassExpressions.get(elkClassExpressions.size() - 1);
        for (int i = 0; i < elkClassExpressions.size(); ++i) {
            ElkClassExpression elkSuperclass = (ElkClassExpression)elkClassExpressions.get(i);
            SubClassOfEntailmentQuery subsumption = this.visit(this.elkFactory_.getSubClassOfAxiom(elkSubclass, elkSuperclass));
            subsumptionCycle.add(subsumption);
            elkSubclass = elkSuperclass;
        }
        return new EquivalentClassesEntailmentQuery(new EquivalentClassesAxiomEntailmentImpl(axiom), (List<SubClassOfEntailmentQuery>)subsumptionCycle);
    }

    public ObjectPropertyAssertionEntailmentQuery visit(ElkObjectPropertyAssertionAxiom axiom) {
        IndexedIndividual subject = (IndexedIndividual)((ElkIndividual)axiom.getSubject()).accept((ElkIndividualVisitor)this.positiveConverter_);
        IndexedClassExpression ovjectExistential = (IndexedClassExpression)this.elkFactory_.getObjectSomeValuesFrom((ElkObjectPropertyExpression)axiom.getProperty(), (ElkClassExpression)this.elkFactory_.getObjectOneOf((ElkIndividual)axiom.getObject(), new ElkIndividual[0])).accept((ElkClassExpressionVisitor)this.negativeConverter_);
        return new ObjectPropertyAssertionEntailmentQuery(new ObjectPropertyAssertionAxiomEntailmentImpl(axiom), subject, ovjectExistential);
    }

    public ObjectPropertyDomainEntailmentQuery visit(ElkObjectPropertyDomainAxiom axiom) {
        IndexedClassExpression existential = (IndexedClassExpression)this.elkFactory_.getObjectSomeValuesFrom((ElkObjectPropertyExpression)axiom.getProperty(), (ElkClassExpression)this.elkFactory_.getOwlThing()).accept((ElkClassExpressionVisitor)this.positiveConverter_);
        IndexedClassExpression domain = (IndexedClassExpression)((ElkClassExpression)axiom.getDomain()).accept((ElkClassExpressionVisitor)this.negativeConverter_);
        return new ObjectPropertyDomainEntailmentQuery(new ObjectPropertyDomainAxiomEntailmentImpl(axiom), existential, domain);
    }

    public SameIndividualEntailmentQuery visit(ElkSameIndividualAxiom axiom) {
        List individuals = axiom.getIndividuals();
        ArrayList<ElkObjectOneOf> nominals = new ArrayList<ElkObjectOneOf>(individuals.size());
        for (ElkIndividual individual : individuals) {
            nominals.add(this.elkFactory_.getObjectOneOf(individual, new ElkIndividual[0]));
        }
        EquivalentClassesEntailmentQuery equivalence = this.visit(this.elkFactory_.getEquivalentClassesAxiom(nominals));
        return new SameIndividualEntailmentQuery(new SameIndividualAxiomEntailmentImpl(axiom), equivalence);
    }

    public SubClassOfEntailmentQuery visit(ElkSubClassOfAxiom axiom) {
        IndexedClassExpression subClass = (IndexedClassExpression)axiom.getSubClassExpression().accept((ElkClassExpressionVisitor)this.positiveConverter_);
        IndexedClassExpression superClass = (IndexedClassExpression)axiom.getSuperClassExpression().accept((ElkClassExpressionVisitor)this.negativeConverter_);
        return new SubClassOfEntailmentQuery(new SubClassOfAxiomEntailmentImpl(axiom), subClass, superClass);
    }

    public static boolean isEntailmentCheckingSupported(Class<? extends ElkAxiom> axiomClass) {
        for (Method declaredMethod : EntailmentQueryConverter.class.getDeclaredMethods()) {
            int mod = declaredMethod.getModifiers();
            Class<?>[] parameterTypes = declaredMethod.getParameterTypes();
            if (!"visit".equals(declaredMethod.getName()) || !Modifier.isPublic(mod) || Modifier.isStatic(mod) || parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(axiomClass)) continue;
            return true;
        }
        return false;
    }
}

