/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.query;

import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.visitors.DummyElkAxiomVisitor;
import org.semanticweb.elk.owl.visitors.ElkAxiomVisitor;
import org.semanticweb.elk.reasoner.entailments.model.Entailment;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkIndexingUnsupportedException;
import org.semanticweb.elk.reasoner.indexing.model.IndexingListener;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.Occurrence;
import org.semanticweb.elk.reasoner.query.EntailmentQueryConverter;
import org.semanticweb.elk.reasoner.query.IndexedEntailmentQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntailmentQueryIndexingProcessor
extends DummyElkAxiomVisitor<IndexedEntailmentQuery<? extends Entailment>> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(EntailmentQueryIndexingProcessor.class);
    public static final String ADDITION = "addition";
    public static final String REMOVAL = "removal";
    private final EntailmentQueryConverter converter_;
    private final String type_;
    private final IndexingListener indexingListener_;

    public EntailmentQueryIndexingProcessor(ElkObject.Factory elkFactory, ModifiableOntologyIndex index, String type, IndexingListener indexingListener) {
        if (!ADDITION.equals(type) && !REMOVAL.equals(type)) {
            throw new IllegalArgumentException("type must be one of \"addition\" or \"removal\"!");
        }
        this.type_ = type;
        this.converter_ = new EntailmentQueryConverter(elkFactory, index, ADDITION.equals(type) ? 1 : -1);
        this.indexingListener_ = indexingListener;
    }

    protected IndexedEntailmentQuery<? extends Entailment> defaultVisit(ElkAxiom axiom) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace("$$ indexing {} for {}", (Object)OwlFunctionalStylePrinter.toString((ElkObject)axiom), (Object)this.type_);
        }
        try {
            return (IndexedEntailmentQuery)axiom.accept((ElkAxiomVisitor)this.converter_);
        }
        catch (ElkIndexingUnsupportedException e) {
            this.indexingListener_.onIndexing(Occurrence.OCCURRENCE_OF_UNSUPPORTED_EXPRESSION);
            return null;
        }
    }
}

