/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.liveontologies.puli.Proof;
import org.semanticweb.elk.reasoner.entailments.impl.AbstractSubClassOfAxiomEntailmentInference;
import org.semanticweb.elk.reasoner.entailments.impl.DerivedClassInclusionEntailsSubClassOfAxiomImpl;
import org.semanticweb.elk.reasoner.entailments.impl.SubClassInconsistencyEntailsSubClassOfAxiomImpl;
import org.semanticweb.elk.reasoner.entailments.model.EntailmentInference;
import org.semanticweb.elk.reasoner.entailments.model.SubClassOfAxiomEntailment;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.query.AbstractIndexedEntailmentQuery;
import org.semanticweb.elk.reasoner.query.ElkQueryException;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassInconsistency;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SaturationConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassInclusionComposed;
import org.semanticweb.elk.reasoner.saturation.context.Context;

public class SubClassOfEntailmentQuery
extends AbstractIndexedEntailmentQuery<SubClassOfAxiomEntailment> {
    private final IndexedClassExpression subClass_;
    private final IndexedClassExpression superClass_;

    public SubClassOfEntailmentQuery(SubClassOfAxiomEntailment query, IndexedClassExpression subClass, IndexedClassExpression superClass) {
        super(query);
        this.subClass_ = subClass;
        this.superClass_ = superClass;
    }

    @Override
    public Collection<? extends IndexedContextRoot> getPositivelyIndexed() {
        return Collections.singleton(this.subClass_);
    }

    @Override
    public <C extends Context> Proof<EntailmentInference> getEvidence(final boolean atMostOne, final SaturationState<C> saturationState, final SaturationConclusion.Factory conclusionFactory) throws ElkQueryException {
        return new Proof<EntailmentInference>(){

            public Collection<? extends EntailmentInference> getInferences(Object conclusion) {
                ArrayList<AbstractSubClassOfAxiomEntailmentInference> result = new ArrayList<AbstractSubClassOfAxiomEntailmentInference>(2);
                if (!((SubClassOfAxiomEntailment)SubClassOfEntailmentQuery.this.getQuery()).equals(conclusion)) {
                    return result;
                }
                Object context = saturationState.getContext(SubClassOfEntailmentQuery.this.subClass_);
                if (context == null) {
                    return result;
                }
                ClassInconsistency contradiction = conclusionFactory.getContradiction(SubClassOfEntailmentQuery.this.subClass_);
                SubClassInclusionComposed subsumption = conclusionFactory.getSubClassInclusionComposed(SubClassOfEntailmentQuery.this.subClass_, SubClassOfEntailmentQuery.this.superClass_);
                if (context.containsConclusion(contradiction)) {
                    result.add(new SubClassInconsistencyEntailsSubClassOfAxiomImpl((SubClassOfAxiomEntailment)SubClassOfEntailmentQuery.this.getQuery(), contradiction));
                    if (atMostOne) {
                        return result;
                    }
                }
                if (context.containsConclusion(subsumption)) {
                    result.add(new DerivedClassInclusionEntailsSubClassOfAxiomImpl((SubClassOfAxiomEntailment)SubClassOfEntailmentQuery.this.getQuery(), subsumption));
                }
                return result;
            }
        };
    }
}

