/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.reduction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.reasoner.ReasonerJob;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.reduction.SaturationJobForTransitiveReduction;
import org.semanticweb.elk.reasoner.reduction.SaturationJobRoot;
import org.semanticweb.elk.reasoner.reduction.SaturationJobSuperClass;
import org.semanticweb.elk.reasoner.reduction.SaturationJobVisitor;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionJob;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionListener;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalentDirect;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputUnsatisfiable;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionState;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationFactory;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.SaturationConclusionBaseFactory;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassInconsistency;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationAdditionFactory;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationInput;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitiveReductionFactory<R extends IndexedClassExpression, J extends TransitiveReductionJob<R>>
implements InputProcessorFactory<J, Engine> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(TransitiveReductionFactory.class);
    private final TransitiveReductionListener<J> listener_;
    private final SaturationOutputProcessor saturationOutputProcessor_ = new SaturationOutputProcessor();
    private final Queue<SaturationJobSuperClass<R, J>> auxJobQueue_;
    private final Queue<J> jobsWithSaturatedRoot_;
    private final ClassExpressionSaturationFactory<SaturationJobForTransitiveReduction<R, ?, J>> saturationFactory_;
    private final SaturationState<?> saturationState_;
    private final IndexedClass owlThing_;
    private final List<ElkClass> defaultTopOutput_;
    private final ClassInconsistency.Factory factory_ = new SaturationConclusionBaseFactory();

    public TransitiveReductionFactory(InterruptMonitor interrupter, SaturationState<?> saturationState, int maxWorkers, TransitiveReductionListener<J> listener) {
        this.listener_ = listener;
        this.auxJobQueue_ = new ConcurrentLinkedQueue<SaturationJobSuperClass<R, J>>();
        this.jobsWithSaturatedRoot_ = new ConcurrentLinkedQueue<J>();
        this.saturationState_ = saturationState;
        this.saturationFactory_ = new ClassExpressionSaturationFactory(new RuleApplicationAdditionFactory<RuleApplicationInput>(interrupter, saturationState), maxWorkers, new ThisClassExpressionSaturationListener());
        this.owlThing_ = saturationState.getOntologyIndex().getOwlThing();
        this.defaultTopOutput_ = new ArrayList<ElkClass>(1);
        this.defaultTopOutput_.add(this.owlThing_.getElkEntity());
    }

    public Engine getEngine() {
        return new Engine();
    }

    public void finish() {
        this.saturationFactory_.finish();
    }

    public boolean isInterrupted() {
        return this.saturationFactory_.isInterrupted();
    }

    public void printStatistics() {
        this.saturationFactory_.printStatistics();
    }

    public SaturationStatistics getRuleAndConclusionStatistics() {
        return this.saturationFactory_.getRuleAndConclusionStatistics();
    }

    private class SaturationOutputProcessor
    implements SaturationJobVisitor<R, J> {
        private SaturationOutputProcessor() {
        }

        @Override
        public void visit(SaturationJobRoot<R, J> saturationJob) throws InterruptedException {
            this.processRootSaturation(saturationJob.initiatorJob);
        }

        @Override
        public void visit(SaturationJobSuperClass<R, J> saturationJob) throws InterruptedException {
            IndexedClass candidate = (IndexedClass)saturationJob.getInput();
            TransitiveReductionState state = saturationJob.state;
            this.updateTransitiveReductionState(state, candidate);
            this.processTransitiveReductionState(state);
        }

        private void processRootSaturation(J initiatorJob) throws InterruptedException {
            IndexedClassExpression root = (IndexedClassExpression)((ReasonerJob)initiatorJob).getInput();
            Object saturation = TransitiveReductionFactory.this.saturationState_.getContext(root);
            if (saturation.containsConclusion(TransitiveReductionFactory.this.factory_.getContradiction(root))) {
                LOGGER_.trace("{}: transitive reduction finished: inconsistent", (Object)root);
                TransitiveReductionOutputUnsatisfiable<IndexedClassExpression> output = new TransitiveReductionOutputUnsatisfiable<IndexedClassExpression>(root);
                ((TransitiveReductionJob)initiatorJob).setOutput(output);
                TransitiveReductionFactory.this.listener_.notifyFinished(initiatorJob);
                return;
            }
            TransitiveReductionState state = new TransitiveReductionState(initiatorJob, TransitiveReductionFactory.this.saturationState_);
            this.processTransitiveReductionState(state);
        }

        private void processTransitiveReductionState(TransitiveReductionState<R, J> state) throws InterruptedException {
            Iterator<IndexedClassExpression> subsumerIterator = state.subsumerIterator;
            while (subsumerIterator.hasNext()) {
                IndexedClassExpression next = subsumerIterator.next();
                if (!(next instanceof IndexedClass)) continue;
                IndexedClass candidate = (IndexedClass)next;
                Object candidateSaturation = TransitiveReductionFactory.this.saturationState_.getContext(candidate);
                if (candidateSaturation == null || !candidateSaturation.isInitialized() || !candidateSaturation.isSaturated()) {
                    TransitiveReductionFactory.this.auxJobQueue_.add(new SaturationJobSuperClass(candidate, state));
                    return;
                }
                this.updateTransitiveReductionState(state, candidate);
            }
            TransitiveReductionOutputEquivalentDirect output = this.computeOutput(state);
            ((TransitiveReductionJob)state.initiatorJob).setOutput(output);
            TransitiveReductionFactory.this.listener_.notifyFinished(state.initiatorJob);
            if (LOGGER_.isTraceEnabled()) {
                Object root = output.getRoot();
                LOGGER_.trace(root + ": transitive reduction finished");
                for (ElkClass equivalent : output.getEquivalent()) {
                    LOGGER_.trace(root + ": equivalent " + equivalent.getIri());
                }
                for (IndexedClass direct : output.directSubsumers.keySet()) {
                    String message = root + ": direct super class " + direct + ": " + output.directSubsumers.get(direct);
                    LOGGER_.trace(message);
                }
            }
        }

        private void updateTransitiveReductionState(TransitiveReductionState<R, J> state, IndexedClass candidate) {
            Set<IndexedClassExpression> candidateSubsumers = TransitiveReductionFactory.this.saturationState_.getContext(candidate).getComposedSubsumers();
            int candidateSubsumersSize = candidateSubsumers.size();
            if (candidateSubsumersSize == state.subsumerCount && candidateSubsumers.contains(((ReasonerJob)state.initiatorJob).getInput())) {
                state.rootEquivalent.add(candidate.getElkEntity());
                return;
            }
            if (candidate.getElkEntity() == TransitiveReductionFactory.this.owlThing_.getElkEntity() && candidateSubsumersSize == 1) {
                return;
            }
            if (candidateSubsumersSize > state.prunedSubsumers.size()) {
                Iterator<IndexedClass> iteratorPrunedSubsumers = state.prunedSubsumers.iterator();
                while (iteratorPrunedSubsumers.hasNext()) {
                    IndexedClass prunedSubsumer = iteratorPrunedSubsumers.next();
                    Set<IndexedClassExpression> prunedSubsumerSubsumers = TransitiveReductionFactory.this.saturationState_.getContext(prunedSubsumer).getComposedSubsumers();
                    if (candidateSubsumersSize > prunedSubsumerSubsumers.size()) {
                        if (!candidateSubsumers.contains(prunedSubsumer)) continue;
                        iteratorPrunedSubsumers.remove();
                        continue;
                    }
                    if (!prunedSubsumerSubsumers.contains(candidate) || candidateSubsumersSize == prunedSubsumerSubsumers.size()) continue;
                    return;
                }
            } else {
                for (IndexedClassExpression candidateSubsumer : candidateSubsumers) {
                    if (!(candidateSubsumer instanceof IndexedClass) || !state.prunedSubsumers.contains(candidateSubsumer)) continue;
                    IndexedClass prunedSubsumer = (IndexedClass)candidateSubsumer;
                    Set<IndexedClassExpression> prunedSubsumerSubsumers = TransitiveReductionFactory.this.saturationState_.getContext(prunedSubsumer).getComposedSubsumers();
                    if (candidateSubsumersSize <= prunedSubsumerSubsumers.size()) continue;
                    state.prunedSubsumers.remove(prunedSubsumer);
                }
            }
            state.prunedSubsumers.add(candidate);
        }

        private TransitiveReductionOutputEquivalentDirect<R> computeOutput(TransitiveReductionState<R, J> state) {
            IndexedClassExpression root = (IndexedClassExpression)((ReasonerJob)state.initiatorJob).getInput();
            TransitiveReductionOutputEquivalentDirect<IndexedClassExpression> output = new TransitiveReductionOutputEquivalentDirect<IndexedClassExpression>(root, state.rootEquivalent);
            if (state.prunedSubsumers.isEmpty() && !output.getEquivalent().contains(TransitiveReductionFactory.this.owlThing_.getElkEntity())) {
                output.directSubsumers.put(TransitiveReductionFactory.this.owlThing_, TransitiveReductionFactory.this.defaultTopOutput_);
                return output;
            }
            for (IndexedClassExpression subsumer : TransitiveReductionFactory.this.saturationState_.getContext(root).getComposedSubsumers()) {
                if (!(subsumer instanceof IndexedClass) || !state.prunedSubsumers.contains(subsumer)) continue;
                IndexedClass candidate = (IndexedClass)subsumer;
                Set<IndexedClassExpression> candidateSubsumers = TransitiveReductionFactory.this.saturationState_.getContext(candidate).getComposedSubsumers();
                int candidateSubsumersSize = candidateSubsumers.size();
                ArrayList<ElkClass> candidateEquivalent = new ArrayList<ElkClass>(1);
                if (candidateSubsumersSize > state.prunedSubsumers.size()) {
                    Iterator<IndexedClass> iteratorPrunedSubsumers = state.prunedSubsumers.iterator();
                    while (iteratorPrunedSubsumers.hasNext()) {
                        IndexedClass prunedSubsumer = iteratorPrunedSubsumers.next();
                        Set<IndexedClassExpression> prunedSubsumerSubsumers = TransitiveReductionFactory.this.saturationState_.getContext(prunedSubsumer).getComposedSubsumers();
                        if (candidateSubsumersSize < prunedSubsumerSubsumers.size() || !candidateSubsumers.contains(prunedSubsumer)) continue;
                        iteratorPrunedSubsumers.remove();
                        if (candidateSubsumersSize != prunedSubsumerSubsumers.size() || !prunedSubsumerSubsumers.contains(candidate)) continue;
                        candidateEquivalent.add(prunedSubsumer.getElkEntity());
                    }
                } else {
                    for (IndexedClassExpression candidateSubsumer : candidateSubsumers) {
                        if (!(candidateSubsumer instanceof IndexedClass) || !state.prunedSubsumers.contains(candidateSubsumer)) continue;
                        IndexedClass prunedSubsumer = (IndexedClass)candidateSubsumer;
                        Set<IndexedClassExpression> prunedSubsumerSubsumers = TransitiveReductionFactory.this.saturationState_.getContext(prunedSubsumer).getComposedSubsumers();
                        if (candidateSubsumersSize < prunedSubsumerSubsumers.size() || !candidateSubsumers.contains(prunedSubsumer)) continue;
                        state.prunedSubsumers.remove(candidateSubsumer);
                        if (candidateSubsumersSize != prunedSubsumerSubsumers.size() || !prunedSubsumerSubsumers.contains(candidate)) continue;
                        candidateEquivalent.add(prunedSubsumer.getElkEntity());
                    }
                }
                output.directSubsumers.put(candidate, candidateEquivalent);
                if (!LOGGER_.isTraceEnabled()) continue;
                LOGGER_.trace("{}: new direct subsumer {} [{}]", new Object[]{root, candidate, candidateEquivalent});
            }
            if (!state.prunedSubsumers.isEmpty()) {
                LOGGER_.error("{}: pruned subsumers not removed: {}", (Object)root, state.prunedSubsumers);
            }
            return output;
        }
    }

    private class ThisClassExpressionSaturationListener
    implements ClassExpressionSaturationListener<SaturationJobForTransitiveReduction<R, ?, J>> {
        private ThisClassExpressionSaturationListener() {
        }

        public void notifyFinished(SaturationJobForTransitiveReduction<R, ?, J> output) throws InterruptedException {
            output.accept(TransitiveReductionFactory.this.saturationOutputProcessor_);
        }
    }

    public class Engine
    implements InputProcessor<J> {
        private final ClassExpressionSaturationFactory.Engine saturationEngine;

        private Engine() {
            this.saturationEngine = TransitiveReductionFactory.this.saturationFactory_.getEngine();
        }

        public final void submit(J job) {
            IndexedClassExpression root = (IndexedClassExpression)((ReasonerJob)job).getInput();
            LOGGER_.trace("{}: transitive reduction started", (Object)root);
            Object context = TransitiveReductionFactory.this.saturationState_.getContext(root);
            if (context != null && context.isInitialized() && context.isSaturated()) {
                TransitiveReductionFactory.this.jobsWithSaturatedRoot_.add(job);
            } else {
                this.saturationEngine.submit(new SaturationJobRoot(job));
            }
        }

        public final void process() throws InterruptedException {
            while (true) {
                if (TransitiveReductionFactory.this.isInterrupted()) {
                    return;
                }
                TransitiveReductionJob processedJob = (TransitiveReductionJob)TransitiveReductionFactory.this.jobsWithSaturatedRoot_.poll();
                if (processedJob != null) {
                    TransitiveReductionFactory.this.saturationOutputProcessor_.processRootSaturation(processedJob);
                    continue;
                }
                this.saturationEngine.process();
                SaturationJobForTransitiveReduction nextJob = (SaturationJobForTransitiveReduction)TransitiveReductionFactory.this.auxJobQueue_.poll();
                if (nextJob == null) break;
                this.saturationEngine.submit(nextJob);
            }
        }

        public void finish() {
            this.saturationEngine.finish();
        }
    }
}

