/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.OntologyIndex;
import org.semanticweb.elk.reasoner.saturation.ContextCreatingSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextFactory;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.ExtendedContext;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaturationState<EC extends ExtendedContext>
implements SaturationState<EC> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(AbstractSaturationState.class);
    final OntologyIndex ontologyIndex;
    private final Queue<Context> activeContexts_ = new ConcurrentLinkedQueue<Context>();
    private final Queue<EC> notSaturatedContexts_ = new ConcurrentLinkedQueue<EC>();
    private final AtomicInteger contextMarkNonSaturatedLower_ = new AtomicInteger(0);
    private final AtomicInteger contextSetSaturatedUpper_ = new AtomicInteger(0);
    private final AtomicInteger contextSetSaturatedLower_ = new AtomicInteger(0);
    private final ContextFactory<EC> contextFactory;
    private final List<SaturationState.ChangeListener<EC>> listeners_ = new ArrayList<SaturationState.ChangeListener<EC>>();

    public AbstractSaturationState(OntologyIndex index, ContextFactory<EC> factory) {
        this.ontologyIndex = index;
        this.contextFactory = factory;
    }

    @Override
    public OntologyIndex getOntologyIndex() {
        return this.ontologyIndex;
    }

    @Override
    public Collection<EC> getNotSaturatedContexts() {
        return Collections.unmodifiableCollection(new AbstractCollection<EC>(){

            @Override
            public Iterator<EC> iterator() {
                return AbstractSaturationState.this.notSaturatedContexts_.iterator();
            }

            @Override
            public int size() {
                return AbstractSaturationState.this.contextMarkNonSaturatedLower_.get() - AbstractSaturationState.this.contextSetSaturatedLower_.get();
            }
        });
    }

    @Override
    public int getContextMarkNonSaturatedCount() {
        return this.contextMarkNonSaturatedLower_.get();
    }

    @Override
    public int getContextSetSaturatedCount() {
        return this.contextSetSaturatedLower_.get();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setContextsSaturated(int saturatedContextLimit) {
        block0: while (true) {
            if ((contextSetSaturatedUpperSnapshot = this.contextSetSaturatedUpper_.get()) >= saturatedContextLimit) {
                return;
            }
            if (contextSetSaturatedUpperSnapshot >= this.contextMarkNonSaturatedLower_.get()) {
                next = (ExtendedContext)this.notSaturatedContexts_.peek();
                if (next != null) {
                    AbstractSaturationState.LOGGER_.error("{}: was not marked as saturated", (Object)next);
                }
                return;
            }
            if (!this.contextSetSaturatedUpper_.compareAndSet(contextSetSaturatedUpperSnapshot, contextSetSaturatedUpperSnapshot + 1)) continue;
            next = (ExtendedContext)this.notSaturatedContexts_.poll();
            if (next.setSaturated(true)) {
                AbstractSaturationState.LOGGER_.error("{}: was marked as saturated already", (Object)next);
            }
            AbstractSaturationState.LOGGER_.trace("{}: marked as saturated", (Object)next);
            this.contextSetSaturatedLower_.incrementAndGet();
            i = 0;
            while (true) {
                if (i < this.listeners_.size()) ** break;
                continue block0;
                this.listeners_.get(i).contextMarkSaturated(next);
                ++i;
            }
            break;
        }
    }

    @Override
    public SaturationStateWriter<EC> getContextModifyingWriter(ContextModificationListener contextModificationListener) {
        return new ContextModifyingWriter(contextModificationListener);
    }

    @Override
    public SaturationStateWriter<EC> getContextModifyingWriter() {
        return this.getContextModifyingWriter(ContextModificationListener.DUMMY);
    }

    @Override
    public ContextCreatingSaturationStateWriter<EC> getContextCreatingWriter(ContextCreationListener contextCreationListener, ContextModificationListener contextModificationListener) {
        return new ContextCreatingWriter(contextCreationListener, contextModificationListener);
    }

    @Override
    public ContextCreatingSaturationStateWriter<EC> getContextCreatingWriter() {
        return this.getContextCreatingWriter(ContextCreationListener.DUMMY, ContextModificationListener.DUMMY);
    }

    @Override
    public boolean addListener(SaturationState.ChangeListener<EC> listener) {
        return this.listeners_.add(listener);
    }

    @Override
    public boolean removeListener(SaturationState.ChangeListener<EC> listener) {
        return this.listeners_.remove(listener);
    }

    @Override
    public abstract EC getContext(IndexedContextRoot var1);

    int getChangeListenerCount() {
        return this.listeners_.size();
    }

    SaturationState.ChangeListener<EC> getChangeListener(int index) {
        return this.listeners_.get(index);
    }

    abstract void resetContexts();

    private void reset() {
        this.resetContexts();
        this.activeContexts_.clear();
        this.notSaturatedContexts_.clear();
        this.contextMarkNonSaturatedLower_.set(0);
        this.contextSetSaturatedUpper_.set(0);
        this.contextSetSaturatedLower_.set(0);
    }

    abstract EC setIfAbsent(EC var1);

    class ContextModifyingWriter
    implements SaturationStateWriter<EC> {
        private final ContextModificationListener contextModificationListener_;

        private ContextModifyingWriter(ContextModificationListener contextSaturationListener) {
            this.contextModificationListener_ = contextSaturationListener;
        }

        @Override
        public Context pollForActiveContext() {
            return (Context)AbstractSaturationState.this.activeContexts_.poll();
        }

        void produce(Context context, ClassInference inference) {
            LOGGER_.trace("{}: new inference {}", (Object)context, (Object)inference);
            if (context.addToDo(inference)) {
                LOGGER_.trace("{}: activated", (Object)context);
                AbstractSaturationState.this.activeContexts_.add(context);
            }
        }

        @Override
        public void produce(ClassInference inference) {
            this.produce(AbstractSaturationState.this.getContext(inference.getDestination()), inference);
        }

        void markAsNotSaturatedInternal(EC context) {
            LOGGER_.trace("{}: marked as non-saturated", context);
            AbstractSaturationState.this.notSaturatedContexts_.add(context);
            AbstractSaturationState.this.contextMarkNonSaturatedLower_.incrementAndGet();
            this.contextModificationListener_.notifyContextModification((Context)context);
            for (int i = 0; i < AbstractSaturationState.this.listeners_.size(); ++i) {
                ((SaturationState.ChangeListener)AbstractSaturationState.this.listeners_.get(i)).contextMarkNonSaturated(context);
            }
        }

        @Override
        public boolean markAsNotSaturated(IndexedContextRoot root) {
            Context context = AbstractSaturationState.this.getContext(root);
            if (context == null) {
                return false;
            }
            if (context.setSaturated(false)) {
                this.markAsNotSaturatedInternal(context);
                return true;
            }
            return false;
        }

        @Override
        public void resetContexts() {
            AbstractSaturationState.this.reset();
        }

        @Override
        public SaturationState<EC> getSaturationState() {
            return AbstractSaturationState.this;
        }
    }

    protected class ContextCreatingWriter
    extends ContextModifyingWriter
    implements ContextCreatingSaturationStateWriter<EC> {
        private final ContextCreationListener contextCreationListener_;

        protected ContextCreatingWriter(ContextCreationListener contextCreationListener, ContextModificationListener contextModificationListener) {
            super(contextModificationListener);
            this.contextCreationListener_ = contextCreationListener;
        }

        protected ContextCreatingWriter() {
            super(ContextModificationListener.DUMMY);
            this.contextCreationListener_ = ContextCreationListener.DUMMY;
        }

        @Override
        public void produce(ClassInference inference) {
            this.produce(this.getCreateContext(inference.getDestination()), inference);
        }

        @Override
        public EC getCreateContext(IndexedContextRoot root) {
            Context previous = AbstractSaturationState.this.getContext(root);
            if (previous != null) {
                return previous;
            }
            Object newContext = AbstractSaturationState.this.contextFactory.createContext(root);
            previous = AbstractSaturationState.this.setIfAbsent(newContext);
            if (previous != null) {
                return previous;
            }
            this.contextCreationListener_.notifyContextCreation((Context)newContext);
            LOGGER_.trace("{}: context created", newContext);
            return newContext;
        }
    }
}

