/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationListener;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationJob;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationFactory;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationInput;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassExpressionSaturationFactory<J extends SaturationJob<? extends IndexedContextRoot>>
implements InputProcessorFactory<J, Engine> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ClassExpressionSaturationFactory.class);
    private final ClassExpressionSaturationListener<J> listener_;
    private final RuleApplicationFactory<?, RuleApplicationInput> ruleApplicationFactory_;
    private final SaturationState<?> saturationState_;
    private final Queue<J> jobsToDo_;
    private final Queue<J> jobsInProgress_;
    private final AtomicInteger countJobsSubmittedUpper_ = new AtomicInteger(0);
    private final AtomicInteger countJobsProcessedLower_ = new AtomicInteger(0);
    private final AtomicInteger countJobsFinishedUpper_ = new AtomicInteger(0);
    private final AtomicInteger countContextsSaturatedLower_ = new AtomicInteger(0);
    private final int threshold_;
    private volatile boolean workersWaiting_ = false;
    private final AtomicInteger countStartedWorkers_ = new AtomicInteger(0);
    private final AtomicInteger countFinishedWorkers_ = new AtomicInteger(0);
    private final ThisStatistics aggregatedStats_;
    private final ReentrantLock stopWorkersLock_ = new ReentrantLock();
    private final Condition thereAreContextsToProcess_ = this.stopWorkersLock_.newCondition();

    public ClassExpressionSaturationFactory(RuleApplicationFactory<?, RuleApplicationInput> ruleAppFactory, int maxWorkers, ClassExpressionSaturationListener<J> listener) {
        this.threshold_ = 64 + 32 * maxWorkers;
        this.listener_ = listener;
        this.jobsToDo_ = new ConcurrentLinkedQueue<J>();
        this.jobsInProgress_ = new ConcurrentLinkedQueue<J>();
        this.ruleApplicationFactory_ = ruleAppFactory;
        this.saturationState_ = ruleAppFactory.getSaturationState();
        this.aggregatedStats_ = new ThisStatistics();
    }

    public ClassExpressionSaturationFactory(RuleApplicationFactory<?, RuleApplicationInput> ruleAppFactory, int maxWorkers) {
        this(ruleAppFactory, maxWorkers, new ClassExpressionSaturationListener<J>(){

            public void notifyFinished(J job) throws InterruptedException {
            }
        });
    }

    public Engine getEngine() {
        return new Engine();
    }

    public void printStatistics() {
        this.ruleApplicationFactory_.getSaturationStatistics().print(LOGGER_);
        if (LOGGER_.isDebugEnabled()) {
            if (this.aggregatedStats_.jobsSubmittedNo > 0) {
                LOGGER_.debug("Saturation Jobs Submitted=Done+Processed: {}={}+{}", new Object[]{this.aggregatedStats_.jobsSubmittedNo, this.aggregatedStats_.jobsAlreadyDoneNo, this.aggregatedStats_.jobsProcessedNo});
            }
            LOGGER_.debug("Locks: " + this.aggregatedStats_.locks);
        }
    }

    public boolean isInterrupted() {
        return this.ruleApplicationFactory_.isInterrupted();
    }

    public void finish() {
        this.checkStatistics();
    }

    private void checkStatistics() {
        if (this.aggregatedStats_.jobsSubmittedNo != this.aggregatedStats_.jobsAlreadyDoneNo + this.aggregatedStats_.jobsProcessedNo) {
            LOGGER_.error("Some submitted saturation jobs were not processed!");
        }
    }

    public SaturationStatistics getRuleAndConclusionStatistics() {
        return this.ruleApplicationFactory_.getSaturationStatistics();
    }

    private void wakeUpWorkers() {
        if (!this.workersWaiting_) {
            return;
        }
        this.stopWorkersLock_.lock();
        try {
            this.workersWaiting_ = false;
            this.thereAreContextsToProcess_.signalAll();
        }
        finally {
            this.stopWorkersLock_.unlock();
        }
    }

    private void updateProcessedCounters(int snapshotFinishedWorkers) {
        if (this.isInterrupted()) {
            this.wakeUpWorkers();
            return;
        }
        if (this.countStartedWorkers_.get() > snapshotFinishedWorkers) {
            return;
        }
        int snapshotCountJobsSubmitted = this.countJobsSubmittedUpper_.get();
        int snapshotCountContextNonSaturated = this.saturationState_.getContextMarkNonSaturatedCount();
        int snapshotCountStartedWorkers = this.countStartedWorkers_.get();
        if (snapshotCountStartedWorkers > snapshotFinishedWorkers) {
            return;
        }
        if (ClassExpressionSaturationFactory.updateIfSmaller(this.countContextsSaturatedLower_, snapshotCountContextNonSaturated)) {
            this.wakeUpWorkers();
        }
        ClassExpressionSaturationFactory.updateIfSmaller(this.countJobsProcessedLower_, snapshotCountJobsSubmitted);
    }

    private void updateFinishedCounters(ThisStatistics localStatistics) throws InterruptedException {
        int snapshotJobsFinished;
        int snapshotJobsProcessed = this.countJobsProcessedLower_.get();
        while (true) {
            int snapshotCountContextsSaturatedLower = this.countContextsSaturatedLower_.get();
            this.saturationState_.setContextsSaturated(snapshotCountContextsSaturatedLower);
            if (this.saturationState_.getContextSetSaturatedCount() < snapshotCountContextsSaturatedLower) {
                return;
            }
            int updatedSnapshotJobsProcessed = this.countJobsProcessedLower_.get();
            if (updatedSnapshotJobsProcessed == snapshotJobsProcessed) break;
            snapshotJobsProcessed = updatedSnapshotJobsProcessed;
        }
        while ((snapshotJobsFinished = this.countJobsFinishedUpper_.get()) < snapshotJobsProcessed) {
            if (!this.countJobsFinishedUpper_.compareAndSet(snapshotJobsFinished, snapshotJobsFinished + 1)) continue;
            SaturationJob nextJob = (SaturationJob)this.jobsInProgress_.poll();
            IndexedContextRoot root = (IndexedContextRoot)nextJob.getInput();
            Object rootSaturation = this.saturationState_.getContext(root);
            if (rootSaturation.isInitialized() && !rootSaturation.isSaturated()) {
                LOGGER_.error("{}: context for a finished job not saturated!", rootSaturation);
            }
            nextJob.setOutput((Context)rootSaturation);
            LOGGER_.trace("{}: saturation finished", (Object)root);
            ++localStatistics.jobsProcessedNo;
            this.listener_.notifyFinished(nextJob);
        }
    }

    private static boolean updateIfSmaller(AtomicInteger counter, int value) {
        int snapshotCoutner;
        do {
            if ((snapshotCoutner = counter.get()) < value) continue;
            return false;
        } while (!counter.compareAndSet(snapshotCoutner, value));
        return true;
    }

    private static class ThisStatistics {
        int jobsSubmittedNo;
        int jobsAlreadyDoneNo;
        int jobsProcessedNo;
        int locks;

        private ThisStatistics() {
        }

        public synchronized void merge(ThisStatistics statistics) {
            this.jobsSubmittedNo += statistics.jobsSubmittedNo;
            this.jobsProcessedNo += statistics.jobsProcessedNo;
            this.jobsAlreadyDoneNo += statistics.jobsAlreadyDoneNo;
            this.locks += statistics.locks;
        }
    }

    public class Engine
    implements InputProcessor<J> {
        private final InputProcessor<RuleApplicationInput> ruleApplicationEngine_;
        private final ThisStatistics stats_;

        private Engine() {
            this.ruleApplicationEngine_ = ClassExpressionSaturationFactory.this.ruleApplicationFactory_.getEngine(ContextCreationListener.DUMMY, ContextModificationListener.DUMMY);
            this.stats_ = new ThisStatistics();
        }

        public void submit(J job) {
            ClassExpressionSaturationFactory.this.jobsToDo_.add(job);
            ++this.stats_.jobsSubmittedNo;
        }

        public void process() throws InterruptedException {
            ClassExpressionSaturationFactory.this.countStartedWorkers_.incrementAndGet();
            this.ruleApplicationEngine_.process();
            ClassExpressionSaturationFactory.this.updateProcessedCounters(ClassExpressionSaturationFactory.this.countFinishedWorkers_.incrementAndGet());
            ClassExpressionSaturationFactory.this.updateFinishedCounters(this.stats_);
            while (!ClassExpressionSaturationFactory.this.isInterrupted()) {
                int snapshotCountSaturated = ClassExpressionSaturationFactory.this.countContextsSaturatedLower_.get();
                if (ClassExpressionSaturationFactory.this.saturationState_.getContextMarkNonSaturatedCount() - snapshotCountSaturated > ClassExpressionSaturationFactory.this.threshold_) {
                    ClassExpressionSaturationFactory.this.stopWorkersLock_.lock();
                    try {
                        ClassExpressionSaturationFactory.this.workersWaiting_ = true;
                        ++this.stats_.locks;
                        if (ClassExpressionSaturationFactory.this.countContextsSaturatedLower_.get() > snapshotCountSaturated || ClassExpressionSaturationFactory.this.isInterrupted()) {
                            ClassExpressionSaturationFactory.this.workersWaiting_ = false;
                            ClassExpressionSaturationFactory.this.thereAreContextsToProcess_.signalAll();
                        }
                        ClassExpressionSaturationFactory.this.thereAreContextsToProcess_.await();
                    }
                    finally {
                        ClassExpressionSaturationFactory.this.stopWorkersLock_.unlock();
                    }
                    continue;
                }
                SaturationJob nextJob = (SaturationJob)ClassExpressionSaturationFactory.this.jobsToDo_.poll();
                if (nextJob == null) {
                    return;
                }
                IndexedContextRoot root = (IndexedContextRoot)nextJob.getInput();
                Object rootContext = ClassExpressionSaturationFactory.this.saturationState_.getContext(root);
                if (rootContext != null && rootContext.isInitialized() && rootContext.isSaturated()) {
                    nextJob.setOutput((Context)rootContext);
                    ++this.stats_.jobsAlreadyDoneNo;
                    ClassExpressionSaturationFactory.this.listener_.notifyFinished(nextJob);
                    continue;
                }
                LOGGER_.trace("{}: saturation started", (Object)root);
                ClassExpressionSaturationFactory.this.countStartedWorkers_.incrementAndGet();
                ClassExpressionSaturationFactory.this.countJobsSubmittedUpper_.incrementAndGet();
                ClassExpressionSaturationFactory.this.jobsInProgress_.add(nextJob);
                this.ruleApplicationEngine_.submit((Object)new RuleApplicationInput(root));
                this.ruleApplicationEngine_.process();
                ClassExpressionSaturationFactory.this.updateProcessedCounters(ClassExpressionSaturationFactory.this.countFinishedWorkers_.incrementAndGet());
                ClassExpressionSaturationFactory.this.updateFinishedCounters(this.stats_);
            }
            return;
        }

        public void finish() {
            this.ruleApplicationEngine_.finish();
            ClassExpressionSaturationFactory.this.aggregatedStats_.merge(this.stats_);
        }
    }
}

