/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpressionList;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.ExtendedContext;
import org.semanticweb.elk.reasoner.saturation.SubContextImpl;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassInconsistency;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ContextInitialization;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.DisjointSubsumer;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.Propagation;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassInclusionComposed;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassInclusionDecomposed;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubContextInitialization;
import org.semanticweb.elk.reasoner.saturation.context.SubContext;
import org.semanticweb.elk.reasoner.saturation.context.SubContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInference;
import org.semanticweb.elk.reasoner.saturation.rules.backwardlinks.BackwardLinkChainFromBackwardLinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.backwardlinks.ContradictionOverBackwardLinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.backwardlinks.LinkableBackwardLinkRule;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.chains.AbstractChain;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.concurrent.collections.ActivationStack;
import org.semanticweb.elk.util.concurrent.collections.SynchronizedArrayListActivationStack;

public class ContextImpl
implements ExtendedContext {
    private LinkableBackwardLinkRule backwardLinkRules_ = null;
    private Set<IndexedObjectProperty> reflexiveBackwardLinks_ = null;
    private Map<IndexedObjectProperty, SubContext> subContextsByObjectProperty_ = null;
    private Map<IndexedClassExpressionList, Set<Integer>> disjointnessAxioms_;
    private volatile boolean isInconsistent_ = false;
    private volatile boolean isSaturated_ = true;
    private final IndexedContextRoot root_;
    private final Set<IndexedClassExpression> composedSubsumers_;
    private final Set<IndexedClassExpression> decomposedSubsumers_;
    private final ActivationStack<ClassInference> toDo_;
    private volatile boolean isInitialized_ = false;
    private int size = 0;

    public ContextImpl(IndexedContextRoot root) {
        this.root_ = root;
        this.toDo_ = new SynchronizedArrayListActivationStack();
        this.composedSubsumers_ = new ArrayHashSet(16);
        this.decomposedSubsumers_ = new ArrayHashSet(8);
    }

    @Override
    public boolean addConclusion(ClassConclusion conclusion) {
        boolean success = conclusion.accept(new ConclusionInserter());
        if (success) {
            ++this.size;
        }
        return success;
    }

    @Override
    public boolean removeConclusion(ClassConclusion conclusion) {
        boolean success = conclusion.accept(new ConclusionDeleter());
        if (success) {
            --this.size;
        }
        return success;
    }

    @Override
    public boolean containsConclusion(ClassConclusion conclusion) {
        return conclusion.accept(new ConclusionOccurrenceChecker());
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isEmpty(IndexedObjectProperty subRoot) {
        if (this.subContextsByObjectProperty_ == null) {
            return true;
        }
        SubContext subContext = this.subContextsByObjectProperty_.get(subRoot);
        return subContext == null || subContext.isEmpty();
    }

    @Override
    public boolean addToDo(ClassInference inference) {
        return this.toDo_.push((Object)inference);
    }

    @Override
    public Map<IndexedObjectProperty, ? extends SubContextPremises> getSubContextPremisesByObjectProperty() {
        if (this.subContextsByObjectProperty_ == null) {
            return Collections.emptyMap();
        }
        return this.subContextsByObjectProperty_;
    }

    SubContext getCreateSubContext(IndexedObjectProperty subRoot) {
        SubContext result;
        if (this.subContextsByObjectProperty_ == null) {
            this.subContextsByObjectProperty_ = new ArrayHashMap(3);
        }
        if ((result = this.subContextsByObjectProperty_.get(subRoot)) == null) {
            result = new SubContextImpl();
            this.subContextsByObjectProperty_.put(subRoot, result);
        }
        return result;
    }

    public boolean removeSubContext(IndexedPropertyChain subRoot) {
        boolean changed;
        if (this.subContextsByObjectProperty_ == null) {
            return false;
        }
        boolean bl = changed = this.subContextsByObjectProperty_.remove(subRoot) != null;
        if (changed && this.subContextsByObjectProperty_.isEmpty()) {
            this.subContextsByObjectProperty_ = null;
        }
        return changed;
    }

    @Override
    public Chain<LinkableBackwardLinkRule> getBackwardLinkRuleChain() {
        return new AbstractChain<LinkableBackwardLinkRule>(){

            public LinkableBackwardLinkRule next() {
                return ContextImpl.this.backwardLinkRules_;
            }

            public void setNext(LinkableBackwardLinkRule tail) {
                ContextImpl.this.backwardLinkRules_ = tail;
            }
        };
    }

    @Override
    public LinkableBackwardLinkRule getBackwardLinkRuleHead() {
        return this.backwardLinkRules_;
    }

    @Override
    public Set<IndexedObjectProperty> getLocalReflexiveObjectProperties() {
        return this.reflexiveBackwardLinks_ == null ? Collections.emptySet() : this.reflexiveBackwardLinks_;
    }

    @Override
    public IndexedContextRoot getRoot() {
        return this.root_;
    }

    @Override
    public Set<IndexedClassExpression> getComposedSubsumers() {
        return this.composedSubsumers_;
    }

    @Override
    public Set<IndexedClassExpression> getDecomposedSubsumers() {
        return this.decomposedSubsumers_;
    }

    @Override
    public Set<? extends Integer> getSubsumerPositions(IndexedClassExpressionList disjoint) {
        if (this.disjointnessAxioms_ == null) {
            return null;
        }
        return this.disjointnessAxioms_.get(disjoint);
    }

    @Override
    public boolean isSaturated() {
        return this.isSaturated_;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized_;
    }

    @Override
    public ClassInference takeToDo() {
        return (ClassInference)this.toDo_.pop();
    }

    public String toString() {
        return this.root_.toString() + (this != this.root_.getContext() ? "[local]" : "");
    }

    @Override
    public synchronized boolean setSaturated(boolean saturated) {
        boolean previous = this.isSaturated_;
        this.isSaturated_ = saturated;
        return previous;
    }

    @Override
    public Iterable<? extends IndexedObjectSomeValuesFrom> getPropagatedSubsumers(IndexedPropertyChain subRoot) {
        if (this.subContextsByObjectProperty_ == null) {
            return Collections.emptyList();
        }
        SubContext subContext = this.subContextsByObjectProperty_.get(subRoot);
        if (subContext == null) {
            return Collections.emptyList();
        }
        return subContext.getPropagatedSubsumers();
    }

    private class ConclusionInserter
    implements ClassConclusion.Visitor<Boolean> {
        private ConclusionInserter() {
        }

        @Override
        public Boolean visit(BackwardLink subConclusion) {
            IndexedObjectProperty relation = subConclusion.getRelation();
            SubContext subContext = ContextImpl.this.getCreateSubContext(relation);
            if (subConclusion.getTraceRoot() == ContextImpl.this.root_) {
                if (ContextImpl.this.reflexiveBackwardLinks_ == null) {
                    ContextImpl.this.reflexiveBackwardLinks_ = (Set)new ArrayHashSet(3);
                }
                return ContextImpl.this.reflexiveBackwardLinks_.add(relation);
            }
            return subContext.addSubConclusion(subConclusion);
        }

        @Override
        public Boolean visit(SubClassInclusionComposed conclusion) {
            return ContextImpl.this.composedSubsumers_.add(conclusion.getSubsumer());
        }

        @Override
        public Boolean visit(SubClassInclusionDecomposed conclusion) {
            return ContextImpl.this.decomposedSubsumers_.add(conclusion.getSubsumer());
        }

        @Override
        public Boolean visit(ContextInitialization conclusion) {
            if (ContextImpl.this.isInitialized_) {
                return false;
            }
            ContextImpl.this.isInitialized_ = true;
            return true;
        }

        @Override
        public Boolean visit(ClassInconsistency conclusion) {
            boolean before = ContextImpl.this.isInconsistent_;
            ContextImpl.this.isInconsistent_ = true;
            ContradictionOverBackwardLinkRule.addTo(ContextImpl.this);
            return before != ContextImpl.this.isInconsistent_;
        }

        @Override
        public Boolean visit(DisjointSubsumer conclusion) {
            if (ContextImpl.this.disjointnessAxioms_ == null) {
                ContextImpl.this.disjointnessAxioms_ = (Map)new ArrayHashMap();
            }
            IndexedClassExpressionList disjoint = conclusion.getDisjointExpressions();
            int position = conclusion.getPosition();
            Set positions = (Set)ContextImpl.this.disjointnessAxioms_.get(disjoint);
            if (positions == null) {
                positions = new ArrayHashSet(2);
                ContextImpl.this.disjointnessAxioms_.put(disjoint, positions);
            }
            if (positions.contains(position)) {
                return false;
            }
            positions.add(position);
            return true;
        }

        @Override
        public Boolean visit(ForwardLink conclusion) {
            return BackwardLinkChainFromBackwardLinkRule.addRuleFor(conclusion, ContextImpl.this);
        }

        @Override
        public Boolean visit(Propagation subConclusion) {
            return ContextImpl.this.getCreateSubContext(subConclusion.getSubDestination()).addSubConclusion(subConclusion);
        }

        @Override
        public Boolean visit(SubContextInitialization subConclusion) {
            return ContextImpl.this.getCreateSubContext(subConclusion.getSubDestination()).addSubConclusion(subConclusion);
        }
    }

    private class ConclusionDeleter
    implements ClassConclusion.Visitor<Boolean> {
        private ConclusionDeleter() {
        }

        @Override
        public Boolean visit(BackwardLink subConclusion) {
            boolean changed = false;
            IndexedObjectProperty relation = subConclusion.getRelation();
            SubContext subContext = ContextImpl.this.getCreateSubContext(relation);
            if (subConclusion.getTraceRoot() == ContextImpl.this.root_) {
                if (ContextImpl.this.reflexiveBackwardLinks_ != null) {
                    changed = ContextImpl.this.reflexiveBackwardLinks_.remove(relation);
                    if (ContextImpl.this.reflexiveBackwardLinks_.isEmpty()) {
                        ContextImpl.this.reflexiveBackwardLinks_ = null;
                    }
                }
            } else {
                if (subContext == null) {
                    return false;
                }
                changed = subContext.removeSubConclusion(subConclusion);
            }
            return changed;
        }

        @Override
        public Boolean visit(SubClassInclusionComposed conclusion) {
            return ContextImpl.this.composedSubsumers_.remove(conclusion.getSubsumer());
        }

        @Override
        public Boolean visit(SubClassInclusionDecomposed conclusion) {
            return ContextImpl.this.decomposedSubsumers_.remove(conclusion.getSubsumer());
        }

        @Override
        public Boolean visit(ContextInitialization conclusion) {
            if (!ContextImpl.this.isInitialized_) {
                return false;
            }
            ContextImpl.this.isInitialized_ = false;
            return true;
        }

        @Override
        public Boolean visit(ClassInconsistency conclusion) {
            boolean before = ContextImpl.this.isInconsistent_;
            ContextImpl.this.isInconsistent_ = false;
            ContradictionOverBackwardLinkRule.removeFrom(ContextImpl.this);
            return before != ContextImpl.this.isInconsistent_;
        }

        @Override
        public Boolean visit(DisjointSubsumer conclusion) {
            if (ContextImpl.this.disjointnessAxioms_ == null) {
                return false;
            }
            IndexedClassExpressionList disjoint = conclusion.getDisjointExpressions();
            int position = conclusion.getPosition();
            Set positions = (Set)ContextImpl.this.disjointnessAxioms_.get(disjoint);
            if (positions == null) {
                return false;
            }
            return positions.remove(position);
        }

        @Override
        public Boolean visit(ForwardLink conclusion) {
            return BackwardLinkChainFromBackwardLinkRule.removeRuleFor(conclusion, ContextImpl.this);
        }

        @Override
        public Boolean visit(Propagation subConclusion) {
            SubContext subContext = ContextImpl.this.getCreateSubContext(subConclusion.getSubDestination());
            if (subContext == null) {
                return false;
            }
            return subContext.removeSubConclusion(subConclusion);
        }

        @Override
        public Boolean visit(SubContextInitialization subConclusion) {
            SubContext subContext = ContextImpl.this.getCreateSubContext(subConclusion.getSubDestination());
            if (subContext == null) {
                return false;
            }
            return subContext.removeSubConclusion(subConclusion);
        }
    }

    private class ConclusionOccurrenceChecker
    implements ClassConclusion.Visitor<Boolean> {
        private ConclusionOccurrenceChecker() {
        }

        @Override
        public Boolean visit(BackwardLink subConclusion) {
            if (subConclusion.getTraceRoot() == ContextImpl.this.root_) {
                return ContextImpl.this.reflexiveBackwardLinks_ != null && ContextImpl.this.reflexiveBackwardLinks_.contains(subConclusion.getRelation());
            }
            SubContext subContext = ContextImpl.this.getCreateSubContext(subConclusion.getRelation());
            return subContext != null && subContext.containsSubConclusion(subConclusion);
        }

        @Override
        public Boolean visit(SubClassInclusionComposed conclusion) {
            return ContextImpl.this.composedSubsumers_.contains(conclusion.getSubsumer());
        }

        @Override
        public Boolean visit(SubClassInclusionDecomposed conclusion) {
            return ContextImpl.this.decomposedSubsumers_.contains(conclusion.getSubsumer());
        }

        @Override
        public Boolean visit(ContextInitialization conclusion) {
            return ContextImpl.this.isInitialized_;
        }

        @Override
        public Boolean visit(ClassInconsistency conclusion) {
            return ContextImpl.this.isInconsistent_;
        }

        @Override
        public Boolean visit(DisjointSubsumer conclusion) {
            if (ContextImpl.this.disjointnessAxioms_ == null) {
                return false;
            }
            IndexedClassExpressionList disjoint = conclusion.getDisjointExpressions();
            int position = conclusion.getPosition();
            Set positions = (Set)ContextImpl.this.disjointnessAxioms_.get(disjoint);
            if (positions == null) {
                return false;
            }
            return positions.contains(position);
        }

        @Override
        public Boolean visit(ForwardLink conclusion) {
            return BackwardLinkChainFromBackwardLinkRule.containsRuleFor(conclusion, ContextImpl.this);
        }

        @Override
        public Boolean visit(Propagation subConclusion) {
            SubContext subContext = ContextImpl.this.getCreateSubContext(subConclusion.getSubDestination());
            if (subContext == null) {
                return false;
            }
            return subContext.containsSubConclusion(subConclusion);
        }

        @Override
        public Boolean visit(SubContextInitialization subConclusion) {
            SubContext subContext = ContextImpl.this.getCreateSubContext(subConclusion.getSubDestination());
            if (subContext == null) {
                return false;
            }
            return subContext.containsSubConclusion(subConclusion);
        }
    }
}

