/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.Arrays;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.ClassConclusionCounter;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.ClassConclusionStatistics;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.ComposedClassConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.CountingClassConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.TimedClassConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassConclusion;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.context.ContextStatistics;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInference;
import org.semanticweb.elk.reasoner.saturation.inferences.ComposedClassInferenceVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.BasicRuleVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleStatistics;
import org.semanticweb.elk.reasoner.saturation.rules.RuleVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleVisitors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaturationUtils {
    protected static final Logger LOGGER_ = LoggerFactory.getLogger(SaturationUtils.class);
    public static final boolean COLLECT_CONCLUSION_COUNTS = LOGGER_.isDebugEnabled();
    public static final boolean COLLECT_CONCLUSION_TIMES = LOGGER_.isDebugEnabled();
    public static final boolean COLLECT_RULE_COUNTS = LOGGER_.isDebugEnabled();
    public static final boolean COLLECT_RULE_TIMES = LOGGER_.isDebugEnabled();
    public static final boolean COLLECT_PROCESSING_TIMES = LOGGER_.isDebugEnabled();

    public static RuleVisitor<?> getStatsAwareRuleVisitor(RuleStatistics localStatistics) {
        RuleVisitor<Void> ruleAppVisitor = new BasicRuleVisitor();
        if (COLLECT_RULE_COUNTS) {
            ruleAppVisitor = RuleVisitors.getCountingVisitor(ruleAppVisitor, localStatistics.ruleCounter);
        }
        if (COLLECT_RULE_TIMES) {
            localStatistics.startMeasurements();
            ruleAppVisitor = RuleVisitors.getTimedVisitor(ruleAppVisitor, localStatistics.ruleTimer);
        }
        return ruleAppVisitor;
    }

    public static ClassConclusion.Visitor<Boolean> compose(ClassConclusion.Visitor<Boolean> ... visitors) {
        return new ComposedClassConclusionVisitor(SaturationUtils.removeNulls(visitors));
    }

    public static ClassInference.Visitor<Boolean> compose(ClassInference.Visitor<Boolean> ... visitors) {
        return new ComposedClassInferenceVisitor(SaturationUtils.removeNulls(visitors));
    }

    private static <T> T[] removeNulls(T[] input) {
        int pos = 0;
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            if (i > pos) {
                input[pos] = input[i];
            }
            ++pos;
        }
        return Arrays.copyOf(input, pos);
    }

    public static ClassConclusion.Visitor<Boolean> getCountingConclusionVisitor(ClassConclusionCounter counter) {
        if (!COLLECT_CONCLUSION_COUNTS) {
            return null;
        }
        return new CountingClassConclusionVisitor(counter);
    }

    public static ClassConclusion.Visitor<Boolean> getClassInferenceCountingVisitor(SaturationStatistics statistics) {
        return SaturationUtils.getCountingConclusionVisitor(statistics.getConclusionStatistics().getInferenceCounts());
    }

    public static ClassConclusion.Visitor<Boolean> getClassConclusionCountingVisitor(SaturationStatistics statistics) {
        return SaturationUtils.getCountingConclusionVisitor(statistics.getConclusionStatistics().getConclusionCounts());
    }

    public static <O> ClassConclusion.Visitor<O> getTimedConclusionVisitor(ClassConclusion.Visitor<O> conclusionVisitor, SaturationStatistics localStatistics) {
        ClassConclusionStatistics stats = localStatistics.getConclusionStatistics();
        if (COLLECT_CONCLUSION_TIMES) {
            stats.startMeasurements();
            return new TimedClassConclusionVisitor<O>(stats.getConclusionTimers(), conclusionVisitor);
        }
        return conclusionVisitor;
    }

    public static ContextCreationListener addStatsToContextCreationListener(final ContextCreationListener listener, final ContextStatistics contextStats) {
        return new ContextCreationListener(){

            @Override
            public void notifyContextCreation(Context newContext) {
                ++contextStats.countCreatedContexts;
                listener.notifyContextCreation(newContext);
            }
        };
    }

    public static ContextModificationListener addStatsToContextModificationListener(final ContextModificationListener listener, final ContextStatistics contextStats) {
        return new ContextModificationListener(){

            @Override
            public void notifyContextModification(Context context) {
                ++contextStats.countModifiedContexts;
                listener.notifyContextModification(context);
            }
        };
    }
}

