/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.Collections;
import java.util.Set;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.Propagation;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubContextInitialization;
import org.semanticweb.elk.reasoner.saturation.context.SubContext;
import org.semanticweb.elk.util.collections.ArrayHashSet;

public class SubContextImpl
extends ArrayHashSet<IndexedContextRoot>
implements SubContext {
    Set<IndexedObjectSomeValuesFrom> propagatedSubsumers_;
    private boolean isInitialized_ = false;
    private int size_ = 0;

    public SubContextImpl() {
        super(3);
    }

    @Override
    public Set<IndexedContextRoot> getLinkedRoots() {
        return this;
    }

    @Override
    public Set<? extends IndexedObjectSomeValuesFrom> getPropagatedSubsumers() {
        if (this.propagatedSubsumers_ == null) {
            return Collections.emptySet();
        }
        return this.propagatedSubsumers_;
    }

    @Override
    public boolean addSubConclusion(SubClassConclusion conclusion) {
        boolean success = conclusion.accept(new SubConclusionInserter());
        if (success) {
            ++this.size_;
        }
        return success;
    }

    @Override
    public boolean removeSubConclusion(SubClassConclusion conclusion) {
        boolean success = conclusion.accept(new SubConclusionDeletor());
        if (success) {
            --this.size_;
        }
        return success;
    }

    @Override
    public boolean containsSubConclusion(SubClassConclusion conclusion) {
        return conclusion.accept(new SubConclusionOccurrenceChecker());
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized_;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    public class SubConclusionInserter
    implements SubClassConclusion.Visitor<Boolean> {
        @Override
        public Boolean visit(BackwardLink subConclusion) {
            return SubContextImpl.this.add(subConclusion.getTraceRoot());
        }

        @Override
        public Boolean visit(Propagation subConclusion) {
            if (SubContextImpl.this.propagatedSubsumers_ == null) {
                SubContextImpl.this.propagatedSubsumers_ = new ArrayHashSet(3);
            }
            return SubContextImpl.this.propagatedSubsumers_.add(subConclusion.getCarry());
        }

        @Override
        public Boolean visit(SubContextInitialization subConclusion) {
            if (SubContextImpl.this.isInitialized_) {
                return false;
            }
            SubContextImpl.this.isInitialized_ = true;
            return true;
        }
    }

    public class SubConclusionDeletor
    implements SubClassConclusion.Visitor<Boolean> {
        @Override
        public Boolean visit(BackwardLink subConclusion) {
            return SubContextImpl.this.remove(subConclusion.getTraceRoot());
        }

        @Override
        public Boolean visit(Propagation subConclusion) {
            if (SubContextImpl.this.propagatedSubsumers_ == null) {
                return false;
            }
            return SubContextImpl.this.propagatedSubsumers_.remove(subConclusion.getCarry());
        }

        @Override
        public Boolean visit(SubContextInitialization subConclusion) {
            if (!SubContextImpl.this.isInitialized_) {
                return false;
            }
            SubContextImpl.this.isInitialized_ = false;
            return true;
        }
    }

    public class SubConclusionOccurrenceChecker
    implements SubClassConclusion.Visitor<Boolean> {
        @Override
        public Boolean visit(BackwardLink subConclusion) {
            return SubContextImpl.this.contains(subConclusion.getTraceRoot());
        }

        @Override
        public Boolean visit(Propagation subConclusion) {
            if (SubContextImpl.this.propagatedSubsumers_ == null) {
                return false;
            }
            return SubContextImpl.this.propagatedSubsumers_.contains(subConclusion.getCarry());
        }

        @Override
        public Boolean visit(SubContextInitialization subConclusion) {
            return SubContextImpl.this.isInitialized_;
        }
    }
}

