/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions.classes;

import org.semanticweb.elk.Reference;
import org.semanticweb.elk.reasoner.saturation.SaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.DummyClassConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ContextInitialization;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassConclusionInsertionVisitor
extends DummyClassConclusionVisitor<Boolean>
implements Reference<Context> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ClassConclusionInsertionVisitor.class);
    private final Reference<Context> contextRef_;
    private final SaturationStateWriter<?> writer_;

    public ClassConclusionInsertionVisitor(Reference<Context> contextRef, SaturationStateWriter<?> writer) {
        this.contextRef_ = contextRef;
        this.writer_ = writer;
    }

    public Context get() {
        return (Context)this.contextRef_.get();
    }

    @Override
    protected Boolean defaultVisit(ClassConclusion conclusion) {
        Context context = this.get();
        boolean result = context.addConclusion(conclusion);
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace("{}: inserting {}: {}", new Object[]{context, conclusion, result ? "success" : "failure"});
        }
        return result;
    }

    @Override
    public Boolean visit(ContextInitialization conclusion) {
        Context context = this.get();
        if (context.containsConclusion(conclusion)) {
            return false;
        }
        this.writer_.markAsNotSaturated(context.getRoot());
        return this.defaultVisit(conclusion);
    }
}

