/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions.classes;

import org.semanticweb.elk.reasoner.saturation.conclusions.classes.ClassConclusionCounter;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.ClassConclusionTimer;
import org.semanticweb.elk.util.logging.statistics.AbstractStatistics;
import org.semanticweb.elk.util.logging.statistics.StatisticsPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassConclusionStatistics
extends AbstractStatistics {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ClassConclusionStatistics.class);
    private final ClassConclusionCounter inferenceCounts_;
    private final ClassConclusionCounter conclusionCounts_;
    private final ClassConclusionTimer conclusionProcessingTimer_;

    public ClassConclusionStatistics(ClassConclusionCounter inferenceCounts, ClassConclusionCounter conclusionCounts, ClassConclusionTimer conclusionTimers) {
        this.inferenceCounts_ = inferenceCounts;
        this.conclusionCounts_ = conclusionCounts;
        this.conclusionProcessingTimer_ = conclusionTimers;
    }

    public ClassConclusionStatistics() {
        this(new ClassConclusionCounter(), new ClassConclusionCounter(), new ClassConclusionTimer());
    }

    public ClassConclusionCounter getInferenceCounts() {
        return this.inferenceCounts_;
    }

    public ClassConclusionCounter getConclusionCounts() {
        return this.conclusionCounts_;
    }

    public ClassConclusionTimer getConclusionTimers() {
        return this.conclusionProcessingTimer_;
    }

    public void reset() {
        super.reset();
        this.inferenceCounts_.reset();
        this.conclusionCounts_.reset();
        this.conclusionProcessingTimer_.reset();
    }

    public synchronized void add(ClassConclusionStatistics stats) {
        super.add((AbstractStatistics)stats);
        this.inferenceCounts_.add(stats.inferenceCounts_);
        this.conclusionCounts_.add(stats.conclusionCounts_);
        this.conclusionProcessingTimer_.add(stats.conclusionProcessingTimer_);
    }

    public void check(Logger logger) {
    }

    void print(StatisticsPrinter printer, String name, long inferenceCount, long conclusionCount, long time) {
        if (inferenceCount == 0L) {
            return;
        }
        if (conclusionCount > inferenceCount) {
            LOGGER_.error("{}: conclusions: {} more than inferences: {}!", new Object[]{name, conclusionCount, inferenceCount});
        }
        printer.print(new Object[]{name, inferenceCount, conclusionCount, time / (long)this.getNumberOfMeasurements()});
    }

    public void print(Logger logger) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (!this.measurementsTaken()) {
            return;
        }
        if (this.conclusionCounts_.getTotalCount() == 0L) {
            return;
        }
        StatisticsPrinter printer = new StatisticsPrinter(logger, "%{CONCLUSIONS:}s %,{processed}d | %,{unique}d [%,{time}d ms]", new Object[]{"TOTAL CONCLUSIONS", this.conclusionCounts_.getTotalCount(), this.inferenceCounts_.getTotalCount(), this.conclusionProcessingTimer_.getTotalTime()});
        printer.printHeader();
        this.print(printer, "Backward Link", this.inferenceCounts_.countBackwardLink, this.conclusionCounts_.countBackwardLink, this.conclusionProcessingTimer_.timeBackwardLinks);
        this.print(printer, "Context Initialization", this.inferenceCounts_.countContextInitialization, this.conclusionCounts_.countContextInitialization, this.conclusionProcessingTimer_.timeContextInitializations);
        this.print(printer, "Contradiction", this.inferenceCounts_.countContradiction, this.conclusionCounts_.countContradiction, this.conclusionProcessingTimer_.timeContradictions);
        this.print(printer, "Disjoint Subsumer", this.inferenceCounts_.countDisjointSubsumer, this.conclusionCounts_.countDisjointSubsumer, this.conclusionProcessingTimer_.timeDisjointSubsumers);
        this.print(printer, "Forward Link", this.inferenceCounts_.countForwardLink, this.conclusionCounts_.countForwardLink, this.conclusionProcessingTimer_.timeForwardLinks);
        this.print(printer, "Decomposed Subsumer", this.inferenceCounts_.countSubClassInclusionDecomposed, this.conclusionCounts_.countSubClassInclusionDecomposed, this.conclusionProcessingTimer_.timeDecomposedSubsumers);
        this.print(printer, "Composed Subsumer", this.inferenceCounts_.countSubClassInclusionComposed, this.conclusionCounts_.countSubClassInclusionComposed, this.conclusionProcessingTimer_.timeComposedSubsumers);
        this.print(printer, "Propagation", this.inferenceCounts_.countPropagation, this.conclusionCounts_.countPropagation, this.conclusionProcessingTimer_.timePropagations);
        this.print(printer, "Sub-Context Initialization", this.inferenceCounts_.countSubContextInitialization, this.conclusionCounts_.countSubContextInitialization, this.conclusionProcessingTimer_.timeSubContextInitializations);
        printer.printSeparator();
        this.print(printer, "TOTAL CONCLUSIONS:", this.inferenceCounts_.getTotalCount(), this.conclusionCounts_.getTotalCount(), this.conclusionProcessingTimer_.getTotalTime());
        printer.printSeparator();
    }
}

