/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions.classes;

import org.semanticweb.elk.Reference;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.DummyClassConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassConclusion;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassConclusionTracingContextNotSaturatedCheckingVisitor
extends DummyClassConclusionVisitor<Boolean>
implements Reference<Context> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ClassConclusionTracingContextNotSaturatedCheckingVisitor.class);
    private final Reference<Context> contextRef_;
    private final SaturationState<?> state_;

    public ClassConclusionTracingContextNotSaturatedCheckingVisitor(Reference<Context> context, SaturationState<?> state) {
        this.contextRef_ = context;
        this.state_ = state;
    }

    public Context get() {
        return (Context)this.contextRef_.get();
    }

    @Override
    protected Boolean defaultVisit(SubClassConclusion subConclusion) {
        return true;
    }

    @Override
    protected Boolean defaultVisit(ClassConclusion conclusion) {
        Object originContext = this.state_.getContext(conclusion.getTraceRoot());
        if (originContext.isInitialized() && originContext.isSaturated()) {
            LOGGER_.error("{}: adding conclusion {} to saturated context {}", new Object[]{this.contextRef_, conclusion, this.get().containsConclusion(conclusion) ? "(it is already there)" : ""});
        }
        return true;
    }
}

