/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.inferences;

import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedSubObjectPropertyOfAxiom;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubPropertyChain;
import org.semanticweb.elk.reasoner.saturation.inferences.AbstractBackwardLinkInference;
import org.semanticweb.elk.reasoner.saturation.inferences.BackwardLinkInference;
import org.semanticweb.elk.reasoner.saturation.inferences.LinkComposition;
import org.semanticweb.elk.reasoner.tracing.Conclusion;

public class BackwardLinkComposition
extends AbstractBackwardLinkInference
implements LinkComposition {
    private final IndexedContextRoot inferenceRoot_;
    private final IndexedObjectProperty backwardRelation_;
    private final IndexedPropertyChain forwardChain_;
    private final IndexedComplexPropertyChain composition_;
    private final ElkAxiom reason_;

    public BackwardLinkComposition(IndexedContextRoot originRoot, IndexedObjectProperty backwardRelation, IndexedContextRoot inferenceRoot, IndexedPropertyChain forwardChain, IndexedContextRoot targetRoot, IndexedComplexPropertyChain composition, IndexedObjectProperty compositionSuperProperty, ElkAxiom reason) {
        super(targetRoot, compositionSuperProperty, originRoot);
        this.backwardRelation_ = backwardRelation;
        this.forwardChain_ = forwardChain;
        this.inferenceRoot_ = inferenceRoot;
        this.composition_ = composition;
        this.reason_ = reason;
    }

    @Override
    public IndexedContextRoot getOrigin() {
        return this.inferenceRoot_;
    }

    @Override
    public IndexedContextRoot getPremiseSource() {
        return this.getConclusionSource();
    }

    @Override
    public IndexedObjectProperty getPremiseBackwardRelation() {
        return this.backwardRelation_;
    }

    @Override
    public IndexedPropertyChain getPremiseForwardChain() {
        return this.forwardChain_;
    }

    @Override
    public IndexedContextRoot getPremiseTarget() {
        return this.getDestination();
    }

    @Override
    public IndexedComplexPropertyChain getComposition() {
        return this.composition_;
    }

    public ElkAxiom getReason() {
        return this.reason_;
    }

    @Override
    public BackwardLink getFirstPremise(BackwardLink.Factory factory) {
        return factory.getBackwardLink(this.getOrigin(), this.backwardRelation_, this.getTraceRoot());
    }

    @Override
    public SubPropertyChain getSecondPremise(SubPropertyChain.Factory factory) {
        return factory.getSubPropertyChain(this.backwardRelation_, this.composition_.getFirstProperty());
    }

    @Override
    public ForwardLink getThirdPremise(ForwardLink.Factory factory) {
        return factory.getForwardLink(this.getOrigin(), this.forwardChain_, this.getDestination());
    }

    @Override
    public SubPropertyChain getFourthPremise(SubPropertyChain.Factory factory) {
        return factory.getSubPropertyChain(this.forwardChain_, this.composition_.getSuffixChain());
    }

    public IndexedSubObjectPropertyOfAxiom getFifthPremise(IndexedSubObjectPropertyOfAxiom.Factory factory) {
        return factory.getIndexedSubObjectPropertyOfAxiom(this.reason_, this.composition_, this.getConclusionRelation());
    }

    @Override
    public int getPremiseCount() {
        return 5;
    }

    @Override
    public Conclusion getPremise(int index, Conclusion.Factory factory) {
        switch (index) {
            case 0: {
                return this.getFirstPremise(factory);
            }
            case 1: {
                return this.getSecondPremise(factory);
            }
            case 2: {
                return this.getThirdPremise(factory);
            }
            case 3: {
                return this.getFourthPremise(factory);
            }
            case 4: {
                return this.getFifthPremise(factory);
            }
        }
        return (Conclusion)BackwardLinkComposition.failGetPremise(index);
    }

    @Override
    public final <O> O accept(BackwardLinkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public final <O> O accept(LinkComposition.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    public static interface Visitor<O> {
        public O visit(BackwardLinkComposition var1);
    }
}

