/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.inferences;

import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubPropertyChain;
import org.semanticweb.elk.reasoner.saturation.inferences.AbstractForwardLinkInference;
import org.semanticweb.elk.reasoner.saturation.inferences.ForwardLinkInference;
import org.semanticweb.elk.reasoner.saturation.inferences.LinkComposition;
import org.semanticweb.elk.reasoner.tracing.Conclusion;

public class ForwardLinkComposition
extends AbstractForwardLinkInference<IndexedComplexPropertyChain>
implements LinkComposition {
    private final IndexedObjectProperty backwardRelation_;
    private final IndexedContextRoot inferenceRoot_;
    private final IndexedPropertyChain forwardChain_;

    public ForwardLinkComposition(IndexedContextRoot originRoot, IndexedObjectProperty backwardRelation, IndexedContextRoot inferenceRoot, IndexedPropertyChain forwardChain, IndexedContextRoot targetRoot, IndexedComplexPropertyChain composition) {
        super(originRoot, composition, targetRoot);
        this.backwardRelation_ = backwardRelation;
        this.inferenceRoot_ = inferenceRoot;
        this.forwardChain_ = forwardChain;
    }

    @Override
    public IndexedContextRoot getPremiseSource() {
        return this.getDestination();
    }

    @Override
    public IndexedObjectProperty getPremiseBackwardRelation() {
        return this.backwardRelation_;
    }

    @Override
    public IndexedPropertyChain getPremiseForwardChain() {
        return this.forwardChain_;
    }

    @Override
    public IndexedContextRoot getPremiseTarget() {
        return this.getTarget();
    }

    @Override
    public IndexedComplexPropertyChain getComposition() {
        return (IndexedComplexPropertyChain)this.getChain();
    }

    @Override
    public IndexedContextRoot getOrigin() {
        return this.inferenceRoot_;
    }

    @Override
    public BackwardLink getFirstPremise(BackwardLink.Factory factory) {
        return factory.getBackwardLink(this.getOrigin(), this.backwardRelation_, this.getDestination());
    }

    @Override
    public SubPropertyChain getSecondPremise(SubPropertyChain.Factory factory) {
        return factory.getSubPropertyChain(this.backwardRelation_, this.getComposition().getFirstProperty());
    }

    @Override
    public ForwardLink getThirdPremise(ForwardLink.Factory factory) {
        return factory.getForwardLink(this.getOrigin(), this.forwardChain_, this.getTarget());
    }

    @Override
    public SubPropertyChain getFourthPremise(SubPropertyChain.Factory factory) {
        return factory.getSubPropertyChain(this.forwardChain_, this.getComposition().getSuffixChain());
    }

    @Override
    public int getPremiseCount() {
        return 4;
    }

    @Override
    public Conclusion getPremise(int index, Conclusion.Factory factory) {
        switch (index) {
            case 0: {
                return this.getFirstPremise(factory);
            }
            case 1: {
                return this.getSecondPremise(factory);
            }
            case 2: {
                return this.getThirdPremise(factory);
            }
            case 3: {
                return this.getFourthPremise(factory);
            }
        }
        return (Conclusion)ForwardLinkComposition.failGetPremise(index);
    }

    @Override
    public final <O> O accept(ForwardLinkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public final <O> O accept(LinkComposition.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    public static interface Visitor<O> {
        public O visit(ForwardLinkComposition var1);
    }
}

