/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.predefined.PredefinedElkObjectPropertyFactory;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.OntologyIndex;
import org.semanticweb.elk.reasoner.saturation.properties.TransitiveReductionOutputEquivalentDirect;
import org.semanticweb.elk.reasoner.saturation.properties.TransitiveReductionOutputExtreme;
import org.semanticweb.elk.reasoner.saturation.properties.TransitiveReductionOutputVisitor;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.DelegateInterruptMonitor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;

public class ObjectPropertyTaxonomyComputationFactory
extends DelegateInterruptMonitor
implements InputProcessorFactory<IndexedObjectProperty, Engine> {
    private final TransitiveReductionOutputVisitor<ElkObjectProperty> outputProcessor_;
    private final IndexedObjectProperty indexedTopProperty_;
    private final IndexedObjectProperty indexedBottomProperty_;
    private final Collection<? extends Collection<? extends ElkObjectProperty>> defaultDirectSubproperties_;

    public ObjectPropertyTaxonomyComputationFactory(InterruptMonitor interrupter, TransitiveReductionOutputVisitor<ElkObjectProperty> outputProcessor, OntologyIndex index, PredefinedElkObjectPropertyFactory predefinedFactory) {
        super(interrupter);
        this.outputProcessor_ = outputProcessor;
        this.indexedTopProperty_ = index.getOwlTopObjectProperty();
        this.indexedBottomProperty_ = index.getOwlBottomObjectProperty();
        this.defaultDirectSubproperties_ = Collections.singleton(Collections.singleton(predefinedFactory.getOwlBottomObjectProperty()));
    }

    public Engine getEngine() {
        return new Engine();
    }

    public void finish() {
    }

    private void instertIntoTaxonomy(IndexedObjectProperty property) {
        Map<IndexedObjectProperty, ElkObjectProperty> equivalent = this.collectEquivalent(property);
        if (equivalent == null) {
            return;
        }
        ArrayHashMap subEquivalent = new ArrayHashMap();
        ArrayHashSet indirect = new ArrayHashSet();
        for (IndexedObjectProperty subProperty : property.getSaturated().getSubProperties()) {
            if (equivalent.containsKey(subProperty)) continue;
            Map<IndexedObjectProperty, ElkObjectProperty> subEq = this.collectEquivalent(subProperty);
            subEquivalent.put(subProperty, subEq.values());
            for (IndexedObjectProperty subSubProperty : subProperty.getSaturated().getSubProperties()) {
                if (subEq.containsKey(subSubProperty)) continue;
                indirect.add(subSubProperty);
            }
        }
        if (subEquivalent.isEmpty() && (this.indexedBottomProperty_ == null || !equivalent.containsKey(this.indexedBottomProperty_))) {
            this.outputProcessor_.visit((TransitiveReductionOutputEquivalentDirect<ElkObjectProperty>)new TransitiveReductionOutputEquivalentDirectImpl<ElkObjectProperty>(equivalent.values(), this.defaultDirectSubproperties_));
            return;
        }
        Collection direct = Operations.map(subEquivalent.entrySet(), (Operations.Transformation)new Operations.Transformation<Map.Entry<IndexedObjectProperty, Collection<? extends ElkObjectProperty>>, Collection<? extends ElkObjectProperty>>((Set)indirect){
            final /* synthetic */ Set val$indirect;
            {
                this.val$indirect = set;
            }

            public Collection<? extends ElkObjectProperty> transform(Map.Entry<IndexedObjectProperty, Collection<? extends ElkObjectProperty>> element) {
                if (this.val$indirect.contains(element.getKey())) {
                    return null;
                }
                return element.getValue();
            }
        });
        this.outputProcessor_.visit((TransitiveReductionOutputEquivalentDirect<ElkObjectProperty>)new TransitiveReductionOutputEquivalentDirectImpl<ElkObjectProperty>(equivalent.values(), direct));
    }

    private Map<IndexedObjectProperty, ElkObjectProperty> collectEquivalent(IndexedObjectProperty property) {
        Set<IndexedObjectProperty> subProperties = property.getSaturated().getSubProperties();
        ArrayHashMap equivalent = new ArrayHashMap();
        for (IndexedObjectProperty subProperty : subProperties) {
            if (subProperty.equals(this.indexedTopProperty_)) {
                this.outputProcessor_.visit(new TransitiveReductionOutputExtremeImpl<ElkObjectProperty>(property.getElkEntity()));
                return null;
            }
            if (!subProperty.getSaturated().getSubProperties().contains(property) && !property.equals(this.indexedBottomProperty_)) continue;
            equivalent.put(subProperty, subProperty.getElkEntity());
        }
        if (this.indexedBottomProperty_.getSaturated().getSubProperties().contains(property)) {
            equivalent.put(this.indexedBottomProperty_, this.indexedBottomProperty_.getElkEntity());
        }
        return equivalent;
    }

    class Engine
    implements InputProcessor<IndexedObjectProperty> {
        Engine() {
        }

        public void submit(IndexedObjectProperty property) {
            ObjectPropertyTaxonomyComputationFactory.this.instertIntoTaxonomy(property);
        }

        public void process() throws InterruptedException {
        }

        public void finish() {
        }
    }

    private static class TransitiveReductionOutputEquivalentDirectImpl<E extends ElkEntity>
    implements TransitiveReductionOutputEquivalentDirect<E> {
        final Collection<? extends E> equivalent_;
        final Collection<? extends Collection<? extends E>> direct_;

        public TransitiveReductionOutputEquivalentDirectImpl(Collection<? extends E> equivalent, Collection<? extends Collection<? extends E>> direct) {
            this.equivalent_ = equivalent;
            this.direct_ = direct;
        }

        @Override
        public Collection<? extends E> getEquivalent() {
            return this.equivalent_;
        }

        @Override
        public Iterable<? extends Collection<? extends E>> getDirectlyRelated() {
            return Collections.unmodifiableCollection(this.direct_);
        }

        @Override
        public void accept(TransitiveReductionOutputVisitor<E> visitor) {
            visitor.visit(this);
        }
    }

    private static class TransitiveReductionOutputExtremeImpl<E extends ElkEntity>
    implements TransitiveReductionOutputExtreme<E> {
        final E extremeMember_;

        public TransitiveReductionOutputExtremeImpl(E extremeMember) {
            this.extremeMember_ = extremeMember;
        }

        @Override
        public E getExtremeMember() {
            return this.extremeMember_;
        }

        @Override
        public void accept(TransitiveReductionOutputVisitor<E> visitor) {
            visitor.visit(this);
        }
    }
}

