/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.liveontologies.puli.Producer;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.properties.inferences.PropertyRangeInference;
import org.semanticweb.elk.reasoner.saturation.properties.inferences.PropertyRangeInherited;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeExplorer {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(RangeExplorer.class);
    private final IndexedObjectProperty input_;
    private final Set<IndexedObjectProperty> superProperties_;
    private final Set<IndexedClassExpression> ranges_;
    private final Queue<IndexedObjectProperty> toDoSuperProperties_ = new LinkedList<IndexedObjectProperty>();
    private final Producer<? super PropertyRangeInference> inferenceProducer_;

    RangeExplorer(IndexedObjectProperty input, Set<IndexedObjectProperty> currentSuperProperties, Set<IndexedClassExpression> currentRanges, Producer<? super PropertyRangeInference> inferenceProducer) {
        this.input_ = input;
        this.superProperties_ = currentSuperProperties;
        this.ranges_ = currentRanges;
        this.inferenceProducer_ = inferenceProducer;
        this.toDo(input);
    }

    private void toDo(IndexedObjectProperty element) {
        if (this.superProperties_.add(element)) {
            this.toDoSuperProperties_.add(element);
        }
    }

    void process() {
        IndexedObjectProperty next;
        while ((next = this.toDoSuperProperties_.poll()) != null) {
            ArrayList<IndexedClassExpression> ranges = next.getToldRanges();
            ArrayList<ElkAxiom> reasons = next.getToldRangesReasons();
            for (int i = 0; i < ranges.size(); ++i) {
                IndexedClassExpression range = (IndexedClassExpression)ranges.get(i);
                ElkAxiom reason = (ElkAxiom)reasons.get(i);
                this.ranges_.add(range);
                this.inferenceProducer_.produce((Object)new PropertyRangeInherited(this.input_, next, range, reason));
            }
            this.ranges_.addAll(next.getToldRanges());
            for (IndexedObjectProperty superProperty : next.getToldSuperProperties()) {
                this.toDo(superProperty);
            }
        }
    }

    private static void expandUnderSuperProperties(IndexedObjectProperty property, Set<IndexedObjectProperty> currentSuperProperties, Set<IndexedClassExpression> currentRanges, Producer<? super PropertyRangeInference> inferenceProducer) {
        new RangeExplorer(property, currentSuperProperties, currentRanges, inferenceProducer).process();
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace("{} super-properties: {}, ranges: {}", new Object[]{property, currentSuperProperties, currentRanges});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SaturatedPropertyChain computeRanges(IndexedObjectProperty element, Producer<? super PropertyRangeInference> inferenceProducer) {
        SaturatedPropertyChain saturation = element.getSaturated();
        if (saturation.derivedRangesComputed) {
            return saturation;
        }
        Object object = saturation;
        synchronized (object) {
            if (saturation.derivedRanges == null) {
                saturation.derivedRanges = new ArrayHashSet(8);
            }
        }
        object = saturation.derivedRanges;
        synchronized (object) {
            if (saturation.derivedRangesComputed) {
                return saturation;
            }
            RangeExplorer.expandUnderSuperProperties(element, (Set<IndexedObjectProperty>)new ArrayHashSet(8), saturation.derivedRanges, inferenceProducer);
            saturation.derivedRangesComputed = true;
        }
        return saturation;
    }

    static Set<IndexedClassExpression> getRanges(IndexedObjectProperty element, Producer<? super PropertyRangeInference> inferenceProducer) {
        return RangeExplorer.computeRanges(element, inferenceProducer).getRanges();
    }
}

