/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.liveontologies.puli.Producer;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubPropertyChain;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.properties.inferences.SubPropertyChainExpandedSubObjectPropertyOf;
import org.semanticweb.elk.reasoner.saturation.properties.inferences.SubPropertyChainInference;
import org.semanticweb.elk.reasoner.saturation.properties.inferences.SubPropertyChainInferenceConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.properties.inferences.SubPropertyChainTautology;
import org.semanticweb.elk.reasoner.stages.PropertyHierarchyCompositionState;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.HashSetMultimap;
import org.semanticweb.elk.util.collections.LazySetIntersection;
import org.semanticweb.elk.util.collections.Multimap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubPropertyExplorer {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(SubPropertyExplorer.class);
    private final IndexedPropertyChain input_;
    private final Set<IndexedPropertyChain> subPropertyChains_;
    private final Set<IndexedObjectProperty> subProperties_;
    private final Queue<IndexedObjectProperty> toDoSubProperties_ = new LinkedList<IndexedObjectProperty>();
    private final Producer<? super SubPropertyChainInference> inferenceProducer_;
    private final SubPropertyChainInference.Visitor<Void> inferenceProcessor_ = new SubPropertyChainInferenceConclusionVisitor<Void>(new SubPropertyChain.Visitor<Void>(){

        @Override
        public Void visit(SubPropertyChain conclusion) {
            SubPropertyExplorer.this.toDoConclusion(conclusion);
            return null;
        }
    });

    SubPropertyExplorer(IndexedPropertyChain input, Set<IndexedPropertyChain> subPropertyChains, Set<IndexedObjectProperty> subProperties, Producer<? super SubPropertyChainInference> inferenceProducer) {
        this.input_ = input;
        this.subPropertyChains_ = subPropertyChains;
        this.subProperties_ = subProperties;
        this.inferenceProducer_ = inferenceProducer;
        this.toDoInference(new SubPropertyChainTautology(input));
    }

    private void toDoInference(SubPropertyChainInference inference) {
        LOGGER_.trace("{}: new inference", (Object)inference);
        this.inferenceProducer_.produce((Object)inference);
        inference.accept(this.inferenceProcessor_);
    }

    private void toDoConclusion(SubPropertyChain conclusion) {
        IndexedPropertyChain subChain = conclusion.getSubChain();
        if (this.subPropertyChains_.add(subChain) && subChain instanceof IndexedObjectProperty) {
            IndexedObjectProperty subProperty = (IndexedObjectProperty)subChain;
            this.subProperties_.add(subProperty);
            this.toDoSubProperties_.add(subProperty);
        }
    }

    private void process() {
        IndexedObjectProperty next;
        while ((next = this.toDoSubProperties_.poll()) != null) {
            ArrayList<IndexedPropertyChain> toldSubChains = next.getToldSubChains();
            ArrayList<ElkAxiom> reasons = next.getToldSubChainsReasons();
            for (int i = 0; i < toldSubChains.size(); ++i) {
                IndexedPropertyChain sub = (IndexedPropertyChain)toldSubChains.get(i);
                ElkAxiom reason = (ElkAxiom)reasons.get(i);
                this.toDoInference(new SubPropertyChainExpandedSubObjectPropertyOf(sub, next, (IndexedObjectProperty)this.input_, reason));
            }
        }
    }

    private static void expandUnderSubProperties(IndexedPropertyChain input, Set<IndexedPropertyChain> currentSubPropertyChains, Set<IndexedObjectProperty> currentSubProperties, Producer<? super SubPropertyChainInference> inferenceProducer) {
        new SubPropertyExplorer(input, currentSubPropertyChains, currentSubProperties, inferenceProducer).process();
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace("{} sub-property chains: {}, sub-properties: {}", new Object[]{input, currentSubPropertyChains, currentSubProperties});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SaturatedPropertyChain computeSubProperties(IndexedPropertyChain input, Producer<? super SubPropertyChainInference> inferenceProducer, PropertyHierarchyCompositionState.Dispatcher dispatcher) {
        SaturatedPropertyChain saturation = input.getSaturated();
        if (saturation.derivedSubPropertiesComputed) {
            return saturation;
        }
        Object object = saturation;
        synchronized (object) {
            if (saturation.derivedSubProperyChains == null) {
                saturation.derivedSubProperyChains = new ArrayHashSet(8);
            }
        }
        object = saturation.derivedSubProperyChains;
        synchronized (object) {
            if (saturation.derivedSubPropertiesComputed) {
                return saturation;
            }
            if (saturation.derivedSubProperties == null) {
                saturation.derivedSubProperties = new ArrayHashSet(8);
            }
            SubPropertyExplorer.expandUnderSubProperties(input, saturation.derivedSubProperyChains, saturation.derivedSubProperties, inferenceProducer);
            saturation.derivedSubPropertiesComputed = true;
            dispatcher.firePropertyBecameSaturated(input);
        }
        return saturation;
    }

    static Set<IndexedPropertyChain> getSubPropertyChains(IndexedPropertyChain input, Producer<? super SubPropertyChainInference> inferenceProducer, PropertyHierarchyCompositionState.Dispatcher dispatcher) {
        return SubPropertyExplorer.computeSubProperties(input, inferenceProducer, dispatcher).getSubPropertyChains();
    }

    static Set<IndexedObjectProperty> getSubProperties(IndexedPropertyChain input, Producer<? super SubPropertyChainInference> inferenceProducer, PropertyHierarchyCompositionState.Dispatcher dispatcher) {
        return SubPropertyExplorer.computeSubProperties(input, inferenceProducer, dispatcher).getSubProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Multimap<IndexedObjectProperty, IndexedObjectProperty> getLeftSubComposableSubPropertiesByRightProperties(IndexedObjectProperty input, Producer<? super SubPropertyChainInference> inferenceProducer, PropertyHierarchyCompositionState.Dispatcher dispatcher) {
        Multimap<IndexedObjectProperty, IndexedObjectProperty> saturation = input.getSaturated();
        if (saturation.leftSubComposableSubPropertiesByRightPropertiesComputed) {
            return saturation.leftSubComposableSubPropertiesByRightProperties;
        }
        Multimap<IndexedObjectProperty, IndexedObjectProperty> multimap = saturation;
        synchronized (multimap) {
            if (saturation.leftSubComposableSubPropertiesByRightProperties == null) {
                saturation.leftSubComposableSubPropertiesByRightProperties = new HashSetMultimap();
            }
        }
        multimap = saturation.leftSubComposableSubPropertiesByRightProperties;
        synchronized (multimap) {
            if (saturation.leftSubComposableSubPropertiesByRightPropertiesComputed) {
                return saturation.leftSubComposableSubPropertiesByRightProperties;
            }
            Set<IndexedObjectProperty> subProperties = SubPropertyExplorer.getSubProperties(input, inferenceProducer, dispatcher);
            for (IndexedPropertyChain subPropertyChain : SubPropertyExplorer.getSubPropertyChains(input, inferenceProducer, dispatcher)) {
                IndexedComplexPropertyChain composition;
                Set<IndexedObjectProperty> leftSubProperties;
                LazySetIntersection commonSubProperties;
                if (!(subPropertyChain instanceof IndexedComplexPropertyChain) || (commonSubProperties = new LazySetIntersection(subProperties, leftSubProperties = SubPropertyExplorer.getSubProperties((composition = (IndexedComplexPropertyChain)subPropertyChain).getFirstProperty(), inferenceProducer, dispatcher))).isEmpty()) continue;
                for (IndexedObjectProperty rightSubProperty : SubPropertyExplorer.getSubProperties(composition.getSuffixChain(), inferenceProducer, dispatcher)) {
                    for (IndexedObjectProperty commonLeft : commonSubProperties) {
                        saturation.leftSubComposableSubPropertiesByRightProperties.add((Object)rightSubProperty, (Object)commonLeft);
                    }
                }
            }
            saturation.leftSubComposableSubPropertiesByRightPropertiesComputed = true;
        }
        return saturation.leftSubComposableSubPropertiesByRightProperties;
    }
}

