/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties.inferences;

import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectPropertyRangeAxiom;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubPropertyChain;
import org.semanticweb.elk.reasoner.saturation.properties.inferences.AbstractPropertyRangeInference;
import org.semanticweb.elk.reasoner.saturation.properties.inferences.PropertyRangeInference;
import org.semanticweb.elk.reasoner.tracing.Conclusion;

public class PropertyRangeInherited
extends AbstractPropertyRangeInference {
    private final IndexedObjectProperty superProperty_;
    private final ElkAxiom reason_;

    public PropertyRangeInherited(IndexedObjectProperty subProperty, IndexedObjectProperty superProperty, IndexedClassExpression range, ElkAxiom reason) {
        super(subProperty, range);
        this.superProperty_ = superProperty;
        this.reason_ = reason;
    }

    public IndexedObjectProperty getSubProperty() {
        return this.getProperty();
    }

    public IndexedObjectProperty getSuperProperty() {
        return this.superProperty_;
    }

    public ElkAxiom getReason() {
        return this.reason_;
    }

    public SubPropertyChain getFirstPremise(SubPropertyChain.Factory factory) {
        return factory.getSubPropertyChain(this.getProperty(), this.getSuperProperty());
    }

    public IndexedObjectPropertyRangeAxiom getSecondPremise(IndexedObjectPropertyRangeAxiom.Factory factory) {
        return factory.getIndexedObjectPropertyRangeAxiom(this.reason_, this.getSuperProperty(), this.getRange());
    }

    @Override
    public int getPremiseCount() {
        return 2;
    }

    @Override
    public Conclusion getPremise(int index, Conclusion.Factory factory) {
        switch (index) {
            case 0: {
                return this.getFirstPremise(factory);
            }
            case 1: {
                return this.getSecondPremise(factory);
            }
        }
        return (Conclusion)PropertyRangeInherited.failGetPremise(index);
    }

    @Override
    public final <O> O accept(PropertyRangeInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    public static interface Visitor<O> {
        public O visit(PropertyRangeInherited var1);
    }
}

