/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules;

import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationTimer;
import org.semanticweb.elk.reasoner.saturation.rules.RuleCounter;
import org.semanticweb.elk.util.logging.statistics.AbstractStatistics;
import org.semanticweb.elk.util.logging.statistics.StatisticsPrinter;
import org.slf4j.Logger;

public class RuleStatistics
extends AbstractStatistics {
    public final RuleCounter ruleCounter = new RuleCounter();
    public final RuleApplicationTimer ruleTimer = new RuleApplicationTimer();

    public synchronized void add(RuleStatistics stats) {
        super.add((AbstractStatistics)stats);
        this.ruleCounter.add(stats.ruleCounter);
        this.ruleTimer.add(stats.ruleTimer);
    }

    public long getTotalRuleAppCount() {
        return this.ruleCounter.getTotalRuleAppCount();
    }

    public double getTotalRuleTime() {
        return this.getNumberOfMeasurements() == 0 ? 0.0 : 1.0 * (double)this.ruleTimer.getTotalRuleAppTime() / (double)this.getNumberOfMeasurements();
    }

    public void print(Logger logger) {
        if (!logger.isDebugEnabled() || !this.measurementsTaken()) {
            return;
        }
        if (this.ruleCounter.getTotalRuleAppCount() == 0L) {
            return;
        }
        StatisticsPrinter printer = new StatisticsPrinter(logger, "%{RULES:}s %,{count}d [%,{time}d ms]", new Object[]{"TOTAL RULES", this.ruleCounter.getTotalRuleAppCount(), this.ruleTimer.getTotalRuleAppTime()});
        printer.printHeader();
        this.print(printer, "BackwardLink ForwardLink Composition", this.ruleCounter.countBackwardLinkChainFromBackwardLinkRule, this.ruleTimer.timeBackwardLinkChainFromBackwardLinkRule);
        this.print(printer, "BackwardLink from ForwardLink", this.ruleCounter.countBackwardLinkFromForwardLinkRule, this.ruleTimer.timeBackwardLinkFromForwardLinkRule);
        this.print(printer, "ForwardLink Non-Reflexive BackwardLink Composition", this.ruleCounter.countNonReflexiveBackwardLinkCompositionRule, this.ruleTimer.timeNonReflexiveBackwardLinkCompositionRule);
        this.print(printer, "Composed from Decomposed Subsumer", this.ruleCounter.countComposedFromDecomposedSubsumerRule, this.ruleTimer.timeComposedFromDecomposedSubsumerRule);
        this.print(printer, "Contradiction by Disjointness Axiom", this.ruleCounter.countContradictionCompositionRule, this.ruleTimer.timeContradictionCompositionRule);
        this.print(printer, "ObjectComplementOf Clash", this.ruleCounter.countContradictionFromNegationRule, this.ruleTimer.timeContradictionFromNegationRule);
        this.print(printer, "Owl:Nothing Contradiction Introduction", this.ruleCounter.countContradictionFromOwlNothingRule, this.ruleTimer.timeContradictionFromOwlNothingRule);
        this.print(printer, "Backward Link Contradiction Propagation", this.ruleCounter.countContradictionOverBackwardLinkRule, this.ruleTimer.timeContradictionOverBackwardLinkRule);
        this.print(printer, "Contradiction Propagation over Backward Links", this.ruleCounter.countContradictionPropagationRule, this.ruleTimer.timeContradictionPropagationRule);
        this.print(printer, "DisjointClasses Introduction", this.ruleCounter.countDisjointSubsumerFromMemberRule, this.ruleTimer.timeDisjointSubsumerFromMemberRule);
        this.print(printer, "Definition Expansion", this.ruleCounter.countIndexedClassDecompositionRule, this.ruleTimer.timeIndexedClassDecompositionRule);
        this.print(printer, "IndexedObjectComplementOf Decomposition", this.ruleCounter.countIndexedObjectComplementOfDecomposition, this.ruleTimer.timeIndexedObjectComplementOfDecomposition);
        this.print(printer, "ObjectIntersectionOf Decomposition", this.ruleCounter.countIndexedObjectIntersectionOfDecomposition, this.ruleTimer.timeIndexedObjectIntersectionOfDecomposition);
        this.print(printer, "IndexedObjectSomeValuesFrom Decomposition", this.ruleCounter.countIndexedObjectSomeValuesFromDecomposition, this.ruleTimer.timeIndexedObjectSomeValuesFromDecomposition);
        this.print(printer, "IndexedObjectHasSelf Decomposition", this.ruleCounter.countIndexedObjectHasSelfDecomposition, this.ruleTimer.timeIndexedObjectHasSelfDecomposition);
        this.print(printer, "Propagation", this.ruleCounter.countSubsumerPropagationRule, this.ruleTimer.timeSubsumerPropagationRule);
        this.print(printer, "ObjectIntersectionOf From 1st Conjunct", this.ruleCounter.countObjectIntersectionFromFirstConjunctRule, this.ruleTimer.timeObjectIntersectionFromFirstConjunctRule);
        this.print(printer, "ObjectIntersectionOf From 2nd Conjunct", this.ruleCounter.countObjectIntersectionFromSecondConjunctRule, this.ruleTimer.timeObjectIntersectionFromSecondConjunctRule);
        this.print(printer, "ObjectUnionOf Introduction", this.ruleCounter.countObjectUnionFromDisjunctRule, this.ruleTimer.timeObjectUnionFromDisjunctRule);
        this.print(printer, "owl:Thing Introduction", this.ruleCounter.countOwlThingContextInitRule, this.ruleTimer.timeOwlThingContextInitRule);
        this.print(printer, "ObjectSomeValuesFrom Propagation Introduction", this.ruleCounter.countPropagationFromExistentialFillerRule, this.ruleTimer.timePropagationFromExistentialFillerRule);
        this.print(printer, "Root Introduction", this.ruleCounter.countRootContextInitializationRule, this.ruleTimer.timeRootContextInitializationRule);
        this.print(printer, "Propagation Over BackwardLink", this.ruleCounter.countSubsumerBackwardLinkRule, this.ruleTimer.timeSubsumerBackwardLinkRule);
        this.print(printer, "SubClassOf Expansion", this.ruleCounter.countSuperClassFromSubClassRule, this.ruleTimer.timeSuperClassFromSubClassRule);
        this.print(printer, "EquivalentClasses First from Second", this.ruleCounter.countEquivalentClassFirstFromSecondRule, this.ruleTimer.timeEquivalentClassFirstFromSecondRule);
        this.print(printer, "EquivalentClasses Second from First", this.ruleCounter.countEquivalentClassSecondFromFirstRule, this.ruleTimer.timeEquivalentClassSecondFromFirstRule);
        this.print(printer, "Defined Class Introduction", this.ruleCounter.countIndexedClassFromDefinitionRule, this.ruleTimer.timeIndexedClassFromDefinitionRule);
        this.print(printer, "ForwardLink Reflexive BackwardLink Composition", this.ruleCounter.countReflexiveBackwardLinkCompositionRule, this.ruleTimer.timeReflexiveBackwardLinkCompositionRule);
        this.print(printer, "Propagations For SubContext", this.ruleCounter.countPropagationInitializationRule, this.ruleTimer.timePropagationInitializationRule);
        printer.printSeparator();
        this.print(printer, "TOTAL RULES:", this.ruleCounter.getTotalRuleAppCount(), this.ruleTimer.getTotalRuleAppTime());
        printer.printSeparator();
    }

    void print(StatisticsPrinter printer, String name, long count, long time) {
        if (count == 0L) {
            return;
        }
        printer.print(new Object[]{name, count, time / (long)this.getNumberOfMeasurements()});
    }

    public void reset() {
        super.reset();
        this.ruleCounter.reset();
        this.ruleTimer.reset();
    }
}

