/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.contextinit;

import org.semanticweb.elk.reasoner.indexing.classes.DummyIndexedContextRootVisitor;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedRangeFiller;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ContextInitialization;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.SubClassInclusionRange;
import org.semanticweb.elk.reasoner.saturation.inferences.SubClassInclusionTautology;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.AbstractChainableContextInitRule;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.ChainableContextInitRule;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.LinkedContextInitRuleVisitor;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;

public class RootContextInitializationRule
extends AbstractChainableContextInitRule {
    public static final String NAME = "Root Introduction";
    private static final Matcher<ChainableContextInitRule, RootContextInitializationRule> MATCHER_ = new SimpleTypeBasedMatcher(RootContextInitializationRule.class);
    private static final ReferenceFactory<ChainableContextInitRule, RootContextInitializationRule> FACTORY_ = new ReferenceFactory<ChainableContextInitRule, RootContextInitializationRule>(){

        public RootContextInitializationRule create(ChainableContextInitRule tail) {
            return new RootContextInitializationRule(tail);
        }
    };

    private RootContextInitializationRule(ChainableContextInitRule tail) {
        super(tail);
    }

    private RootContextInitializationRule() {
        super(null);
    }

    public static boolean addRuleFor(ModifiableOntologyIndex index) {
        return index.addContextInitRule(new RootContextInitializationRule());
    }

    public static boolean removeRuleFor(ModifiableOntologyIndex index) {
        return index.removeContextInitRule(new RootContextInitializationRule());
    }

    public String toString() {
        return NAME;
    }

    @Override
    public void apply(ContextInitialization premise, ContextPremises premises, final ClassInferenceProducer producer) {
        IndexedContextRoot root = premises.getRoot();
        producer.produce(new SubClassInclusionTautology(premises.getRoot()));
        root.accept(new DummyIndexedContextRootVisitor<Void>(){

            @Override
            public Void visit(IndexedRangeFiller element) {
                for (IndexedClassExpression range : element.getProperty().getSaturated().getRanges()) {
                    producer.produce(new SubClassInclusionRange(element, range));
                }
                return null;
            }
        });
    }

    @Override
    public boolean isTracingRule() {
        return true;
    }

    public boolean addTo(Chain<ChainableContextInitRule> ruleChain) {
        RootContextInitializationRule rule = (RootContextInitializationRule)ruleChain.find(MATCHER_);
        if (rule == null) {
            ruleChain.getCreate(MATCHER_, FACTORY_);
        }
        return true;
    }

    public boolean removeFrom(Chain<ChainableContextInitRule> ruleChain) {
        return ruleChain.remove(MATCHER_) != null;
    }

    @Override
    public void accept(LinkedContextInitRuleVisitor<?> visitor, ContextInitialization premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }
}

