/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.factories;

import org.semanticweb.elk.ModifiableReference;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.context.ContextStatistics;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInference;
import org.semanticweb.elk.reasoner.saturation.rules.factories.AbstractRuleEngine;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationInput;
import org.semanticweb.elk.reasoner.saturation.rules.factories.WorkerLocalTodo;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.semanticweb.elk.util.logging.CachedTimeThread;

public abstract class AbstractRuleEngineWithStatistics<I extends RuleApplicationInput>
extends AbstractRuleEngine<I> {
    private final SaturationStatistics aggregatedStats_;
    final SaturationStatistics localStatistics;
    protected final ContextStatistics localContextStatistics;

    public AbstractRuleEngineWithStatistics(ModifiableReference<Context> activeContext, ClassInference.Visitor<?> inferenceProcessor, WorkerLocalTodo localTodo, InterruptMonitor interrupter, SaturationStatistics aggregatedStats, SaturationStatistics localStatistics) {
        super(activeContext, inferenceProcessor, localTodo, interrupter);
        this.aggregatedStats_ = aggregatedStats;
        this.localStatistics = localStatistics;
        this.localContextStatistics = localStatistics.getContextStatistics();
    }

    @Override
    public void process() throws InterruptedException {
        this.localContextStatistics.timeContextProcess -= CachedTimeThread.getCurrentTimeMillis();
        super.process();
        this.localContextStatistics.timeContextProcess += CachedTimeThread.getCurrentTimeMillis();
    }

    @Override
    protected void process(Context context) {
        ++this.localContextStatistics.countProcessedContexts;
        super.process(context);
    }

    public void finish() {
        this.aggregatedStats_.add(this.localStatistics);
        this.localStatistics.reset();
    }
}

