/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.factories;

import java.util.ArrayDeque;
import java.util.Deque;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInference;
import org.semanticweb.elk.reasoner.saturation.rules.factories.WorkerLocalTodo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerLocalTodoImpl
implements WorkerLocalTodo {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(WorkerLocalTodoImpl.class);
    private final Thread thisThread_ = Thread.currentThread();
    private final Deque<ClassInference> localInferences_ = new ArrayDeque<ClassInference>(1024);
    private boolean isActivated_ = false;
    private IndexedContextRoot activeRoot_ = null;

    @Override
    public ClassInference poll() {
        this.checkThread();
        return this.localInferences_.pollLast();
    }

    @Override
    public void add(ClassInference inference) {
        this.checkThread();
        LOGGER_.trace("{}: local inference", (Object)inference);
        this.localInferences_.add(inference);
    }

    @Override
    public boolean isActivated() {
        this.checkThread();
        return this.isActivated_;
    }

    @Override
    public IndexedContextRoot getActiveRoot() {
        this.checkThread();
        if (this.isActivated_) {
            return this.activeRoot_;
        }
        return null;
    }

    @Override
    public void setActiveRoot(IndexedContextRoot currentActiveRoot) {
        this.checkThread();
        LOGGER_.trace("{}: new active root", (Object)currentActiveRoot);
        this.activeRoot_ = currentActiveRoot;
    }

    @Override
    public boolean deactivate() {
        this.checkThread();
        if (!this.isActivated_) {
            return false;
        }
        LOGGER_.trace("local todo deactivated");
        return true;
    }

    void checkThread() {
        if (Thread.currentThread() != this.thisThread_) {
            LOGGER_.error("Worker Local Todo used from a different thread than created!");
        }
    }
}

