/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.subsumers;

import java.util.Map;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.SubClassInclusionComposedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.AbstractChainableSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ChainableSubsumerRule;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.LazySetIntersection;

public abstract class AbstractObjectIntersectionFromConjunctRule
extends AbstractChainableSubsumerRule {
    private final Map<IndexedClassExpression, IndexedObjectIntersectionOf> conjunctionsByConjunct_ = new ArrayHashMap(4);

    AbstractObjectIntersectionFromConjunctRule(ChainableSubsumerRule tail) {
        super(tail);
    }

    AbstractObjectIntersectionFromConjunctRule(IndexedClassExpression conjunct, IndexedObjectIntersectionOf conjunction) {
        this(null);
        this.conjunctionsByConjunct_.put(conjunct, conjunction);
    }

    @Deprecated
    public Map<IndexedClassExpression, IndexedObjectIntersectionOf> getConjunctionsByConjunct() {
        return this.conjunctionsByConjunct_;
    }

    @Override
    public void apply(IndexedClassExpression premise, ContextPremises premises, ClassInferenceProducer producer) {
        for (IndexedClassExpression common : new LazySetIntersection(this.conjunctionsByConjunct_.keySet(), premises.getComposedSubsumers())) {
            producer.produce(new SubClassInclusionComposedObjectIntersectionOf(premises.getRoot(), this.conjunctionsByConjunct_.get(common)));
        }
    }

    @Override
    public boolean isTracingRule() {
        return true;
    }

    public boolean addTo(AbstractObjectIntersectionFromConjunctRule rule) {
        boolean success = true;
        int added = 0;
        for (Map.Entry<IndexedClassExpression, IndexedObjectIntersectionOf> entry : this.conjunctionsByConjunct_.entrySet()) {
            if (rule.addConjunctionByConjunct(entry.getValue(), entry.getKey())) {
                ++added;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            return true;
        }
        for (Map.Entry<IndexedClassExpression, IndexedObjectIntersectionOf> entry : this.conjunctionsByConjunct_.entrySet()) {
            if (added == 0) break;
            --added;
            rule.removeConjunctionByConjunct(entry.getValue(), entry.getKey());
        }
        return false;
    }

    public boolean removeFrom(AbstractObjectIntersectionFromConjunctRule rule) {
        boolean success = true;
        int removed = 0;
        for (Map.Entry<IndexedClassExpression, IndexedObjectIntersectionOf> entry : this.conjunctionsByConjunct_.entrySet()) {
            if (rule.removeConjunctionByConjunct(entry.getValue(), entry.getKey())) {
                ++removed;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            return true;
        }
        for (Map.Entry<IndexedClassExpression, IndexedObjectIntersectionOf> entry : this.conjunctionsByConjunct_.entrySet()) {
            if (removed == 0) break;
            --removed;
            rule.addConjunctionByConjunct(entry.getValue(), entry.getKey());
        }
        return false;
    }

    private boolean addConjunctionByConjunct(IndexedObjectIntersectionOf conjunction, IndexedClassExpression conjunct) {
        IndexedObjectIntersectionOf previous = this.conjunctionsByConjunct_.put(conjunct, conjunction);
        if (previous == null) {
            return true;
        }
        this.conjunctionsByConjunct_.put(conjunct, previous);
        return false;
    }

    private boolean removeConjunctionByConjunct(IndexedObjectIntersectionOf conjunction, IndexedClassExpression conjunct) {
        IndexedObjectIntersectionOf previous = this.conjunctionsByConjunct_.remove(conjunct);
        if (previous == conjunction) {
            return true;
        }
        if (previous != null) {
            this.conjunctionsByConjunct_.put(conjunct, previous);
        }
        return false;
    }

    boolean isEmpty() {
        return this.conjunctionsByConjunct_.isEmpty();
    }
}

