/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.subsumers;

import org.semanticweb.elk.owl.predefined.PredefinedElkIris;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInconsistencyOfOwlNothing;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.AbstractChainableSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ChainableSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.LinkedSubsumerRuleVisitor;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;

public class ContradictionFromOwlNothingRule
extends AbstractChainableSubsumerRule {
    public static final String NAME = "Owl:Nothing Contradiction Introduction";
    private static Matcher<ChainableSubsumerRule, ContradictionFromOwlNothingRule> MATCHER_ = new SimpleTypeBasedMatcher(ContradictionFromOwlNothingRule.class);
    private static ReferenceFactory<ChainableSubsumerRule, ContradictionFromOwlNothingRule> FACTORY_ = new ReferenceFactory<ChainableSubsumerRule, ContradictionFromOwlNothingRule>(){

        public ContradictionFromOwlNothingRule create(ChainableSubsumerRule tail) {
            return new ContradictionFromOwlNothingRule(tail);
        }
    };

    private ContradictionFromOwlNothingRule(ChainableSubsumerRule tail) {
        super(tail);
    }

    private ContradictionFromOwlNothingRule() {
        this(null);
    }

    private static void checkOwlNothing(IndexedClass candidate) {
        if (!candidate.getElkEntity().getIri().equals((Object)PredefinedElkIris.OWL_NOTHING)) {
            throw new IllegalArgumentException("The rule can be registered only for owl:Nothing and not for " + candidate);
        }
    }

    public static boolean addRuleFor(ModifiableIndexedClass owlNothing, ModifiableOntologyIndex index) {
        ContradictionFromOwlNothingRule.checkOwlNothing(owlNothing);
        return index.add(owlNothing, new ContradictionFromOwlNothingRule());
    }

    public static boolean removeRuleFor(ModifiableIndexedClass owlNothing, ModifiableOntologyIndex index) {
        ContradictionFromOwlNothingRule.checkOwlNothing(owlNothing);
        return index.remove(owlNothing, new ContradictionFromOwlNothingRule());
    }

    public String toString() {
        return NAME;
    }

    @Override
    public void apply(IndexedClassExpression premise, ContextPremises premises, ClassInferenceProducer producer) {
        producer.produce(new ClassInconsistencyOfOwlNothing(premises.getRoot(), (IndexedClass)premise));
    }

    @Override
    public boolean isTracingRule() {
        return true;
    }

    public boolean addTo(Chain<ChainableSubsumerRule> ruleChain) {
        ContradictionFromOwlNothingRule rule = (ContradictionFromOwlNothingRule)ruleChain.find(MATCHER_);
        if (rule != null) {
            return false;
        }
        ruleChain.getCreate(MATCHER_, FACTORY_);
        return true;
    }

    public boolean removeFrom(Chain<ChainableSubsumerRule> ruleChain) {
        ContradictionFromOwlNothingRule previous = (ContradictionFromOwlNothingRule)ruleChain.remove(MATCHER_);
        return previous != null;
    }

    @Override
    public void accept(LinkedSubsumerRuleVisitor<?> visitor, IndexedClassExpression premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }
}

