/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.subsumers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedEquivalentClassesAxiom;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.SubClassInclusionComposedDefinedClass;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.AbstractChainableSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ChainableSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.IndexedClassDecompositionRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.LinkedSubsumerRuleVisitor;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexedClassFromDefinitionRule
extends AbstractChainableSubsumerRule {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(IndexedClassFromDefinitionRule.class);
    public static final String NAME = "Defined Class Introduction";
    private final List<IndexedClass> definedClasses_ = new ArrayList<IndexedClass>(1);
    private final List<ElkAxiom> reasons_ = new ArrayList<ElkAxiom>(1);
    private static final Matcher<ChainableSubsumerRule, IndexedClassFromDefinitionRule> MATCHER_ = new SimpleTypeBasedMatcher(IndexedClassFromDefinitionRule.class);
    private static final ReferenceFactory<ChainableSubsumerRule, IndexedClassFromDefinitionRule> FACTORY_ = new ReferenceFactory<ChainableSubsumerRule, IndexedClassFromDefinitionRule>(){

        public IndexedClassFromDefinitionRule create(ChainableSubsumerRule tail) {
            return new IndexedClassFromDefinitionRule(tail);
        }
    };

    private IndexedClassFromDefinitionRule(ChainableSubsumerRule tail) {
        super(tail);
    }

    private IndexedClassFromDefinitionRule(IndexedClass defined, ElkAxiom reason) {
        this(null);
        this.definedClasses_.add(defined);
        this.reasons_.add(reason);
    }

    public static boolean addRuleFor(ModifiableIndexedEquivalentClassesAxiom axiom, ModifiableOntologyIndex index, ElkAxiom reason) {
        ModifiableIndexedClass definedClass = IndexedClassDecompositionRule.getDefinedClass(axiom);
        if (definedClass == null) {
            return false;
        }
        return index.add(axiom.getSecondMember(), new IndexedClassFromDefinitionRule(definedClass, reason));
    }

    public static boolean removeRuleFor(ModifiableIndexedEquivalentClassesAxiom axiom, ModifiableOntologyIndex index, ElkAxiom reason) {
        ModifiableIndexedClass definedClass = IndexedClassDecompositionRule.getDefinedClass(axiom);
        if (definedClass == null) {
            return false;
        }
        return index.remove(axiom.getSecondMember(), new IndexedClassFromDefinitionRule(definedClass, reason));
    }

    public String toString() {
        return NAME;
    }

    @Deprecated
    public Collection<IndexedClass> getDefinedClasses() {
        return this.definedClasses_;
    }

    @Override
    public void apply(IndexedClassExpression premise, ContextPremises premises, ClassInferenceProducer producer) {
        for (int i = 0; i < this.definedClasses_.size(); ++i) {
            producer.produce(new SubClassInclusionComposedDefinedClass(premises.getRoot(), this.definedClasses_.get(i), premise, this.reasons_.get(i)));
        }
    }

    @Override
    public boolean isTracingRule() {
        return true;
    }

    public boolean addTo(Chain<ChainableSubsumerRule> ruleChain) {
        ElkAxiom reason;
        IndexedClass defined;
        int i;
        if (this.isEmpty()) {
            return true;
        }
        IndexedClassFromDefinitionRule rule = (IndexedClassFromDefinitionRule)ruleChain.getCreate(MATCHER_, FACTORY_);
        boolean success = true;
        int added = 0;
        for (i = 0; i < this.definedClasses_.size(); ++i) {
            defined = this.definedClasses_.get(i);
            reason = this.reasons_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: adding to {} reason: {}", new Object[]{defined, NAME, reason});
            }
            if (rule.definedClasses_.add(defined)) {
                rule.reasons_.add(reason);
                ++added;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            return true;
        }
        for (i = 0; i < this.definedClasses_.size() && added != 0; ++i) {
            --added;
            defined = this.definedClasses_.get(i);
            reason = this.reasons_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: removing from {} reason: {}", new Object[]{defined, NAME, reason});
            }
            int j = rule.indexOf(defined, reason);
            rule.definedClasses_.remove(j);
            rule.reasons_.remove(j);
        }
        return false;
    }

    public boolean removeFrom(Chain<ChainableSubsumerRule> ruleChain) {
        ElkAxiom reason;
        IndexedClass defined;
        int i;
        if (this.isEmpty()) {
            return true;
        }
        IndexedClassFromDefinitionRule rule = (IndexedClassFromDefinitionRule)ruleChain.find(MATCHER_);
        if (rule == null) {
            return false;
        }
        boolean success = true;
        int removed = 0;
        for (i = 0; i < this.definedClasses_.size(); ++i) {
            int j;
            defined = this.definedClasses_.get(i);
            reason = this.reasons_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: removing from {} reason: {}", new Object[]{defined, NAME, reason});
            }
            if ((j = rule.indexOf(defined, reason)) >= 0) {
                rule.definedClasses_.remove(j);
                rule.reasons_.remove(j);
                ++removed;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            if (rule.isEmpty()) {
                ruleChain.remove(MATCHER_);
                LOGGER_.trace("{}: removed ", (Object)NAME);
            }
            return true;
        }
        for (i = 0; i < this.definedClasses_.size() && removed != 0; ++i) {
            --removed;
            defined = this.definedClasses_.get(i);
            reason = this.reasons_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: adding to {} reason: {} [revert]", new Object[]{defined, NAME, reason});
            }
            rule.definedClasses_.add(defined);
            rule.reasons_.add(reason);
        }
        return false;
    }

    private int indexOf(IndexedClass defined, ElkAxiom reason) {
        for (int i = 0; i < this.definedClasses_.size(); ++i) {
            if (!this.definedClasses_.get(i).equals(defined) || !this.reasons_.get(i).equals(reason)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void accept(LinkedSubsumerRuleVisitor<?> visitor, IndexedClassExpression premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }

    protected boolean addDefinedClass(IndexedClass definedClass) {
        return this.definedClasses_.add(definedClass);
    }

    protected boolean removeDefinedClass(IndexedClass definedClass) {
        return this.definedClasses_.remove(definedClass);
    }

    private boolean isEmpty() {
        return this.definedClasses_.isEmpty();
    }
}

