/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.subsumers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectUnionOf;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedObjectUnionOf;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.SubClassInclusionComposedObjectUnionOf;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.AbstractChainableSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ChainableSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.LinkedSubsumerRuleVisitor;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUnionFromDisjunctRule
extends AbstractChainableSubsumerRule {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ObjectUnionFromDisjunctRule.class);
    public static final String NAME = "ObjectUnionOf Introduction";
    private final List<IndexedObjectUnionOf> disjunctions_ = new ArrayList<IndexedObjectUnionOf>();
    private final List<Integer> positions_ = new ArrayList<Integer>();
    private static final Matcher<ChainableSubsumerRule, ObjectUnionFromDisjunctRule> MATCHER_ = new SimpleTypeBasedMatcher(ObjectUnionFromDisjunctRule.class);
    private static final ReferenceFactory<ChainableSubsumerRule, ObjectUnionFromDisjunctRule> FACTORY_ = new ReferenceFactory<ChainableSubsumerRule, ObjectUnionFromDisjunctRule>(){

        public ObjectUnionFromDisjunctRule create(ChainableSubsumerRule tail) {
            return new ObjectUnionFromDisjunctRule(tail);
        }
    };

    private ObjectUnionFromDisjunctRule(ChainableSubsumerRule tail) {
        super(tail);
    }

    private ObjectUnionFromDisjunctRule(IndexedObjectUnionOf disjunction, int position) {
        this(null);
        this.disjunctions_.add(disjunction);
        this.positions_.add(position);
    }

    public static boolean addRulesFor(ModifiableIndexedObjectUnionOf disjunction, ModifiableOntologyIndex index) {
        int pos;
        boolean success = true;
        int added = 0;
        List<? extends ModifiableIndexedClassExpression> disjuncts = disjunction.getDisjuncts();
        for (pos = 0; pos < disjuncts.size(); ++pos) {
            ModifiableIndexedClassExpression disjunct = disjuncts.get(pos);
            if (index.add(disjunct, new ObjectUnionFromDisjunctRule(disjunction, pos))) {
                ++added;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            return true;
        }
        for (pos = 0; pos < disjuncts.size() && added != 0; --added, ++pos) {
            index.remove(disjuncts.get(pos), new ObjectUnionFromDisjunctRule(disjunction, pos));
        }
        return false;
    }

    public static boolean removeRulesFor(ModifiableIndexedObjectUnionOf disjunction, ModifiableOntologyIndex index) {
        int pos;
        boolean success = true;
        int removed = 0;
        List<? extends ModifiableIndexedClassExpression> disjuncts = disjunction.getDisjuncts();
        for (pos = 0; pos < disjuncts.size(); ++pos) {
            ModifiableIndexedClassExpression disjunct = disjuncts.get(pos);
            if (index.remove(disjunct, new ObjectUnionFromDisjunctRule(disjunction, pos))) {
                ++removed;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            return true;
        }
        for (pos = 0; pos < disjuncts.size() && removed != 0; --removed, ++pos) {
            index.add(disjuncts.get(pos), new ObjectUnionFromDisjunctRule(disjunction, pos));
        }
        return false;
    }

    public String toString() {
        return NAME;
    }

    @Override
    public void accept(LinkedSubsumerRuleVisitor<?> visitor, IndexedClassExpression premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }

    @Deprecated
    public Collection<IndexedObjectUnionOf> getDisjunctions() {
        return this.disjunctions_;
    }

    @Override
    public void apply(IndexedClassExpression premise, ContextPremises premises, ClassInferenceProducer producer) {
        for (int i = 0; i < this.disjunctions_.size(); ++i) {
            producer.produce(new SubClassInclusionComposedObjectUnionOf(premises.getRoot(), this.disjunctions_.get(i), this.positions_.get(i)));
        }
    }

    @Override
    public boolean isTracingRule() {
        return true;
    }

    public boolean addTo(Chain<ChainableSubsumerRule> ruleChain) {
        int position;
        IndexedObjectUnionOf disjunction;
        int i;
        if (this.isEmpty()) {
            return true;
        }
        ObjectUnionFromDisjunctRule rule = (ObjectUnionFromDisjunctRule)ruleChain.getCreate(MATCHER_, FACTORY_);
        boolean success = true;
        int added = 0;
        for (i = 0; i < this.disjunctions_.size(); ++i) {
            disjunction = this.disjunctions_.get(i);
            position = this.positions_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: adding to {} matching disjunct position: {}", new Object[]{disjunction, NAME, position});
            }
            if (!rule.disjunctions_.add(disjunction)) {
                success = false;
                break;
            }
            rule.positions_.add(position);
        }
        if (success) {
            return true;
        }
        for (i = 0; i < this.disjunctions_.size() && added != 0; ++i) {
            --added;
            disjunction = this.disjunctions_.get(i);
            position = this.positions_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: removing to {} matching disjunct position: {} [revert]", new Object[]{disjunction, NAME, position});
            }
            int j = rule.indexOf(disjunction, position);
            rule.disjunctions_.remove(j);
            rule.positions_.remove(j);
        }
        return false;
    }

    public boolean removeFrom(Chain<ChainableSubsumerRule> ruleChain) {
        int position;
        IndexedObjectUnionOf disjunction;
        int i;
        if (this.isEmpty()) {
            return true;
        }
        ObjectUnionFromDisjunctRule rule = (ObjectUnionFromDisjunctRule)ruleChain.find(MATCHER_);
        if (rule == null) {
            return false;
        }
        boolean success = true;
        int removed = 0;
        for (i = 0; i < this.disjunctions_.size(); ++i) {
            int j;
            disjunction = this.disjunctions_.get(i);
            position = this.positions_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: removing to {} matching disjunct position: {} [revert]", new Object[]{disjunction, NAME, position});
            }
            if ((j = rule.indexOf(disjunction, position)) >= 0) {
                rule.disjunctions_.remove(j);
                rule.positions_.remove(j);
                ++removed;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            if (rule.isEmpty()) {
                ruleChain.remove(MATCHER_);
                LOGGER_.trace("{}: removed ", (Object)NAME);
            }
            return true;
        }
        for (i = 0; i < this.disjunctions_.size() && removed != 0; ++i) {
            --removed;
            disjunction = this.disjunctions_.get(i);
            position = this.positions_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: adding to {} matching disjunct position: {} [revert]", new Object[]{disjunction, NAME, position});
            }
            rule.disjunctions_.add(disjunction);
            rule.positions_.add(position);
        }
        return false;
    }

    private int indexOf(IndexedObjectUnionOf disjunction, int position) {
        for (int i = 0; i < this.disjunctions_.size(); ++i) {
            if (!this.disjunctions_.get(i).equals(disjunction) || !this.positions_.get(i).equals(position)) continue;
            return i;
        }
        return -1;
    }

    private boolean isEmpty() {
        return this.disjunctions_.isEmpty();
    }
}

