/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractReasonerStage
implements ReasonerStage {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(AbstractReasonerStage.class);
    final AbstractReasonerState reasoner;
    private boolean isInitialized_ = false;
    private boolean isCompleted_ = false;
    int workerNo;
    private final Iterable<AbstractReasonerStage> preStages_;
    private final List<AbstractReasonerStage> postStages_ = new LinkedList<AbstractReasonerStage>();

    public AbstractReasonerStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        this.reasoner = reasoner;
        this.preStages_ = Arrays.asList(preStages);
        for (AbstractReasonerStage preStage : preStages) {
            preStage.postStages_.add(this);
        }
    }

    @Override
    public boolean isCompleted() {
        return this.isCompleted_;
    }

    @Override
    public Iterable<? extends ReasonerStage> getPreStages() {
        return this.preStages_;
    }

    @Override
    public boolean preExecute() {
        if (this.isInitialized_) {
            return false;
        }
        LOGGER_.trace("{}: initialized", (Object)this);
        this.workerNo = this.reasoner.getNumberOfWorkers();
        this.isInitialized_ = true;
        return true;
    }

    @Override
    public boolean postExecute() {
        if (!this.isInitialized_) {
            return false;
        }
        LOGGER_.trace("{}: done", (Object)this);
        this.isCompleted_ = true;
        this.workerNo = 0;
        this.isInitialized_ = false;
        return true;
    }

    abstract void executeStage() throws ElkException;

    @Override
    public void execute() throws ElkException {
        LOGGER_.info("{} using {} workers", (Object)this, (Object)this.workerNo);
        this.reasoner.getProgressMonitor().start(this.getName());
        try {
            this.executeStage();
            this.checkInterrupt();
        }
        finally {
            this.reasoner.getProgressMonitor().finish();
        }
    }

    public String toString() {
        return this.getName();
    }

    boolean invalidate() {
        if (!this.isCompleted_ && !this.isInitialized_) {
            return false;
        }
        LOGGER_.trace("{}: invalidated", (Object)this);
        this.isCompleted_ = false;
        this.isInitialized_ = false;
        return true;
    }

    public void invalidateRecursive() {
        AbstractReasonerStage next;
        LinkedList<AbstractReasonerStage> toInvalidate_ = new LinkedList<AbstractReasonerStage>();
        toInvalidate_.add(this);
        while ((next = (AbstractReasonerStage)toInvalidate_.poll()) != null) {
            if (!next.invalidate()) continue;
            for (AbstractReasonerStage postStage : next.postStages_) {
                toInvalidate_.add(postStage);
            }
        }
    }

    boolean setCompleted() {
        if (this.isCompleted_) {
            return false;
        }
        LOGGER_.trace("{}: marked completed", (Object)this);
        this.isCompleted_ = true;
        return true;
    }

    protected void checkInterrupt() throws ElkInterruptedException {
        this.reasoner.getInterrupter().checkInterrupt();
    }

    protected void markAllContextsAsSaturated() {
        this.reasoner.saturationState.setContextsSaturated(Integer.MAX_VALUE);
    }

    protected SaturationStatistics getRuleAndConclusionStatistics() {
        return this.reasoner.ruleAndConclusionStats;
    }

    public boolean isInterrupted() {
        return this.reasoner.getInterrupter().isInterrupted();
    }
}

