/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.liveontologies.puli.statistics.NestedStats;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ClassQueryLoader;
import org.semanticweb.elk.loading.ComposedAxiomLoader;
import org.semanticweb.elk.loading.EntailmentQueryLoader;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.owl.predefined.PredefinedElkEntityFactory;
import org.semanticweb.elk.owl.predefined.PredefinedElkObjectPropertyFactory;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.owl.visitors.ElkObjectPropertyExpressionVisitor;
import org.semanticweb.elk.owl.visitors.ElkSubObjectPropertyExpressionVisitor;
import org.semanticweb.elk.reasoner.ElkInconsistentOntologyException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.ReasonerInterrupter;
import org.semanticweb.elk.reasoner.completeness.IncompletenessManager;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.consistency.ConsistencyCheckingState;
import org.semanticweb.elk.reasoner.indexing.classes.DifferentialIndex;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkAxiomConverterImpl;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverterImpl;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OntologyIndex;
import org.semanticweb.elk.reasoner.query.EntailmentQueryResult;
import org.semanticweb.elk.reasoner.query.QueryNode;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStateFactory;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.SaturationConclusionBaseFactory;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SaturationConclusion;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.stages.ClassExpressionQueryState;
import org.semanticweb.elk.reasoner.stages.ClassTaxonomyState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.EntailmentQueryState;
import org.semanticweb.elk.reasoner.stages.InstanceTaxonomyState;
import org.semanticweb.elk.reasoner.stages.ObjectPropertyTaxonomyState;
import org.semanticweb.elk.reasoner.stages.OccurrencesInStatedAxiomsStore;
import org.semanticweb.elk.reasoner.stages.PropertyHierarchyCompositionState;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageManager;
import org.semanticweb.elk.reasoner.taxonomy.ElkClassKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.ElkIndividualKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.ElkObjectPropertyKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.OrphanInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.OrphanTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.OrphanTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.SingletoneInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.SingletoneTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNodeFactory;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomy;
import org.semanticweb.elk.reasoner.tracing.Conclusion;
import org.semanticweb.elk.reasoner.tracing.TraceState;
import org.semanticweb.elk.reasoner.tracing.TracingInference;
import org.semanticweb.elk.reasoner.tracing.TracingProof;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentExecutor;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReasonerState
implements TracingProof {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(AbstractReasonerState.class);
    private final ElkObject.Factory elkFactory_;
    final SaturationStatistics ruleAndConclusionStats;
    final DifferentialIndex ontologyIndex;
    final OccurrencesInStatedAxiomsStore occurrencesInStatedAxiomsStore = new OccurrencesInStatedAxiomsStore();
    private AxiomLoader axiomLoader_ = null;
    final PropertyHierarchyCompositionState propertyHierarchyCompositionState_;
    final SaturationState<? extends Context> saturationState;
    final ConsistencyCheckingState consistencyCheckingState;
    final ClassTaxonomyState classTaxonomyState;
    final ObjectPropertyTaxonomyState objectPropertyTaxonomyState;
    final ClassExpressionQueryState classExpressionQueryState_;
    final EntailmentQueryState entailmentQueryState_;
    final InstanceTaxonomyState instanceTaxonomyState;
    private final TraceState traceState_;
    final ReasonerStageManager stageManager;
    private final IncompletenessManager incompleteness_ = new IncompletenessManager(this.occurrencesInStatedAxiomsStore);
    private boolean allowIncrementalMode_ = true;
    private final SaturationConclusion.Factory factory_ = new SaturationConclusionBaseFactory();
    private final ElkPolarityExpressionConverter expressionConverter_;
    private final ElkSubObjectPropertyExpressionVisitor<ModifiableIndexedPropertyChain> subPropertyConverter_;

    protected AbstractReasonerState(ElkObject.Factory elkFactory, ReasonerConfiguration config) {
        this.elkFactory_ = elkFactory;
        this.ontologyIndex = new DifferentialIndex((PredefinedElkEntityFactory)elkFactory);
        this.propertyHierarchyCompositionState_ = new PropertyHierarchyCompositionState();
        this.saturationState = SaturationStateFactory.createSaturationState(this.ontologyIndex);
        this.consistencyCheckingState = ConsistencyCheckingState.create(this.saturationState, this.propertyHierarchyCompositionState_);
        this.instanceTaxonomyState = new InstanceTaxonomyState(this.saturationState, this.ontologyIndex, elkFactory);
        this.classTaxonomyState = new ClassTaxonomyState(this.saturationState, this.ontologyIndex, elkFactory, Arrays.asList(this.instanceTaxonomyState.getClassTaxonomyStateListener()));
        this.objectPropertyTaxonomyState = new ObjectPropertyTaxonomyState((PredefinedElkObjectPropertyFactory)elkFactory);
        this.ruleAndConclusionStats = new SaturationStatistics();
        this.stageManager = new ReasonerStageManager(this);
        this.expressionConverter_ = new ElkPolarityExpressionConverterImpl((PredefinedElkClassFactory)elkFactory, this.ontologyIndex);
        this.subPropertyConverter_ = new ElkAxiomConverterImpl((PredefinedElkClassFactory)elkFactory, this.ontologyIndex);
        this.traceState_ = new TraceState(config, this.saturationState, this.propertyHierarchyCompositionState_, elkFactory, this.ontologyIndex);
        this.classExpressionQueryState_ = new ClassExpressionQueryState(config, this.saturationState, (PredefinedElkClassFactory)elkFactory, this.ontologyIndex, this.factory_);
        this.entailmentQueryState_ = new EntailmentQueryState(config, this.saturationState, this.consistencyCheckingState, this.factory_, this.incompleteness_);
    }

    public ElkObject.Factory getElkFactory() {
        return this.elkFactory_;
    }

    protected void complete(ReasonerStage stage) throws ElkException {
        this.getStageExecutor().complete(stage);
    }

    protected void completeUninterruptibly(ReasonerStage stage) throws ElkException {
        while (true) {
            try {
                this.complete(stage);
            }
            catch (ElkInterruptedException e) {
                continue;
            }
            break;
        }
    }

    public synchronized void setAllowIncrementalMode(boolean allow) {
        if (this.allowIncrementalMode_ == allow) {
            return;
        }
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.debug("Incremental mode is " + (allow ? "allowed" : "disallowed"));
        }
        this.allowIncrementalMode_ = allow;
        if (!allow) {
            this.setNonIncrementalMode();
        }
    }

    public synchronized boolean isAllowIncrementalMode() {
        return this.allowIncrementalMode_;
    }

    public synchronized boolean isIncrementalMode() {
        return this.ontologyIndex.isIncrementalMode();
    }

    void setNonIncrementalMode() {
        if (!this.isIncrementalMode()) {
            return;
        }
        this.ontologyIndex.setIncrementalMode(false);
    }

    boolean trySetIncrementalMode() {
        if (!this.allowIncrementalMode_) {
            return false;
        }
        this.ontologyIndex.setIncrementalMode(true);
        return true;
    }

    public synchronized void registerAxiomLoader(AxiomLoader.Factory axiomLoaderFactory) {
        LOGGER_.trace("Registering new axiom loader");
        AxiomLoader newAxiomLoader = axiomLoaderFactory.getAxiomLoader((InterruptMonitor)this.getInterrupter());
        this.axiomLoader_ = this.axiomLoader_ == null || this.axiomLoader_.isLoadingFinished() ? newAxiomLoader : new ComposedAxiomLoader(this.axiomLoader_, newAxiomLoader);
    }

    AxiomLoader getAxiomLoader() {
        return this.axiomLoader_;
    }

    ClassQueryLoader getClassQueryLoader() {
        return this.classExpressionQueryState_.getQueryLoader((InterruptMonitor)this.getInterrupter());
    }

    EntailmentQueryLoader getEntailmentQueryLoader() {
        return this.entailmentQueryState_.getQueryLoader((InterruptMonitor)this.getInterrupter());
    }

    protected synchronized boolean isLoadingFinished() {
        ClassQueryLoader classQueryLoader = this.getClassQueryLoader();
        EntailmentQueryLoader entailmentQueryLoader = this.getEntailmentQueryLoader();
        return !(this.axiomLoader_ != null && !this.axiomLoader_.isLoadingFinished() || classQueryLoader != null && !classQueryLoader.isLoadingFinished() || entailmentQueryLoader != null && !entailmentQueryLoader.isLoadingFinished());
    }

    public synchronized void ensureLoading() throws ElkException {
        if (!this.isLoadingFinished()) {
            if (this.isIncrementalMode()) {
                if (!this.stageManager.incrementalAdditionStage.isCompleted()) {
                    this.complete(this.stageManager.incrementalAdditionStage);
                }
            } else if (!this.stageManager.contextInitializationStage.isCompleted()) {
                this.complete(this.stageManager.contextInitializationStage);
            }
            LOGGER_.trace("Reset axiom loading");
            this.stageManager.inputLoadingStage.invalidateRecursive();
            this.stageManager.contextInitializationStage.invalidateRecursive();
            this.stageManager.incrementalCompletionStage.invalidateRecursive();
        }
        this.complete(this.stageManager.inputLoadingStage);
    }

    private void restoreSaturation() throws ElkException {
        boolean changed;
        this.ensureLoading();
        if (this.isIncrementalMode()) {
            changed = !this.stageManager.incrementalTaxonomyCleaningStage.isCompleted();
            this.complete(this.stageManager.incrementalTaxonomyCleaningStage);
        } else {
            changed = !this.stageManager.contextInitializationStage.isCompleted();
            this.complete(this.stageManager.contextInitializationStage);
        }
        if (changed) {
            this.stageManager.consistencyCheckingStage.invalidateRecursive();
        }
    }

    protected abstract int getNumberOfWorkers();

    protected abstract ReasonerStageExecutor getStageExecutor();

    protected abstract ReasonerInterrupter getInterrupter();

    protected abstract ConcurrentExecutor getProcessExecutor();

    protected abstract ProgressMonitor getProgressMonitor();

    protected ModifiableOntologyIndex getModifiableOntologyIndex() {
        return this.ontologyIndex;
    }

    public void interrupt() {
        LOGGER_.debug("Interrupt requested");
        this.getInterrupter().interrupt();
    }

    public synchronized void checkInterrupt() throws ElkInterruptedException {
        this.getInterrupter().checkInterrupt();
    }

    private void restoreConsistencyCheck() throws ElkException {
        this.ruleAndConclusionStats.reset();
        this.restoreSaturation();
        this.complete(this.stageManager.consistencyCheckingStage);
    }

    public synchronized boolean isInconsistent() throws ElkException {
        this.restoreConsistencyCheck();
        if (!this.consistencyCheckingState.isInconsistent()) {
            this.incompleteness_.log(this.incompleteness_.getIncompletenessMonitorForClassification());
        }
        return this.consistencyCheckingState.isInconsistent();
    }

    protected Taxonomy<ElkClass> restoreTaxonomy() throws ElkInconsistentOntologyException, ElkException {
        this.ruleAndConclusionStats.reset();
        this.restoreConsistencyCheck();
        if (this.consistencyCheckingState.isInconsistent()) {
            throw new ElkInconsistentOntologyException();
        }
        this.complete(this.stageManager.classTaxonomyComputationStage);
        return this.classTaxonomyState.getTaxonomy();
    }

    public synchronized Taxonomy<ElkClass> getTaxonomy() throws ElkInconsistentOntologyException, ElkException {
        this.restoreTaxonomy();
        this.incompleteness_.log(this.incompleteness_.getIncompletenessMonitorForClassification());
        return this.classTaxonomyState.getTaxonomy();
    }

    public synchronized Taxonomy<ElkClass> getTaxonomyQuietly() throws ElkException {
        Taxonomy<ElkClass> result;
        try {
            result = this.getTaxonomy();
        }
        catch (ElkInconsistentOntologyException e) {
            LOGGER_.debug("Ontology is inconsistent");
            result = new SingletoneTaxonomy<ElkClass, OrphanTaxonomyNode<ElkClass>>(ElkClassKeyProvider.INSTANCE, this.getAllClasses(), new TaxonomyNodeFactory<ElkClass, OrphanTaxonomyNode<ElkClass>, Taxonomy<ElkClass>>(){

                @Override
                public OrphanTaxonomyNode<ElkClass> createNode(Iterable<? extends ElkClass> members, int size, Taxonomy<ElkClass> taxonomy) {
                    return new OrphanTaxonomyNode<ElkClass>(members, size, AbstractReasonerState.this.elkFactory_.getOwlNothing(), taxonomy);
                }
            });
        }
        return result;
    }

    public synchronized Taxonomy<ElkClass> getTaxonomyQuietlyUninterruptibly() throws ElkException {
        while (true) {
            try {
                return this.getTaxonomyQuietly();
            }
            catch (ElkInterruptedException e) {
                continue;
            }
            break;
        }
    }

    protected InstanceTaxonomy<ElkClass, ElkNamedIndividual> restoreInstanceTaxonomy() throws ElkInconsistentOntologyException, ElkException {
        this.ruleAndConclusionStats.reset();
        this.restoreConsistencyCheck();
        if (this.consistencyCheckingState.isInconsistent()) {
            throw new ElkInconsistentOntologyException();
        }
        this.complete(this.stageManager.instanceTaxonomyComputationStage);
        return this.instanceTaxonomyState.getTaxonomy();
    }

    public synchronized InstanceTaxonomy<ElkClass, ElkNamedIndividual> getInstanceTaxonomy() throws ElkInconsistentOntologyException, ElkException {
        this.restoreInstanceTaxonomy();
        this.incompleteness_.log(this.incompleteness_.getIncompletenessMonitorForClassification());
        return this.instanceTaxonomyState.getTaxonomy();
    }

    public synchronized InstanceTaxonomy<ElkClass, ElkNamedIndividual> getInstanceTaxonomyQuietly() throws ElkException {
        InstanceTaxonomy<ElkClass, ElkNamedIndividual> result;
        try {
            result = this.getInstanceTaxonomy();
        }
        catch (ElkInconsistentOntologyException e) {
            LOGGER_.debug("Ontology is inconsistent");
            result = new SingletoneInstanceTaxonomy<ElkClass, ElkEntity, OrphanTypeNode<ElkClass, ElkNamedIndividual>>(ElkClassKeyProvider.INSTANCE, this.getAllClasses(), new TaxonomyNodeFactory<ElkClass, OrphanTypeNode<ElkClass, ElkNamedIndividual>, Taxonomy<ElkClass>>(){

                @Override
                public OrphanTypeNode<ElkClass, ElkNamedIndividual> createNode(Iterable<? extends ElkClass> members, int size, Taxonomy<ElkClass> taxonomy) {
                    OrphanTypeNode<ElkClass, ElkNamedIndividual> node = new OrphanTypeNode<ElkClass, ElkNamedIndividual>(members, size, AbstractReasonerState.this.elkFactory_.getOwlNothing(), taxonomy, 1);
                    Set<ElkNamedIndividual> allNamedIndividuals = AbstractReasonerState.this.getAllNamedIndividuals();
                    Iterator<ElkNamedIndividual> namedIndividualIterator = allNamedIndividuals.iterator();
                    if (namedIndividualIterator.hasNext()) {
                        node.addInstanceNode(new OrphanInstanceNode<ElkClass, ElkNamedIndividual>((Iterable<ElkNamedIndividual>)allNamedIndividuals, allNamedIndividuals.size(), (ElkNamedIndividual)((ElkEntity)namedIndividualIterator.next()), ElkIndividualKeyProvider.INSTANCE, node));
                    }
                    return node;
                }
            }, ElkIndividualKeyProvider.INSTANCE);
        }
        return result;
    }

    public synchronized Taxonomy<ElkObjectProperty> getObjectPropertyTaxonomy() throws ElkInconsistentOntologyException, ElkException {
        this.ruleAndConclusionStats.reset();
        this.restoreConsistencyCheck();
        if (this.consistencyCheckingState.isInconsistent()) {
            throw new ElkInconsistentOntologyException();
        }
        LOGGER_.trace("Property hierarchy computation");
        this.complete(this.stageManager.objectPropertyTaxonomyComputationStage);
        this.incompleteness_.log(this.incompleteness_.getIncompletenessMonitorForClassification());
        return this.objectPropertyTaxonomyState.getTaxonomy();
    }

    public synchronized Taxonomy<ElkObjectProperty> getObjectPropertyTaxonomyQuietly() throws ElkException {
        Taxonomy<ElkObjectProperty> result;
        try {
            result = this.getObjectPropertyTaxonomy();
        }
        catch (ElkInconsistentOntologyException e) {
            LOGGER_.debug("Ontology is inconsistent");
            result = new SingletoneTaxonomy<ElkObjectProperty, OrphanTaxonomyNode<ElkObjectProperty>>(ElkObjectPropertyKeyProvider.INSTANCE, this.getAllObjectProperties(), new TaxonomyNodeFactory<ElkObjectProperty, OrphanTaxonomyNode<ElkObjectProperty>, Taxonomy<ElkObjectProperty>>(){

                @Override
                public OrphanTaxonomyNode<ElkObjectProperty> createNode(Iterable<? extends ElkObjectProperty> members, int size, Taxonomy<ElkObjectProperty> taxonomy) {
                    return new OrphanTaxonomyNode<ElkObjectProperty>(members, size, AbstractReasonerState.this.elkFactory_.getOwlBottomObjectProperty(), taxonomy);
                }
            });
        }
        return result;
    }

    private boolean computeQuery(ElkClassExpression classExpression, boolean computeInstanceTaxonomy) throws ElkInconsistentOntologyException, ElkException {
        this.classExpressionQueryState_.registerQuery(classExpression);
        this.ensureLoading();
        if (computeInstanceTaxonomy) {
            this.restoreInstanceTaxonomy();
        } else {
            this.restoreTaxonomy();
        }
        if (!this.classExpressionQueryState_.isIndexed(classExpression)) {
            return false;
        }
        if (this.classExpressionQueryState_.isComputed(classExpression)) {
            return true;
        }
        this.stageManager.classExpressionQueryStage.invalidateRecursive();
        try {
            this.complete(this.stageManager.classExpressionQueryStage);
        }
        catch (ElkInterruptedException e) {
            if (this.classExpressionQueryState_.isComputed(classExpression)) {
                this.stageManager.classExpressionQueryStage.postExecute();
            }
            throw e;
        }
        return true;
    }

    protected boolean querySatisfiability(ElkClassExpression classExpression) throws ElkInconsistentOntologyException, ElkException {
        boolean result = this.computeQuery(classExpression, false) ? this.classExpressionQueryState_.isSatisfiable(classExpression) : true;
        if (result) {
            this.incompleteness_.log(this.incompleteness_.getIncompletenessMonitorForClassExpressionQuery(this.classExpressionQueryState_.getOccurrenceStore(classExpression)));
        }
        return result;
    }

    protected Node<ElkClass> queryEquivalentClasses(ElkClassExpression classExpression) throws ElkInconsistentOntologyException, ElkException {
        Node<ElkClass> r;
        Node<Object> result = this.computeQuery(classExpression, false) ? ((r = this.classExpressionQueryState_.getEquivalentClasses(classExpression)) == null ? this.classTaxonomyState.getTaxonomy().getBottomNode() : r) : new QueryNode<ElkEntity>(ElkClassKeyProvider.INSTANCE);
        this.incompleteness_.log(this.incompleteness_.getIncompletenessMonitorForClassExpressionQuery(this.classExpressionQueryState_.getOccurrenceStore(classExpression)));
        return result;
    }

    protected Set<? extends Node<ElkClass>> queryDirectSuperClasses(ElkClassExpression classExpression) throws ElkInconsistentOntologyException, ElkException {
        Set<? extends Node<ElkClass>> r;
        Set<Node<Object>> result = this.computeQuery(classExpression, false) ? ((r = this.classExpressionQueryState_.getDirectSuperClasses(classExpression)) == null ? this.classTaxonomyState.getTaxonomy().getBottomNode().getDirectSuperNodes() : r) : Collections.singleton(this.classTaxonomyState.getTaxonomy().getTopNode());
        this.incompleteness_.log(this.incompleteness_.getIncompletenessMonitorForClassExpressionQuery(this.classExpressionQueryState_.getOccurrenceStore(classExpression)));
        return result;
    }

    protected Set<? extends Node<ElkClass>> queryDirectSubClasses(ElkClassExpression classExpression) throws ElkInconsistentOntologyException, ElkException {
        UpdateableTaxonomy<ElkClass> taxonomy;
        Set<? extends Node<ElkClass>> r;
        Set<Node<Object>> result = this.computeQuery(classExpression, false) ? ((r = this.classExpressionQueryState_.getDirectSubClasses(classExpression, taxonomy = this.classTaxonomyState.getTaxonomy())) == null ? taxonomy.getBottomNode().getDirectSubNodes() : r) : Collections.singleton(this.classTaxonomyState.getTaxonomy().getBottomNode());
        this.incompleteness_.log(this.incompleteness_.getIncompletenessMonitorForClassExpressionQuery(this.classExpressionQueryState_.getOccurrenceStore(classExpression)));
        return result;
    }

    protected Set<? extends Node<ElkNamedIndividual>> queryDirectInstances(ElkClassExpression classExpression) throws ElkInconsistentOntologyException, ElkException {
        UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy;
        Set<? extends Node<ElkNamedIndividual>> r;
        Set<Object> result = this.computeQuery(classExpression, true) ? ((r = this.classExpressionQueryState_.getDirectInstances(classExpression, taxonomy = this.instanceTaxonomyState.getTaxonomy())) == null ? taxonomy.getBottomNode().getDirectInstanceNodes() : r) : Collections.emptySet();
        this.incompleteness_.log(this.incompleteness_.getIncompletenessMonitorForClassExpressionQuery(this.classExpressionQueryState_.getOccurrenceStore(classExpression)));
        return result;
    }

    public synchronized Map<ElkAxiom, EntailmentQueryResult> isEntailed(Iterable<? extends ElkAxiom> axioms) throws ElkException {
        this.entailmentQueryState_.registerQueries(axioms);
        this.restoreSaturation();
        this.stageManager.entailmentQueryStage.invalidateRecursive();
        this.complete(this.stageManager.entailmentQueryStage);
        return this.entailmentQueryState_.isEntailed(axioms);
    }

    public synchronized EntailmentQueryResult isEntailed(ElkAxiom axiom) throws ElkException {
        return this.isEntailed(Collections.singleton(axiom)).get(axiom);
    }

    public synchronized Set<ElkClass> getAllClasses() {
        ArrayHashSet result = new ArrayHashSet(this.ontologyIndex.getClasses().size());
        for (IndexedClass indexedClass : this.ontologyIndex.getClasses()) {
            result.add(indexedClass.getElkEntity());
        }
        return result;
    }

    public synchronized Set<ElkNamedIndividual> getAllNamedIndividuals() {
        ArrayHashSet allNamedIndividuals = new ArrayHashSet(this.ontologyIndex.getClasses().size());
        for (IndexedIndividual indexedIndividual : this.ontologyIndex.getIndividuals()) {
            allNamedIndividuals.add(indexedIndividual.getElkEntity());
        }
        return allNamedIndividuals;
    }

    public synchronized Set<ElkObjectProperty> getAllObjectProperties() {
        ArrayHashSet result = new ArrayHashSet(this.ontologyIndex.getObjectProperties().size());
        for (IndexedObjectProperty indexedObjectProperty : this.ontologyIndex.getObjectProperties()) {
            result.add(indexedObjectProperty.getElkEntity());
        }
        return result;
    }

    public synchronized boolean doneConsistencyCheck() {
        return this.stageManager.consistencyCheckingStage.isCompleted();
    }

    public synchronized boolean doneTaxonomy() {
        return this.stageManager.classTaxonomyComputationStage.isCompleted();
    }

    public synchronized boolean doneInstanceTaxonomy() {
        return this.stageManager.instanceTaxonomyComputationStage.isCompleted();
    }

    public synchronized boolean doneObjectPropertyTaxonomy() {
        return this.stageManager.objectPropertyTaxonomyComputationStage.isCompleted();
    }

    protected OntologyIndex getOntologyIndex() throws ElkException {
        this.ensureLoading();
        return this.ontologyIndex;
    }

    @Deprecated
    public ElkPolarityExpressionConverter getExpressionConverter() {
        return this.expressionConverter_;
    }

    @Deprecated
    public ElkSubObjectPropertyExpressionVisitor<? extends IndexedPropertyChain> getSubPropertyConverter() {
        return this.subPropertyConverter_;
    }

    public TracingProof getProof() {
        return this;
    }

    public Collection<? extends TracingInference> getInferences(Object conclusion) {
        if (!(conclusion instanceof Conclusion)) {
            return Collections.emptySet();
        }
        try {
            this.getTaxonomyQuietlyUninterruptibly();
            if (!this.traceState_.requestInferences((Conclusion)conclusion)) {
                this.stageManager.inferenceTracingStage.invalidateRecursive();
                this.completeUninterruptibly(this.stageManager.inferenceTracingStage);
            }
        }
        catch (ElkException e) {
            throw new ElkRuntimeException((Throwable)e);
        }
        return this.traceState_.getInferences(conclusion);
    }

    @NestedStats(name="traceState")
    public Object getStatsNestedInTraceSate() {
        return this.traceState_.getStats();
    }

    @Deprecated
    IndexedClassExpression transform(ElkClassExpression ce) {
        return (IndexedClassExpression)ce.accept((ElkClassExpressionVisitor)this.expressionConverter_);
    }

    @Deprecated
    IndexedObjectProperty transform(ElkObjectProperty ce) {
        return (IndexedObjectProperty)ce.accept((ElkObjectPropertyExpressionVisitor)this.expressionConverter_);
    }

    @Deprecated
    IndexedPropertyChain transform(ElkSubObjectPropertyExpression ce) {
        return (IndexedPropertyChain)ce.accept(this.subPropertyConverter_);
    }

    TraceState getTraceState() {
        return this.traceState_;
    }

    @Deprecated
    public synchronized Collection<? extends IndexedClassExpression> getIndexedClassExpressions() {
        return this.ontologyIndex.getClassExpressions();
    }
}

