/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collection;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.taxonomy.ClassTaxonomyComputation;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;

public class ClassTaxonomyComputationStage
extends AbstractReasonerStage {
    protected ClassTaxonomyComputation computation_ = null;

    public ClassTaxonomyComputationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Taxonomy Construction";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        Collection<IndexedClass> toAdd = this.reasoner.classTaxonomyState.getToAdd();
        this.computation_ = new ClassTaxonomyComputation(Operations.split(toAdd, (int)64), (InterruptMonitor)this.reasoner.getInterrupter(), this.reasoner.getProcessExecutor(), this.workerNo, this.reasoner.getProgressMonitor(), this.reasoner.saturationState, this.reasoner.classTaxonomyState.getTaxonomy());
        return true;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        this.computation_.process();
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        Collection<IndexedClass> toAdd = this.reasoner.classTaxonomyState.getToAdd();
        if (!toAdd.isEmpty()) {
            throw new ElkRuntimeException(ClassTaxonomyComputation.class.getSimpleName() + " did not add all classes to the taxonomy!");
        }
        this.reasoner.classTaxonomyState.taxonomyComplete();
        this.reasoner.ontologyIndex.initClassChanges();
        this.reasoner.ruleAndConclusionStats.add(this.computation_.getRuleAndConclusionStatistics());
        this.computation_ = null;
        return true;
    }

    @Override
    public void printInfo() {
        if (this.computation_ != null) {
            this.computation_.printStatistics();
        }
    }
}

