/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.classes.DifferentialIndex;
import org.semanticweb.elk.reasoner.indexing.classes.OntologyIndexDummyChangeListener;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverterImpl;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.OntologyIndex;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStateDummyChangeListener;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentClassTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.DummyNodeStoreListener;
import org.semanticweb.elk.reasoner.taxonomy.DummyTaxonomyListener;
import org.semanticweb.elk.reasoner.taxonomy.ElkClassKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeStore;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomy;
import org.semanticweb.elk.util.collections.Operations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassTaxonomyState {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ClassTaxonomyState.class);
    private UpdateableTaxonomy<ElkClass> taxonomy_ = null;
    private final Queue<IndexedClass> toAdd_ = new ConcurrentLinkedQueue<IndexedClass>();
    private final Queue<IndexedClass> toRemove_ = new ConcurrentLinkedQueue<IndexedClass>();
    private final ElkObject.Factory elkFactory_;
    private final OntologyIndex ontologyIndex_;
    private final SaturationState<?> saturationState_;
    private final ElkPolarityExpressionConverter converter_;
    private final List<Listener> listeners_ = new ArrayList<Listener>();
    private final NodeStore.Listener<ElkClass> nodeStoreListener_ = new DummyNodeStoreListener<ElkClass>(){

        @Override
        public void memberForNodeDisappeared(ElkClass member, Node<ElkClass> node) {
            ClassTaxonomyState.this.addToAdd(member);
        }
    };
    private final Taxonomy.Listener<ElkClass> taxonomyListener_ = new DummyTaxonomyListener<ElkClass>(){

        @Override
        public void directSuperNodesDisappeared(TaxonomyNode<ElkClass> subNode) {
            for (ElkClass elkClass : subNode) {
                ClassTaxonomyState.this.addToAdd(elkClass);
            }
        }
    };

    <C extends Context> ClassTaxonomyState(SaturationState<C> saturationState, DifferentialIndex ontologyIndex, ElkObject.Factory elkFactory, Collection<Listener> listeners) {
        this.elkFactory_ = elkFactory;
        this.ontologyIndex_ = ontologyIndex;
        this.saturationState_ = saturationState;
        this.converter_ = new ElkPolarityExpressionConverterImpl((PredefinedElkClassFactory)elkFactory, ontologyIndex);
        this.listeners_.addAll(listeners);
        this.resetTaxonomy();
        ontologyIndex.addListener(new OntologyIndexDummyChangeListener(){

            @Override
            public void classAddition(IndexedClass cls) {
                ClassTaxonomyState.this.toAdd_.add(cls);
            }

            @Override
            public void classRemoval(IndexedClass cls) {
                ClassTaxonomyState.this.toRemove_.add(cls);
            }
        });
        saturationState.addListener(new SaturationStateDummyChangeListener<C>(){

            @Override
            public void contextMarkNonSaturated(C context) {
                IndexedContextRoot root = context.getRoot();
                if (root instanceof IndexedClass) {
                    IndexedClass cls = (IndexedClass)root;
                    ClassTaxonomyState.this.toRemove_.add(cls);
                }
            }

            @Override
            public void contextsClear() {
                ClassTaxonomyState.this.resetTaxonomy();
            }
        });
    }

    public <C extends Context> ClassTaxonomyState(SaturationState<C> saturationState, DifferentialIndex ontologyIndex, ElkObject.Factory elkFactory) {
        this(saturationState, ontologyIndex, elkFactory, Collections.emptyList());
    }

    public UpdateableTaxonomy<ElkClass> getTaxonomy() {
        return this.taxonomy_;
    }

    private void addToAdd(ElkClass elkClass) {
        ModifiableIndexedClassExpression converted = (ModifiableIndexedClassExpression)elkClass.accept((ElkClassExpressionVisitor)this.converter_);
        if (converted != null && converted instanceof IndexedClass) {
            IndexedClass cls = (IndexedClass)((Object)converted);
            this.toAdd_.add(cls);
        }
    }

    private int pruneToAdd() {
        Iterator iter = this.toAdd_.iterator();
        int size = 0;
        while (iter.hasNext()) {
            IndexedClass cls = (IndexedClass)iter.next();
            if (!cls.occurs()) {
                iter.remove();
                continue;
            }
            Object context = this.saturationState_.getContext(cls);
            if (context == null || !context.isInitialized() || !context.isSaturated()) {
                ++size;
                continue;
            }
            TaxonomyNode<ElkClass> node = this.taxonomy_.getNode(cls.getElkEntity());
            if (node == null) {
                ++size;
                continue;
            }
            if (node.equals(this.taxonomy_.getTopNode())) {
                iter.remove();
                continue;
            }
            if (!node.getDirectSuperNodes().isEmpty()) {
                iter.remove();
                continue;
            }
            ++size;
        }
        return size;
    }

    Collection<IndexedClass> getToAdd() {
        int size = this.pruneToAdd();
        return Operations.getCollection(this.toAdd_, (int)size);
    }

    private int pruneToRemove() {
        Iterator iter = this.toRemove_.iterator();
        int size = 0;
        while (iter.hasNext()) {
            IndexedClass cls = (IndexedClass)iter.next();
            TaxonomyNode<ElkClass> node = this.taxonomy_.getNode(cls.getElkEntity());
            if (node == null) {
                iter.remove();
                continue;
            }
            if (cls == this.ontologyIndex_.getOwlNothing()) {
                iter.remove();
                continue;
            }
            ++size;
        }
        return size;
    }

    Collection<IndexedClass> getToRemove() {
        int size = this.pruneToRemove();
        return Operations.getCollection(this.toRemove_, (int)size);
    }

    void resetTaxonomy() {
        LOGGER_.trace("Reset class taxonomy");
        UpdateableTaxonomy<ElkClass> old = this.taxonomy_;
        if (this.taxonomy_ != null) {
            this.taxonomy_.removeListener(this.nodeStoreListener_);
            this.taxonomy_.removeListener(this.taxonomyListener_);
        }
        this.taxonomy_ = new ConcurrentClassTaxonomy((PredefinedElkClassFactory)this.elkFactory_, ElkClassKeyProvider.INSTANCE);
        for (Listener listener : this.listeners_) {
            listener.taxonomyReset(old, this.taxonomy_);
        }
        this.taxonomy_.addListener(this.nodeStoreListener_);
        this.taxonomy_.addListener(this.taxonomyListener_);
        this.toRemove_.clear();
        this.toAdd_.clear();
        this.toAdd_.addAll(this.ontologyIndex_.getClasses());
    }

    void taxonomyComplete() {
        this.toRemove_.clear();
        this.toAdd_.clear();
    }

    void addListener(Listener listener) {
        this.listeners_.add(listener);
    }

    void removeListener(Listener listener) {
        this.listeners_.remove(listener);
    }

    static interface Listener {
        public void taxonomyReset(UpdateableTaxonomy<ElkClass> var1, UpdateableTaxonomy<ElkClass> var2);
    }
}

