/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collection;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassEntity;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturation;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationAdditionFactory;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationInput;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;

class EntailmentQueryStage
extends AbstractReasonerStage {
    protected ClassExpressionSaturation<IndexedContextRoot> computation_ = null;

    public EntailmentQueryStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Entailment Query Computation";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        Collection<IndexedContextRoot> queries = this.reasoner.entailmentQueryState_.getNotSaturatedPositivelyIndexedRoots();
        Collection<? extends IndexedClassEntity> consistencyTestEntities = this.reasoner.consistencyCheckingState.getTestEntitites();
        Collection inputs = Operations.getCollection((Iterable)Operations.concat((Iterable[])new Iterable[]{queries, consistencyTestEntities}), (int)(queries.size() + consistencyTestEntities.size()));
        this.computation_ = new ClassExpressionSaturation(inputs, this.reasoner.getProcessExecutor(), this.workerNo, this.reasoner.getProgressMonitor(), new RuleApplicationAdditionFactory<RuleApplicationInput>((InterruptMonitor)this.reasoner.getInterrupter(), (SaturationState<?>)this.reasoner.saturationState));
        return true;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        this.computation_.process();
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.reasoner.ruleAndConclusionStats.add(this.computation_.getRuleAndConclusionStatistics());
        this.computation_ = null;
        return true;
    }

    @Override
    public void printInfo() {
        if (this.computation_ != null) {
            this.computation_.printStatistics();
        }
    }
}

