/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.liveontologies.puli.Proof;
import org.liveontologies.puli.Proofs;
import org.semanticweb.elk.loading.AbstractEntailmentQueryLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.loading.EntailmentQueryLoader;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.visitors.ElkAxiomVisitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessManager;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.consistency.ConsistencyCheckingState;
import org.semanticweb.elk.reasoner.entailments.InconsistencyProofWrapper;
import org.semanticweb.elk.reasoner.entailments.model.Entailment;
import org.semanticweb.elk.reasoner.entailments.model.EntailmentInference;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexingListener;
import org.semanticweb.elk.reasoner.indexing.model.Occurrence;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceStore;
import org.semanticweb.elk.reasoner.query.AbstractProperEntailmentQueryResult;
import org.semanticweb.elk.reasoner.query.ElkQueryException;
import org.semanticweb.elk.reasoner.query.EntailmentQueryConverter;
import org.semanticweb.elk.reasoner.query.EntailmentQueryResult;
import org.semanticweb.elk.reasoner.query.IndexedEntailmentQuery;
import org.semanticweb.elk.reasoner.query.UnsupportedIndexingEntailmentQueryResultImpl;
import org.semanticweb.elk.reasoner.query.UnsupportedQueryTypeEntailmentQueryResultImpl;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SaturationConclusion;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.Condition;
import org.semanticweb.elk.util.collections.Evictor;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntailmentQueryState
implements EntailmentQueryLoader.Factory {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(EntailmentQueryState.class);
    private final Map<ElkAxiom, QueryState> queried_ = new ConcurrentHashMap<ElkAxiom, QueryState>();
    private final Queue<ElkAxiom> toLoad_ = new ConcurrentLinkedQueue<ElkAxiom>();
    private final Evictor<QueryState> queriedEvictor_;
    private final Set<ElkAxiom> lastQueries_ = new ArrayHashSet();
    private final SaturationState<? extends Context> saturationState_;
    private final ConsistencyCheckingState consistencyCheckingState_;
    private final SaturationConclusion.Factory conclusionFactory_;
    private final IncompletenessManager incompleteness_;
    private final QueryIndexingListener indexingListener_ = new QueryIndexingListener();
    private final Predicate<QueryState> doNotEvict_ = new Predicate<QueryState>(){

        public boolean apply(QueryState state) {
            return state.isLocked() || EntailmentQueryState.this.lastQueries_.contains(state.getQuery());
        }
    };
    private final Condition<IndexedContextRoot> IS_NOT_SATURATED = new Condition<IndexedContextRoot>(){

        public boolean holds(IndexedContextRoot root) {
            Object context = EntailmentQueryState.this.saturationState_.getContext(root);
            return context == null || !context.isInitialized() || !context.isSaturated();
        }
    };
    private final Operations.Transformation<QueryState, Iterable<? extends IndexedContextRoot>> POSITIVELY_INDEXED = new Operations.Transformation<QueryState, Iterable<? extends IndexedContextRoot>>(){

        public Iterable<? extends IndexedContextRoot> transform(QueryState state) {
            if (state.indexed == null) {
                return null;
            }
            Collection<IndexedContextRoot> roots = state.indexed.getPositivelyIndexed();
            return Operations.filter(roots, (Condition)EntailmentQueryState.this.IS_NOT_SATURATED);
        }
    };

    public <C extends Context> EntailmentQueryState(ReasonerConfiguration config, SaturationState<C> saturationState, ConsistencyCheckingState consistencyCheckingState, SaturationConclusion.Factory factory, IncompletenessManager incompletenessManager) {
        this.saturationState_ = saturationState;
        this.consistencyCheckingState_ = consistencyCheckingState;
        this.conclusionFactory_ = factory;
        this.incompleteness_ = incompletenessManager;
        Object builder = config.getParameter("elk.reasoner.entailmentquery.evictor");
        LOGGER_.info("{} = {}", (Object)"elk.reasoner.entailmentquery.evictor", builder);
        this.queriedEvictor_ = ((Evictor.Builder)builder).build();
    }

    void registerQueries(Iterable<? extends ElkAxiom> axioms) {
        this.lastQueries_.clear();
        for (ElkAxiom elkAxiom : axioms) {
            LOGGER_.trace("entailment query registered {}", (Object)elkAxiom);
            this.lastQueries_.add(elkAxiom);
            QueryState state = this.queried_.get(elkAxiom);
            if (state != null) {
                this.queriedEvictor_.add((Object)state);
                continue;
            }
            state = new QueryState(elkAxiom);
            this.queried_.put(elkAxiom, state);
            this.queriedEvictor_.add((Object)state);
            this.toLoad_.offer(elkAxiom);
        }
    }

    public IndexingListener getIndexingListener() {
        return this.indexingListener_;
    }

    @Override
    public EntailmentQueryLoader getQueryLoader(InterruptMonitor interrupter) {
        QueryIndexingListener queryIndexingListener = this.indexingListener_;
        Objects.requireNonNull(queryIndexingListener);
        return queryIndexingListener.new QueryIndexingListener.Loader(interrupter);
    }

    Collection<IndexedContextRoot> getNotSaturatedPositivelyIndexedRoots() {
        int sizeUpper = 0;
        for (QueryState state : this.queried_.values()) {
            if (state.indexed == null) continue;
            sizeUpper += state.indexed.getPositivelyIndexed().size();
        }
        Iterable result = Operations.concat((Iterable)Operations.map(this.queried_.values(), this.POSITIVELY_INDEXED));
        return Operations.getCollection((Iterable)result, (int)sizeUpper);
    }

    private OccurrenceStore getOccurrenceStore(final QueryState state) {
        return new OccurrenceStore(){

            @Override
            public Collection<? extends ElkObject> occursIn(Occurrence occurrence) {
                if (state == null || state.occurrences == null || !state.occurrences.containsKey((Object)occurrence)) {
                    return Collections.emptySet();
                }
                return Collections.singleton(state.getQuery());
            }
        };
    }

    Map<ElkAxiom, EntailmentQueryResult> isEntailed(Iterable<? extends ElkAxiom> axioms) throws ElkQueryException {
        ArrayHashMap results = new ArrayHashMap();
        for (ElkAxiom elkAxiom : axioms) {
            if (!EntailmentQueryConverter.isEntailmentCheckingSupported(elkAxiom.getClass())) {
                results.put(elkAxiom, new UnsupportedQueryTypeEntailmentQueryResultImpl(elkAxiom));
                continue;
            }
            QueryState state = this.queried_.get(elkAxiom);
            if (state == null) {
                throw new ElkQueryException("Query was not registered: " + elkAxiom);
            }
            if (state.indexed == null) {
                results.put(elkAxiom, new UnsupportedIndexingEntailmentQueryResultImpl(elkAxiom));
                continue;
            }
            state.lock();
            results.put(elkAxiom, state);
        }
        return results;
    }

    private class QueryState
    extends AbstractProperEntailmentQueryResult {
        boolean isLoaded;
        IndexedEntailmentQuery<? extends Entailment> indexed;
        private int lockedCount_;
        Map<Occurrence, Integer> occurrences;

        public QueryState(ElkAxiom query) {
            super(query);
            this.isLoaded = false;
            this.indexed = null;
            this.lockedCount_ = 0;
            this.occurrences = null;
        }

        @Override
        public Entailment getEntailment() throws ElkQueryException {
            if (this.indexed == null) {
                throw new ElkQueryException("Query was not indexed: " + this.getQuery());
            }
            return this.indexed.getQuery();
        }

        @Override
        public boolean isEntailed() throws ElkQueryException {
            if (this.indexed == null) {
                throw new ElkQueryException("Query was not indexed: " + this.getQuery());
            }
            boolean result = Proofs.isDerivable(this.getEvidence(true), (Object)this.indexed.getQuery());
            if (!result) {
                EntailmentQueryState.this.incompleteness_.log(EntailmentQueryState.this.incompleteness_.getIncompletenessMonitorForEntailmentQuery(EntailmentQueryState.this.getOccurrenceStore(this)));
            }
            return result;
        }

        @Override
        public Proof<EntailmentInference> getEvidence(boolean onlyOne) throws ElkQueryException {
            if (this.indexed == null) {
                throw new ElkQueryException("Query was not indexed: " + this.getQuery());
            }
            EntailmentQueryState.this.incompleteness_.log(EntailmentQueryState.this.incompleteness_.getIncompletenessMonitorForEntailmentQuery(EntailmentQueryState.this.getOccurrenceStore(this)));
            InconsistencyProofWrapper inconsistencyEvidence = new InconsistencyProofWrapper(EntailmentQueryState.this.consistencyCheckingState_.getEvidence(onlyOne));
            if (EntailmentQueryState.this.consistencyCheckingState_.isInconsistent() && onlyOne) {
                return inconsistencyEvidence;
            }
            Proof<EntailmentInference> entailmentEvidence = this.indexed.getEvidence(onlyOne, EntailmentQueryState.this.saturationState_, EntailmentQueryState.this.conclusionFactory_);
            return Proofs.union((Proof[])new Proof[]{inconsistencyEvidence, entailmentEvidence});
        }

        public synchronized boolean lock() {
            boolean wasLocked = this.isLocked();
            ++this.lockedCount_;
            return wasLocked != this.isLocked();
        }

        public synchronized boolean isLocked() {
            return this.lockedCount_ > 0;
        }

        public synchronized boolean unlock() {
            if (!this.isLocked()) {
                return false;
            }
            --this.lockedCount_;
            return !this.isLocked();
        }
    }

    private class QueryIndexingListener
    implements IndexingListener {
        private boolean isInsertion_;
        private QueryState beingIndexed_ = null;

        private QueryIndexingListener() {
        }

        private void checkStateOnIndexing() throws IllegalStateException {
            if (this.beingIndexed_ == null) {
                throw new IllegalStateException("Indexing listener notified while no query is being loaded!");
            }
        }

        @Override
        public void onIndexing(Occurrence occurrence) {
            this.checkStateOnIndexing();
            if (this.isInsertion_) {
                Integer noOccurrences;
                if (this.beingIndexed_.occurrences == null) {
                    this.beingIndexed_.occurrences = new ArrayHashMap(4);
                }
                if ((noOccurrences = this.beingIndexed_.occurrences.get((Object)occurrence)) == null) {
                    noOccurrences = 0;
                }
                Integer n = noOccurrences;
                noOccurrences = noOccurrences + 1;
                this.beingIndexed_.occurrences.put(occurrence, noOccurrences);
            } else {
                if (this.beingIndexed_.occurrences == null) {
                    return;
                }
                Integer noOccurrences = this.beingIndexed_.occurrences.get((Object)occurrence);
                if (noOccurrences == null) {
                    return;
                }
                Integer n = noOccurrences;
                noOccurrences = noOccurrences - 1;
                if (noOccurrences <= 0) {
                    this.beingIndexed_.occurrences.remove((Object)occurrence);
                    if (this.beingIndexed_.occurrences.isEmpty()) {
                        this.beingIndexed_.occurrences = null;
                    }
                } else {
                    this.beingIndexed_.occurrences.put(occurrence, noOccurrences);
                }
            }
        }

        private class Loader
        extends AbstractEntailmentQueryLoader {
            public Loader(InterruptMonitor interrupter) {
                super(interrupter);
            }

            @Override
            public void load(ElkAxiomVisitor<IndexedEntailmentQuery<? extends Entailment>> inserter, ElkAxiomVisitor<IndexedEntailmentQuery<? extends Entailment>> deleter) throws ElkLoadingException {
                ElkAxiom axiom;
                QueryIndexingListener.this.isInsertion_ = false;
                Iterator evicted = EntailmentQueryState.this.queriedEvictor_.evict(EntailmentQueryState.this.doNotEvict_);
                while (evicted.hasNext()) {
                    QueryState state = (QueryState)evicted.next();
                    EntailmentQueryState.this.queried_.remove(state.getQuery());
                    if (!state.isLoaded) continue;
                    QueryIndexingListener.this.beingIndexed_ = state;
                    state.getQuery().accept(deleter);
                    state.indexed = null;
                    state.isLoaded = false;
                }
                QueryIndexingListener.this.isInsertion_ = true;
                while ((axiom = (ElkAxiom)EntailmentQueryState.this.toLoad_.poll()) != null) {
                    QueryState state = (QueryState)EntailmentQueryState.this.queried_.get(axiom);
                    if (state == null) continue;
                    state.isLoaded = true;
                    QueryIndexingListener.this.beingIndexed_ = state;
                    state.indexed = (IndexedEntailmentQuery)axiom.accept(inserter);
                    if (!this.isInterrupted()) continue;
                    return;
                }
            }

            @Override
            public boolean isLoadingFinished() {
                return EntailmentQueryState.this.toLoad_.isEmpty();
            }
        }
    }
}

