/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationProperty;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkDataProperty;
import org.semanticweb.elk.owl.interfaces.ElkDatatype;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.owl.visitors.ElkEntityVisitor;
import org.semanticweb.elk.reasoner.incremental.IncrementalChangesInitialization;
import org.semanticweb.elk.reasoner.incremental.IncrementalStages;
import org.semanticweb.elk.reasoner.indexing.classes.DifferentialIndex;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverterImpl;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.ContextCreatingSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationUtils;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.inferences.ContextInitializationNoPremises;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.ChainableContextInitRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ChainableSubsumerRule;
import org.semanticweb.elk.reasoner.stages.AbstractIncrementalChangesInitializationStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;

public class IncrementalAdditionInitializationStage
extends AbstractIncrementalChangesInitializationStage {
    public IncrementalAdditionInitializationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    protected IncrementalStages stage() {
        return IncrementalStages.ADDITIONS_INIT;
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        DifferentialIndex diffIndex = this.reasoner.ontologyIndex;
        ChainableContextInitRule changedInitRules = null;
        Map<? extends IndexedClassExpression, ChainableSubsumerRule> changedRulesByCE = null;
        Map<? extends IndexedClass, ? extends IndexedClassExpression> changedDefinitions = null;
        Map<? extends IndexedClass, ? extends ElkAxiom> changedDefinitionReasons = null;
        Collection<ArrayList<Context>> inputs = Collections.emptyList();
        ContextCreationListener contextCreationListener = SaturationUtils.addStatsToContextCreationListener(ContextCreationListener.DUMMY, this.stageStatistics.getContextStatistics());
        ContextModificationListener contextModificationListener = SaturationUtils.addStatsToContextModificationListener(ContextModificationListener.DUMMY, this.stageStatistics.getContextStatistics());
        final ElkPolarityExpressionConverterImpl converter = new ElkPolarityExpressionConverterImpl((PredefinedElkClassFactory)this.reasoner.getElkFactory(), this.reasoner.ontologyIndex);
        ContextCreatingSaturationStateWriter<? extends Context> writer = this.reasoner.saturationState.getContextCreatingWriter(contextCreationListener, contextModificationListener);
        for (ElkEntity newEntity : Operations.concat((Iterable[])new Iterable[]{this.reasoner.ontologyIndex.getAddedClasses(), this.reasoner.ontologyIndex.getAddedIndividuals()})) {
            IndexedClassExpression ice = (IndexedClassExpression)newEntity.accept((ElkEntityVisitor)new ElkEntityVisitor<IndexedClassExpression>(){

                public IndexedClassExpression visit(ElkAnnotationProperty elkAnnotationProperty) {
                    return null;
                }

                public IndexedClassExpression visit(ElkClass elkClass) {
                    return (IndexedClassExpression)converter.visit(elkClass);
                }

                public IndexedClassExpression visit(ElkDataProperty elkDataProperty) {
                    return null;
                }

                public IndexedClassExpression visit(ElkDatatype elkDatatype) {
                    return null;
                }

                public IndexedClassExpression visit(ElkNamedIndividual elkNamedIndividual) {
                    return (IndexedClassExpression)converter.visit(elkNamedIndividual);
                }

                public IndexedClassExpression visit(ElkObjectProperty elkObjectProperty) {
                    return null;
                }
            });
            if (this.reasoner.saturationState.getContext(ice) != null) continue;
            writer.produce(new ContextInitializationNoPremises(ice));
        }
        changedInitRules = diffIndex.getAddedContextInitRules();
        changedRulesByCE = diffIndex.getAddedContextRulesByClassExpressions();
        changedDefinitions = diffIndex.getAddedDefinitions();
        changedDefinitionReasons = diffIndex.getAddedDefinitionReasons();
        if (changedInitRules != null || !changedRulesByCE.isEmpty() || !changedDefinitions.isEmpty()) {
            inputs = Operations.split(this.reasoner.saturationState.getContexts(), (int)(8 * this.workerNo));
        }
        this.initialization = new IncrementalChangesInitialization(inputs, (InterruptMonitor)this.reasoner.getInterrupter(), changedInitRules, changedRulesByCE, changedDefinitions, changedDefinitionReasons, this.reasoner.saturationState, this.reasoner.getProcessExecutor(), this.stageStatistics, this.workerNo, this.reasoner.getProgressMonitor());
        return true;
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.reasoner.ontologyIndex.commitAddedRules();
        this.reasoner.ontologyIndex.initClassChanges();
        this.reasoner.ontologyIndex.initIndividualChanges();
        return true;
    }
}

