/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.incremental.IncrementalChangesInitialization;
import org.semanticweb.elk.reasoner.incremental.IncrementalStages;
import org.semanticweb.elk.reasoner.indexing.classes.DifferentialIndex;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.ContextCreatingSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.inferences.ContextInitializationNoPremises;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.ChainableContextInitRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ChainableSubsumerRule;
import org.semanticweb.elk.reasoner.stages.AbstractIncrementalChangesInitializationStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;

public class IncrementalDeletionInitializationStage
extends AbstractIncrementalChangesInitializationStage {
    public IncrementalDeletionInitializationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    protected IncrementalStages stage() {
        return IncrementalStages.DELETIONS_INIT;
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        DifferentialIndex diffIndex = this.reasoner.ontologyIndex;
        ChainableContextInitRule changedInitRules = null;
        Map<? extends IndexedClassExpression, ChainableSubsumerRule> changedRulesByCE = null;
        Map<? extends IndexedClass, ? extends IndexedClassExpression> changedDefinitions = null;
        Map<? extends IndexedClass, ? extends ElkAxiom> changedDefinitionReasons = null;
        Collection<ArrayList<Context>> inputs = Collections.emptyList();
        changedInitRules = diffIndex.getRemovedContextInitRules();
        changedRulesByCE = diffIndex.getRemovedContextRulesByClassExpressions();
        changedDefinitions = diffIndex.getRemovedDefinitions();
        changedDefinitionReasons = diffIndex.getRemovedDefinitionReasons();
        if (changedInitRules != null || !changedRulesByCE.isEmpty() || !changedDefinitions.isEmpty()) {
            inputs = Operations.split(this.reasoner.saturationState.getContexts(), (int)(8 * this.workerNo));
        }
        this.initialization = new IncrementalChangesInitialization(inputs, (InterruptMonitor)this.reasoner.getInterrupter(), changedInitRules, changedRulesByCE, changedDefinitions, changedDefinitionReasons, this.reasoner.saturationState, this.reasoner.getProcessExecutor(), this.stageStatistics, this.workerNo, this.reasoner.getProgressMonitor());
        return true;
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.initialization = null;
        ContextCreatingSaturationStateWriter<? extends Context> satStateWriter = this.reasoner.saturationState.getContextCreatingWriter();
        for (IndexedClassExpression indexedClassExpression : this.reasoner.ontologyIndex.getRemovedClassExpressions()) {
            if (this.reasoner.saturationState.getContext(indexedClassExpression) == null) continue;
            satStateWriter.produce(new ContextInitializationNoPremises(indexedClassExpression));
        }
        this.reasoner.ontologyIndex.clearDeletedRules();
        return true;
    }
}

