/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collection;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.reasoner.incremental.IncrementalStages;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedIndividual;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyCleaning;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalTaxonomyCleaningStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(IncrementalTaxonomyCleaningStage.class);
    private TaxonomyCleaning cleaning_ = null;

    public IncrementalTaxonomyCleaningStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return IncrementalStages.TAXONOMY_CLEANING.toString();
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        Collection<IndexedClass> classesToRemove = this.reasoner.classTaxonomyState.getToRemove();
        Collection<IndexedIndividual> individualsToRemove = this.reasoner.instanceTaxonomyState.getToRemove();
        Collection inputs = Operations.getCollection((Iterable)Operations.concat((Iterable[])new Iterable[]{classesToRemove, individualsToRemove}), (int)(classesToRemove.size() + individualsToRemove.size()));
        LOGGER_.trace("{}: classes to remove", classesToRemove);
        LOGGER_.trace("{}: individuals to remove", individualsToRemove);
        this.cleaning_ = new TaxonomyCleaning(inputs, (InterruptMonitor)this.reasoner.getInterrupter(), this.reasoner.classTaxonomyState.getTaxonomy(), this.reasoner.instanceTaxonomyState.getTaxonomy(), this.reasoner.getProcessExecutor(), this.workerNo, this.reasoner.getProgressMonitor());
        return true;
    }

    @Override
    public void executeStage() throws ElkException {
        this.cleaning_.process();
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        Collection<IndexedClass> classesToRemove = this.reasoner.classTaxonomyState.getToRemove();
        if (!classesToRemove.isEmpty()) {
            throw new ElkRuntimeException(TaxonomyCleaning.class.getSimpleName() + " did not remove some classes from the taxonomy!");
        }
        Collection<IndexedIndividual> individualsToRemove = this.reasoner.instanceTaxonomyState.getToRemove();
        if (!individualsToRemove.isEmpty()) {
            throw new ElkRuntimeException(TaxonomyCleaning.class.getSimpleName() + " did not remove some individuals from the taxonomy!");
        }
        this.cleaning_ = null;
        return true;
    }

    @Override
    public void printInfo() {
    }
}

