/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ClassQueryLoader;
import org.semanticweb.elk.loading.EntailmentQueryLoader;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.owl.visitors.DecoratingElkAxiomProcessor;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.owl.visitors.ElkAxiomVisitor;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionProcessor;
import org.semanticweb.elk.reasoner.entailments.model.Entailment;
import org.semanticweb.elk.reasoner.incremental.AxiomLoadingListener;
import org.semanticweb.elk.reasoner.indexing.classes.ChangeIndexingProcessor;
import org.semanticweb.elk.reasoner.indexing.classes.ClassQueryIndexingProcessor;
import org.semanticweb.elk.reasoner.indexing.classes.NonIncrementalElkAxiomVisitor;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkAxiomConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkAxiomConverterImpl;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverterImpl;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.query.EntailmentQueryIndexingProcessor;
import org.semanticweb.elk.reasoner.query.IndexedEntailmentQuery;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputLoadingStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(InputLoadingStage.class);
    private volatile AxiomLoader loader_;
    private volatile ClassQueryLoader classQueryLoader_;
    private volatile EntailmentQueryLoader entailmentQueryLoader_;
    private boolean firstLoad_ = true;
    private ElkAxiomProcessor axiomInsertionProcessor_;
    private ElkAxiomProcessor axiomDeletionProcessor_;
    private ElkClassExpressionProcessor classQueryInsertionProcessor_;
    private ElkClassExpressionProcessor classQueryDeletionProcessor_;
    private ElkAxiomVisitor<IndexedEntailmentQuery<? extends Entailment>> entailmentQueryInserter_;
    private ElkAxiomVisitor<IndexedEntailmentQuery<? extends Entailment>> entailmentQueryDeleter_;
    private ModifiableOntologyIndex ontologyIndex_;

    public InputLoadingStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Input Loading";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        if (!this.firstLoad_ && !this.reasoner.saturationState.getContexts().isEmpty()) {
            this.reasoner.trySetIncrementalMode();
        }
        this.loader_ = this.reasoner.getAxiomLoader();
        this.classQueryLoader_ = this.reasoner.getClassQueryLoader();
        this.entailmentQueryLoader_ = this.reasoner.getEntailmentQueryLoader();
        this.ontologyIndex_ = this.reasoner.getModifiableOntologyIndex();
        ElkObject.Factory elkFactory = this.reasoner.getElkFactory();
        if (this.loader_ != null && !this.loader_.isLoadingFinished()) {
            ElkAxiomConverter axiomInserter = new ElkAxiomConverterImpl((PredefinedElkClassFactory)elkFactory, this.ontologyIndex_, 1);
            ElkAxiomConverter axiomDeleter = new ElkAxiomConverterImpl((PredefinedElkClassFactory)elkFactory, this.ontologyIndex_, -1);
            AxiomLoadingListener<ElkAxiom> listener = new AxiomLoadingListener<ElkAxiom>(){
                boolean resetDone = false;

                @Override
                public void notify(ElkAxiom axiom) {
                    if (this.resetDone) {
                        return;
                    }
                    LOGGER_.debug("{}: axiom not supported in incremental mode", (Object)axiom);
                    InputLoadingStage.this.reasoner.stageManager.propertyInitializationStage.invalidateRecursive();
                    InputLoadingStage.this.reasoner.setNonIncrementalMode();
                    this.resetDone = true;
                }
            };
            axiomInserter = new NonIncrementalElkAxiomVisitor(axiomInserter, listener);
            axiomDeleter = new NonIncrementalElkAxiomVisitor(axiomDeleter, listener);
            this.axiomInsertionProcessor_ = new DecoratingElkAxiomProcessor(this.reasoner.occurrencesInStatedAxiomsStore.getPreInsertionVisitor(), (ElkAxiomProcessor)new ChangeIndexingProcessor(axiomInserter, "addition", this.ontologyIndex_), this.reasoner.occurrencesInStatedAxiomsStore.getPostInsertionVisitor());
            this.axiomDeletionProcessor_ = new DecoratingElkAxiomProcessor(this.reasoner.occurrencesInStatedAxiomsStore.getPreDeletionVisitor(), (ElkAxiomProcessor)new ChangeIndexingProcessor(axiomDeleter, "removal", this.ontologyIndex_), this.reasoner.occurrencesInStatedAxiomsStore.getPostDeletionVisitor());
        }
        if (this.classQueryLoader_ != null && !this.classQueryLoader_.isLoadingFinished()) {
            this.classQueryInsertionProcessor_ = new ClassQueryIndexingProcessor(new ElkPolarityExpressionConverterImpl((PredefinedElkClassFactory)elkFactory, this.ontologyIndex_, 1), "addition", this.ontologyIndex_);
            this.classQueryDeletionProcessor_ = new ClassQueryIndexingProcessor(new ElkPolarityExpressionConverterImpl((PredefinedElkClassFactory)elkFactory, this.ontologyIndex_, -1), "removal", this.ontologyIndex_);
        }
        if (this.entailmentQueryLoader_ != null && !this.entailmentQueryLoader_.isLoadingFinished()) {
            this.entailmentQueryInserter_ = new EntailmentQueryIndexingProcessor(elkFactory, this.ontologyIndex_, "addition", this.ontologyIndex_);
            this.entailmentQueryDeleter_ = new EntailmentQueryIndexingProcessor(elkFactory, this.ontologyIndex_, "removal", this.ontologyIndex_);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeStage() throws ElkException {
        boolean registered;
        if (this.loader_ != null && !this.loader_.isLoadingFinished()) {
            registered = this.ontologyIndex_.addOccurrenceIndexingListener(this.reasoner.occurrencesInStatedAxiomsStore);
            try {
                this.loader_.load(this.axiomInsertionProcessor_, this.axiomDeletionProcessor_);
            }
            finally {
                if (registered) {
                    this.ontologyIndex_.removeOccurrenceIndexingListener(this.reasoner.occurrencesInStatedAxiomsStore);
                }
            }
        }
        if (this.classQueryLoader_ != null && !this.classQueryLoader_.isLoadingFinished()) {
            registered = this.ontologyIndex_.addOccurrenceIndexingListener(this.reasoner.classExpressionQueryState_.getIndexingListener());
            try {
                this.classQueryLoader_.load(this.classQueryInsertionProcessor_, this.classQueryDeletionProcessor_);
            }
            finally {
                if (registered) {
                    this.ontologyIndex_.removeOccurrenceIndexingListener(this.reasoner.classExpressionQueryState_.getIndexingListener());
                }
            }
        }
        if (this.entailmentQueryLoader_ != null && !this.entailmentQueryLoader_.isLoadingFinished()) {
            registered = this.ontologyIndex_.addOccurrenceIndexingListener(this.reasoner.entailmentQueryState_.getIndexingListener());
            try {
                this.entailmentQueryLoader_.load(this.entailmentQueryInserter_, this.entailmentQueryDeleter_);
            }
            finally {
                if (registered) {
                    this.ontologyIndex_.removeOccurrenceIndexingListener(this.reasoner.entailmentQueryState_.getIndexingListener());
                }
            }
        }
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        if (this.loader_ != null && !this.loader_.isLoadingFinished()) {
            throw new ElkRuntimeException("Axiom loading not finished!");
        }
        if (this.classQueryLoader_ != null && !this.classQueryLoader_.isLoadingFinished()) {
            throw new ElkRuntimeException("Class query loading not finished!");
        }
        if (this.entailmentQueryLoader_ != null && !this.entailmentQueryLoader_.isLoadingFinished()) {
            throw new ElkRuntimeException("Entailment query loading not finished!");
        }
        this.firstLoad_ = false;
        this.loader_ = null;
        this.classQueryLoader_ = null;
        this.entailmentQueryLoader_ = null;
        this.ontologyIndex_ = null;
        this.axiomInsertionProcessor_ = null;
        this.axiomDeletionProcessor_ = null;
        this.classQueryInsertionProcessor_ = null;
        this.classQueryDeletionProcessor_ = null;
        this.entailmentQueryInserter_ = null;
        this.entailmentQueryDeleter_ = null;
        return true;
    }

    @Override
    public void printInfo() {
    }
}

