/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.owl.visitors.ElkIndividualVisitor;
import org.semanticweb.elk.reasoner.indexing.classes.DifferentialIndex;
import org.semanticweb.elk.reasoner.indexing.classes.OntologyIndexDummyChangeListener;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverterImpl;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.OntologyIndex;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStateDummyChangeListener;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.stages.ClassTaxonomyState;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.DummyInstanceTaxonomyListener;
import org.semanticweb.elk.reasoner.taxonomy.DummyNodeStoreListener;
import org.semanticweb.elk.reasoner.taxonomy.ElkIndividualKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeStore;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomy;
import org.semanticweb.elk.util.collections.Operations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceTaxonomyState {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(InstanceTaxonomyState.class);
    private UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy_ = null;
    private final Queue<IndexedIndividual> toAdd_ = new ConcurrentLinkedQueue<IndexedIndividual>();
    private final Queue<IndexedIndividual> toRemove_ = new ConcurrentLinkedQueue<IndexedIndividual>();
    private final OntologyIndex ontologyIndex_;
    private final SaturationState<?> saturationState_;
    private final ElkPolarityExpressionConverter converter_;
    private final NodeStore.Listener<ElkNamedIndividual> nodeStoreListener_ = new DummyNodeStoreListener<ElkNamedIndividual>(){

        @Override
        public void memberForNodeDisappeared(ElkNamedIndividual member, Node<ElkNamedIndividual> node) {
            InstanceTaxonomyState.this.addToAdd(member);
        }
    };
    private final InstanceTaxonomy.Listener<ElkClass, ElkNamedIndividual> taxonomyListener_ = new DummyInstanceTaxonomyListener<ElkClass, ElkNamedIndividual>(){

        @Override
        public void directTypeNodesDisappeared(InstanceNode<ElkClass, ElkNamedIndividual> instanceNode) {
            for (ElkNamedIndividual elkIndividual : instanceNode) {
                InstanceTaxonomyState.this.addToAdd(elkIndividual);
            }
        }
    };
    private final ClassTaxonomyState.Listener CLASS_TAXONOMY_STATE_LISTENER = new ClassTaxonomyState.Listener(){

        @Override
        public void taxonomyReset(UpdateableTaxonomy<ElkClass> oldTaxonomy, UpdateableTaxonomy<ElkClass> newTaxonomy) {
            InstanceTaxonomyState.this.resetTaxonomy(newTaxonomy);
        }
    };

    public <C extends Context> InstanceTaxonomyState(SaturationState<C> saturationState, DifferentialIndex ontologyIndex, ElkObject.Factory elkFactory) {
        this.ontologyIndex_ = ontologyIndex;
        this.saturationState_ = saturationState;
        this.converter_ = new ElkPolarityExpressionConverterImpl((PredefinedElkClassFactory)elkFactory, ontologyIndex);
        ontologyIndex.addListener(new OntologyIndexDummyChangeListener(){

            @Override
            public void individualAddition(IndexedIndividual ind) {
                InstanceTaxonomyState.this.toAdd_.add(ind);
            }

            @Override
            public void individualRemoval(IndexedIndividual ind) {
                InstanceTaxonomyState.this.toRemove_.add(ind);
            }
        });
        saturationState.addListener(new SaturationStateDummyChangeListener<C>(){

            @Override
            public void contextMarkNonSaturated(C context) {
                IndexedContextRoot root = context.getRoot();
                if (root instanceof IndexedIndividual) {
                    IndexedIndividual ind = (IndexedIndividual)root;
                    InstanceTaxonomyState.this.toRemove_.add(ind);
                }
            }
        });
    }

    public UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> getTaxonomy() {
        return this.taxonomy_;
    }

    private void addToAdd(ElkNamedIndividual elkIndividual) {
        ModifiableIndexedClassExpression converted = (ModifiableIndexedClassExpression)elkIndividual.accept((ElkIndividualVisitor)this.converter_);
        if (converted != null && converted instanceof IndexedIndividual) {
            IndexedIndividual ind = (IndexedIndividual)((Object)converted);
            this.toAdd_.add(ind);
        }
    }

    private int pruneToAdd() {
        Iterator iter = this.toAdd_.iterator();
        int size = 0;
        while (iter.hasNext()) {
            IndexedIndividual ind = (IndexedIndividual)iter.next();
            if (!ind.occurs()) {
                iter.remove();
                continue;
            }
            Object context = this.saturationState_.getContext(ind);
            if (context == null || !context.isInitialized() || !context.isSaturated()) {
                ++size;
                continue;
            }
            InstanceNode node = this.taxonomy_.getInstanceNode(ind.getElkEntity());
            if (node == null) {
                ++size;
                continue;
            }
            if (!node.getDirectTypeNodes().isEmpty()) {
                iter.remove();
                continue;
            }
            ++size;
        }
        return size;
    }

    Collection<IndexedIndividual> getToAdd() {
        if (this.taxonomy_ == null) {
            return this.toAdd_;
        }
        int size = this.pruneToAdd();
        return Operations.getCollection(this.toAdd_, (int)size);
    }

    private int pruneToRemove() {
        Iterator iter = this.toRemove_.iterator();
        int size = 0;
        while (iter.hasNext()) {
            IndexedIndividual cls = (IndexedIndividual)iter.next();
            InstanceNode node = this.taxonomy_.getInstanceNode(cls.getElkEntity());
            if (node == null) {
                iter.remove();
                continue;
            }
            ++size;
        }
        return size;
    }

    Collection<IndexedIndividual> getToRemove() {
        if (this.taxonomy_ == null) {
            this.toRemove_.clear();
            return Collections.emptyList();
        }
        int size = this.pruneToRemove();
        return Operations.getCollection(this.toRemove_, (int)size);
    }

    private void resetTaxonomy(UpdateableTaxonomy<ElkClass> classTaxonomy) {
        LOGGER_.trace("Reset instance taxonomy");
        if (this.taxonomy_ != null) {
            this.taxonomy_.removeInstanceListener(this.nodeStoreListener_);
            this.taxonomy_.removeInstanceListener(this.taxonomyListener_);
        }
        this.taxonomy_ = new ConcurrentInstanceTaxonomy(classTaxonomy, ElkIndividualKeyProvider.INSTANCE);
        this.taxonomy_.addInstanceListener(this.nodeStoreListener_);
        this.taxonomy_.addInstanceListener(this.taxonomyListener_);
        this.toRemove_.clear();
        this.toAdd_.clear();
        this.toAdd_.addAll(this.ontologyIndex_.getIndividuals());
    }

    void taxonomyComplete() {
        this.toRemove_.clear();
        this.toAdd_.clear();
    }

    public ClassTaxonomyState.Listener getClassTaxonomyStateListener() {
        return this.CLASS_TAXONOMY_STATE_LISTENER;
    }
}

