/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.visitors.DummyElkObjectVisitor;
import org.semanticweb.elk.owl.visitors.ElkObjectVisitor;
import org.semanticweb.elk.reasoner.indexing.model.IndexingListener;
import org.semanticweb.elk.reasoner.indexing.model.Occurrence;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceStore;

class OccurrencesInStatedAxiomsStore
implements OccurrenceStore,
IndexingListener {
    public static final int AT_MOST_N_OCCURRENCES_IN_MESSAGE = 3;
    private final Map<Occurrence, Map<ElkObject, Integer>> occurrences_;
    private boolean isInsertion_;
    private ElkObject elkObjectBeingIndexed_ = null;
    private final ElkObjectVisitor<Void> preInsertionVisitor_ = new DummyElkObjectVisitor<Void>(){

        protected Void defaultVisit(ElkObject elkObject) {
            OccurrencesInStatedAxiomsStore.this.isInsertion_ = true;
            OccurrencesInStatedAxiomsStore.this.elkObjectBeingIndexed_ = elkObject;
            return null;
        }
    };
    private final ElkObjectVisitor<Void> postInsertionVisitor_ = new DummyElkObjectVisitor<Void>(){

        protected Void defaultVisit(ElkObject elkObject) {
            OccurrencesInStatedAxiomsStore.this.elkObjectBeingIndexed_ = null;
            return null;
        }
    };
    private final ElkObjectVisitor<Void> preDeletionVisitor_ = new DummyElkObjectVisitor<Void>(){

        protected Void defaultVisit(ElkObject elkObject) {
            OccurrencesInStatedAxiomsStore.this.isInsertion_ = false;
            OccurrencesInStatedAxiomsStore.this.elkObjectBeingIndexed_ = elkObject;
            return null;
        }
    };
    private final ElkObjectVisitor<Void> postDeletionVisitor_ = new DummyElkObjectVisitor<Void>(){

        protected Void defaultVisit(ElkObject elkObject) {
            OccurrencesInStatedAxiomsStore.this.elkObjectBeingIndexed_ = null;
            return null;
        }
    };

    public OccurrencesInStatedAxiomsStore() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Occurrence occurrence : Occurrence.values()) {
            builder.put((Object)occurrence, new HashMap());
        }
        this.occurrences_ = builder.build();
    }

    @Override
    public Collection<? extends ElkObject> occursIn(Occurrence occurrence) {
        return this.occurrences_.get((Object)occurrence).keySet();
    }

    @Override
    public void onIndexing(Occurrence occurrence) {
        this.checkStateOnIndexing();
        Map<ElkObject, Integer> occurrences = this.occurrences_.get((Object)occurrence);
        if (this.isInsertion_) {
            Integer noOccurrences = occurrences.get(this.elkObjectBeingIndexed_);
            if (noOccurrences == null) {
                noOccurrences = 0;
            }
            Integer n = noOccurrences;
            noOccurrences = noOccurrences + 1;
            occurrences.put(this.elkObjectBeingIndexed_, noOccurrences);
        } else {
            Integer noOccurrences = occurrences.get(this.elkObjectBeingIndexed_);
            if (noOccurrences == null) {
                return;
            }
            Integer n = noOccurrences;
            noOccurrences = noOccurrences - 1;
            if (noOccurrences <= 0) {
                occurrences.remove(this.elkObjectBeingIndexed_);
            } else {
                occurrences.put(this.elkObjectBeingIndexed_, noOccurrences);
            }
        }
    }

    private void checkStateOnIndexing() throws IllegalStateException {
        if (this.elkObjectBeingIndexed_ == null) {
            throw new IllegalStateException("Indexing listener notified while no axiom is being loaded!");
        }
    }

    ElkObjectVisitor<Void> getPreInsertionVisitor() {
        return this.preInsertionVisitor_;
    }

    ElkObjectVisitor<Void> getPostInsertionVisitor() {
        return this.postInsertionVisitor_;
    }

    ElkObjectVisitor<Void> getPreDeletionVisitor() {
        return this.preDeletionVisitor_;
    }

    ElkObjectVisitor<Void> getPostDeletionVisitor() {
        return this.postDeletionVisitor_;
    }
}

