/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;

public class PropertyHierarchyCompositionState {
    private final List<Listener> listeners_;
    private final Dispatcher dispatcher_ = new Dispatcher(){

        @Override
        public void firePropertyBecameSaturated(IndexedPropertyChain chain) {
            for (Listener listener : PropertyHierarchyCompositionState.this.listeners_) {
                listener.propertyBecameSaturated(chain);
            }
        }

        @Override
        public void firePropertyBecameNotSaturated(IndexedPropertyChain chain) {
            for (Listener listener : PropertyHierarchyCompositionState.this.listeners_) {
                listener.propertyBecameNotSaturated(chain);
            }
        }
    };

    public PropertyHierarchyCompositionState() {
        this.listeners_ = new ArrayList<Listener>();
    }

    public boolean addListener(Listener listener) {
        return this.listeners_.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners_.remove(listener);
    }

    Dispatcher getDispatcher() {
        return this.dispatcher_;
    }

    public static interface Dispatcher {
        public static final Dispatcher DUMMY = new Dispatcher(){

            @Override
            public void firePropertyBecameSaturated(IndexedPropertyChain chain) {
            }

            @Override
            public void firePropertyBecameNotSaturated(IndexedPropertyChain chain) {
            }
        };

        public void firePropertyBecameSaturated(IndexedPropertyChain var1);

        public void firePropertyBecameNotSaturated(IndexedPropertyChain var1);
    }

    public static interface Listener {
        public void propertyBecameSaturated(IndexedPropertyChain var1);

        public void propertyBecameNotSaturated(IndexedPropertyChain var1);
    }
}

