/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Iterator;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.PropertyHierarchyCompositionState;

class PropertyInitializationStage
extends AbstractReasonerStage {
    private final PropertyHierarchyCompositionState.Dispatcher dispatcher_;
    private int progress_;
    private int maxProgress_;
    private Iterator<? extends IndexedPropertyChain> todo_ = null;

    public PropertyInitializationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
        this.dispatcher_ = reasoner.propertyHierarchyCompositionState_.getDispatcher();
    }

    @Override
    public String getName() {
        return "Property Saturation Initialization";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        this.todo_ = this.reasoner.ontologyIndex.getPropertyChains().iterator();
        this.maxProgress_ = this.reasoner.ontologyIndex.getPropertyChains().size();
        this.progress_ = 0;
        return true;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        while (this.todo_.hasNext()) {
            IndexedPropertyChain ipc = this.todo_.next();
            SaturatedPropertyChain saturation = ipc.getSaturated();
            saturation.clear();
            this.dispatcher_.firePropertyBecameNotSaturated(ipc);
            this.reasoner.getProgressMonitor().report(++this.progress_, this.maxProgress_);
        }
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.todo_ = null;
        return true;
    }

    @Override
    public void printInfo() {
    }
}

