/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collection;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionFactory;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionJob;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionListener;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutput;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalent;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalentDirect;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputUnsatisfiable;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputVisitor;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentClassTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.ElkClassKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.NonBottomTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomy;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassTaxonomyComputationFactory
implements InputProcessorFactory<Collection<IndexedClass>, Engine> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ClassTaxonomyComputationFactory.class);
    private final UpdateableTaxonomy<ElkClass> taxonomy_;
    private final TransitiveReductionFactory<IndexedClass, TransitiveReductionJob<IndexedClass>> transitiveReductionShared_;
    private final TransitiveReductionOutputProcessor outputProcessor_;

    public ClassTaxonomyComputationFactory(InterruptMonitor interrupter, SaturationState<?> saturationState, int maxWorkers, UpdateableTaxonomy<ElkClass> partialTaxonomy) {
        this.taxonomy_ = partialTaxonomy;
        this.transitiveReductionShared_ = new TransitiveReductionFactory(interrupter, saturationState, maxWorkers, new ThisTransitiveReductionListener());
        this.outputProcessor_ = new TransitiveReductionOutputProcessor();
    }

    public ClassTaxonomyComputationFactory(InterruptMonitor interrupter, PredefinedElkClassFactory elkFactory, SaturationState<?> saturationState, int maxWorkers) {
        this(interrupter, saturationState, maxWorkers, new ConcurrentClassTaxonomy(elkFactory, ElkClassKeyProvider.INSTANCE));
    }

    public UpdateableTaxonomy<ElkClass> getTaxonomy() {
        return this.taxonomy_;
    }

    public Engine getEngine() {
        return new Engine();
    }

    public void finish() {
        this.transitiveReductionShared_.finish();
    }

    public boolean isInterrupted() {
        return this.transitiveReductionShared_.isInterrupted();
    }

    public void printStatistics() {
        this.transitiveReductionShared_.printStatistics();
    }

    public SaturationStatistics getRuleAndConclusionStatistics() {
        return this.transitiveReductionShared_.getRuleAndConclusionStatistics();
    }

    private class TransitiveReductionOutputProcessor
    implements TransitiveReductionOutputVisitor<IndexedClass> {
        private TransitiveReductionOutputProcessor() {
        }

        @Override
        public void visit(TransitiveReductionOutputEquivalentDirect<IndexedClass> output) {
            NonBottomTaxonomyNode<ElkClass> node = ClassTaxonomyComputationFactory.this.taxonomy_.getCreateNode(output.getEquivalent());
            ClassTaxonomyComputationFactory.this.taxonomy_.setCreateDirectSupernodes(node, output.getDirectSubsumers());
        }

        @Override
        public void visit(TransitiveReductionOutputUnsatisfiable<IndexedClass> output) {
            ClassTaxonomyComputationFactory.this.taxonomy_.addToBottomNode(((IndexedClass)output.getRoot()).getElkEntity());
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace(output.getRoot() + ": added to the bottom node");
            }
        }

        @Override
        public void visit(TransitiveReductionOutputEquivalent<IndexedClass> output) {
            throw new IllegalArgumentException();
        }
    }

    private class ThisTransitiveReductionListener
    implements TransitiveReductionListener<TransitiveReductionJob<IndexedClass>> {
        private ThisTransitiveReductionListener() {
        }

        public void notifyFinished(TransitiveReductionJob<IndexedClass> job) throws InterruptedException {
            ((TransitiveReductionOutput)job.getOutput()).accept(ClassTaxonomyComputationFactory.this.outputProcessor_);
        }
    }

    public class Engine
    implements InputProcessor<Collection<IndexedClass>> {
        protected final TransitiveReductionFactory.Engine transitiveReductionEngine;

        private Engine() {
            this.transitiveReductionEngine = ClassTaxonomyComputationFactory.this.transitiveReductionShared_.getEngine();
        }

        public final void submit(Collection<IndexedClass> input) {
            for (IndexedClass ic : input) {
                LOGGER_.trace("{}: taxonomy construction started", (Object)ic);
                this.transitiveReductionEngine.submit(new TransitiveReductionJob<IndexedClass>(ic));
            }
        }

        public final void process() throws InterruptedException {
            this.transitiveReductionEngine.process();
        }

        public void finish() {
            this.transitiveReductionEngine.finish();
        }
    }
}

