/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentClassTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyNodeUtils;
import org.semanticweb.elk.reasoner.taxonomy.impl.AbstractInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.impl.ConcurrentNodeStore;
import org.semanticweb.elk.reasoner.taxonomy.impl.IndividualNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableNodeStore;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.ComparatorKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeFactory;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeStore;
import org.semanticweb.elk.reasoner.taxonomy.model.NonBottomTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.NonBottomTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomy;
import org.semanticweb.elk.util.collections.Operations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentInstanceTaxonomy
extends AbstractInstanceTaxonomy<ElkClass, ElkNamedIndividual>
implements UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ConcurrentInstanceTaxonomy.class);
    private final UpdateableNodeStore<ElkNamedIndividual, IndividualNode.Projection<ElkClass, ElkNamedIndividual>> individualNodeStore_;
    private final UpdateableTaxonomy<ElkClass> classTaxonomy_;
    private final ConcurrentMap<TaxonomyNode<ElkClass>, UpdateableTypeNodeWrapper> wrapperMap_;
    protected final List<InstanceTaxonomy.Listener<ElkClass, ElkNamedIndividual>> instanceListeners_;
    private final NodeFactory<ElkNamedIndividual, IndividualNode.Projection<ElkClass, ElkNamedIndividual>> INSTANCE_NODE_FACTORY = new NodeFactory<ElkNamedIndividual, IndividualNode.Projection<ElkClass, ElkNamedIndividual>>(){

        @Override
        public IndividualNode.Projection<ElkClass, ElkNamedIndividual> createNode(Iterable<? extends ElkNamedIndividual> members, int size) {
            return new IndividualNode.Projection<ElkClass, ElkNamedIndividual>(ConcurrentInstanceTaxonomy.this, members, size);
        }
    };
    private final Operations.FunctorEx<NonBottomTaxonomyNode<ElkClass>, UpdateableTypeNodeWrapper> nonBottomFunctor_ = new Operations.FunctorEx<NonBottomTaxonomyNode<ElkClass>, UpdateableTypeNodeWrapper>(){

        public UpdateableTypeNodeWrapper apply(NonBottomTaxonomyNode<ElkClass> node) {
            return ConcurrentInstanceTaxonomy.this.getCreateUpdateableTypeNode(node);
        }

        public NonBottomTaxonomyNode<ElkClass> deapply(Object element) {
            if (element instanceof UpdateableTypeNodeWrapper) {
                return ((UpdateableTypeNodeWrapper)element).getNode();
            }
            return null;
        }
    };
    private final Operations.FunctorEx<TaxonomyNode<ElkClass>, TypeNodeWrapper> functor_ = new Operations.FunctorEx<TaxonomyNode<ElkClass>, TypeNodeWrapper>(){

        public TypeNodeWrapper apply(TaxonomyNode<ElkClass> node) {
            if (node == null) {
                return null;
            }
            if (node instanceof NonBottomTaxonomyNode) {
                return (TypeNodeWrapper)ConcurrentInstanceTaxonomy.this.nonBottomFunctor_.apply((Object)((NonBottomTaxonomyNode)node));
            }
            return ConcurrentInstanceTaxonomy.this.bottomNodeWrapper_;
        }

        public TaxonomyNode<ElkClass> deapply(Object element) {
            if (element instanceof TypeNodeWrapper) {
                return ((TypeNodeWrapper)element).getNode();
            }
            return null;
        }
    };
    private final TypeNodeWrapper bottomNodeWrapper_ = new TypeNodeWrapper(){

        @Override
        public TaxonomyNode<ElkClass> getNode() {
            return ConcurrentInstanceTaxonomy.this.classTaxonomy_.getBottomNode();
        }

        @Override
        public Set<? extends GenericInstanceNode.Projection<ElkClass, ElkNamedIndividual>> getDirectInstanceNodes() {
            return Collections.emptySet();
        }

        @Override
        public Set<? extends GenericInstanceNode.Projection<ElkClass, ElkNamedIndividual>> getAllInstanceNodes() {
            return Collections.emptySet();
        }
    };

    public ConcurrentInstanceTaxonomy(PredefinedElkClassFactory elkFactory, ComparatorKeyProvider<ElkEntity> classKeyProvider, ComparatorKeyProvider<ElkEntity> individualKeyProvider) {
        this(new ConcurrentClassTaxonomy(elkFactory, classKeyProvider), individualKeyProvider);
    }

    public ConcurrentInstanceTaxonomy(UpdateableTaxonomy<ElkClass> classTaxonomy, ComparatorKeyProvider<ElkEntity> individualKeyProvider) {
        this.individualNodeStore_ = new ConcurrentNodeStore<ElkEntity, IndividualNode.Projection<ElkClass, ElkNamedIndividual>>(individualKeyProvider);
        this.classTaxonomy_ = classTaxonomy;
        this.wrapperMap_ = new ConcurrentHashMap<TaxonomyNode<ElkClass>, UpdateableTypeNodeWrapper>();
        this.instanceListeners_ = new ArrayList<InstanceTaxonomy.Listener<ElkClass, ElkNamedIndividual>>();
    }

    @Override
    public ComparatorKeyProvider<? super ElkClass> getKeyProvider() {
        return this.classTaxonomy_.getKeyProvider();
    }

    @Override
    public ComparatorKeyProvider<? super ElkNamedIndividual> getInstanceKeyProvider() {
        return this.individualNodeStore_.getKeyProvider();
    }

    @Override
    public TypeNode<ElkClass, ElkNamedIndividual> getNode(ElkClass elkClass) {
        return (TypeNode)this.functor_.apply(this.classTaxonomy_.getNode(elkClass));
    }

    @Override
    public IndividualNode.Projection<ElkClass, ElkNamedIndividual> getInstanceNode(ElkNamedIndividual individual) {
        return (IndividualNode.Projection)this.individualNodeStore_.getNode(individual);
    }

    @Override
    public Set<? extends TypeNode<ElkClass, ElkNamedIndividual>> getNodes() {
        return Operations.map(this.classTaxonomy_.getNodes(), this.functor_);
    }

    @Override
    public Set<? extends InstanceNode<ElkClass, ElkNamedIndividual>> getInstanceNodes() {
        return this.individualNodeStore_.getNodes();
    }

    @Override
    public NonBottomTypeNode<ElkClass, ElkNamedIndividual> getNonBottomNode(ElkClass elkEntity) {
        return this.getCreateUpdateableTypeNode(this.classTaxonomy_.getNonBottomNode(elkEntity));
    }

    @Override
    public Set<? extends NonBottomTypeNode<ElkClass, ElkNamedIndividual>> getNonBottomNodes() {
        return Operations.map(this.classTaxonomy_.getNonBottomNodes(), this.nonBottomFunctor_);
    }

    @Override
    public InstanceNode<ElkClass, ElkNamedIndividual> getCreateInstanceNode(Collection<? extends ElkNamedIndividual> instances) {
        return this.individualNodeStore_.getCreateNode(instances, instances.size(), this.INSTANCE_NODE_FACTORY);
    }

    @Override
    public boolean setCreateDirectTypes(InstanceNode<ElkClass, ElkNamedIndividual> instanceNode, Iterable<? extends Collection<? extends ElkClass>> typeSets) {
        if (!(instanceNode instanceof IndividualNode)) {
            throw new IllegalArgumentException("The sub-node must belong to this taxonomy: " + instanceNode);
        }
        IndividualNode.Projection node = (IndividualNode.Projection)instanceNode;
        if (node.getTaxonomy() != this) {
            throw new IllegalArgumentException("The sub-node must belong to this taxonomy: " + instanceNode);
        }
        boolean isTypeSets = true;
        for (Collection<? extends ElkClass> collection : typeSets) {
            UpdateableTypeNodeWrapper superNode = this.getCreateUpdateableTypeNode(this.classTaxonomy_.getCreateNode(collection));
            isTypeSets = false;
            ConcurrentInstanceTaxonomy.addDirectType(superNode, node);
        }
        if (node.trySetAllParentsAssigned(true)) {
            if (!isTypeSets) {
                this.fireDirectTypeAssignment(instanceNode, instanceNode.getDirectTypeNodes());
            }
            return true;
        }
        return false;
    }

    private static void addDirectType(UpdateableTypeNode.Projection<ElkClass, ElkNamedIndividual> typeNode, UpdateableInstanceNode.Projection<ElkClass, ElkNamedIndividual> instanceNode) {
        instanceNode.addDirectTypeNode(typeNode);
        typeNode.addDirectInstanceNode(instanceNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDirectTypes(InstanceNode<ElkClass, ElkNamedIndividual> instanceNode) {
        if (!(instanceNode instanceof IndividualNode)) {
            throw new IllegalArgumentException("The sub-node must belong to this taxonomy: " + instanceNode);
        }
        IndividualNode.Projection node = (IndividualNode.Projection)instanceNode;
        if (node.getTaxonomy() != this) {
            throw new IllegalArgumentException("The sub-node must belong to this taxonomy: " + instanceNode);
        }
        if (!node.trySetAllParentsAssigned(false)) {
            return false;
        }
        ArrayList directTypes = new ArrayList();
        Object object = node;
        synchronized (object) {
            directTypes.addAll(node.getDirectNonBottomTypeNodes());
            for (UpdateableTypeNode.Projection typeNode : directTypes) {
                node.removeDirectTypeNode(typeNode);
            }
        }
        object = directTypes.iterator();
        while (object.hasNext()) {
            UpdateableTypeNode.Projection typeNode;
            UpdateableTypeNode.Projection projection = typeNode = (UpdateableTypeNode.Projection)object.next();
            synchronized (projection) {
                typeNode.removeDirectInstanceNode(node);
            }
        }
        this.fireDirectTypeRemoval(instanceNode, directTypes);
        return true;
    }

    @Override
    public boolean removeInstanceNode(ElkNamedIndividual instance) {
        if (this.individualNodeStore_.removeNode(instance)) {
            LOGGER_.trace("removed instance node with member: {}", (Object)instance);
            return true;
        }
        return false;
    }

    @Override
    public NonBottomTypeNode<ElkClass, ElkNamedIndividual> getCreateNode(Collection<? extends ElkClass> members) {
        return this.getCreateUpdateableTypeNode(this.classTaxonomy_.getCreateNode(members));
    }

    @Override
    public boolean setCreateDirectSupernodes(NonBottomTaxonomyNode<ElkClass> subNode, Iterable<? extends Collection<? extends ElkClass>> superMemberSets) {
        if (!(subNode instanceof UpdateableTypeNodeWrapper)) {
            throw new IllegalArgumentException("The sub-node must belong to this taxonomy: " + subNode);
        }
        UpdateableTypeNodeWrapper node = (UpdateableTypeNodeWrapper)subNode;
        return this.classTaxonomy_.setCreateDirectSupernodes((NonBottomTaxonomyNode<ElkClass>)node.getNode(), superMemberSets);
    }

    @Override
    public TypeNode<ElkClass, ElkNamedIndividual> getTopNode() {
        return (TypeNode)this.functor_.apply(this.classTaxonomy_.getTopNode());
    }

    @Override
    public TypeNode<ElkClass, ElkNamedIndividual> getBottomNode() {
        return this.bottomNodeWrapper_;
    }

    @Override
    public boolean removeDirectSupernodes(NonBottomTaxonomyNode<ElkClass> subNode) {
        if (!(subNode instanceof UpdateableTypeNodeWrapper)) {
            throw new IllegalArgumentException("The sub-node must belong to this taxonomy: " + subNode);
        }
        UpdateableTypeNodeWrapper node = (UpdateableTypeNodeWrapper)subNode;
        return this.classTaxonomy_.removeDirectSupernodes((NonBottomTaxonomyNode<ElkClass>)node.getNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(ElkClass member) {
        TaxonomyNode<ElkClass> node = this.classTaxonomy_.getNode(member);
        if (node == null) {
            return false;
        }
        UpdateableTypeNodeWrapper wrapper = (UpdateableTypeNodeWrapper)this.wrapperMap_.get(node);
        if (wrapper != null && this.wrapperMap_.remove(node, wrapper)) {
            Iterator<? extends UpdateableInstanceNode.Projection<ElkClass, ElkNamedIndividual>> iterator = wrapper.getDirectInstanceNodes().iterator();
            while (iterator.hasNext()) {
                UpdateableInstanceNode.Projection<ElkClass, ElkNamedIndividual> instanceNode;
                UpdateableInstanceNode.Projection<ElkClass, ElkNamedIndividual> projection = instanceNode = iterator.next();
                synchronized (projection) {
                    instanceNode.removeDirectTypeNode(wrapper);
                }
            }
        }
        return this.classTaxonomy_.removeNode(member);
    }

    @Override
    public boolean addToBottomNode(ElkClass member) {
        return this.classTaxonomy_.addToBottomNode(member);
    }

    @Override
    public boolean removeFromBottomNode(ElkClass member) {
        return this.classTaxonomy_.removeFromBottomNode(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateableTypeNodeWrapper getCreateUpdateableTypeNode(NonBottomTaxonomyNode<ElkClass> taxNode) {
        if (taxNode == null) {
            return null;
        }
        NonBottomTaxonomyNode<ElkClass> nonBottomTaxonomyNode = taxNode;
        synchronized (nonBottomTaxonomyNode) {
            UpdateableTypeNodeWrapper wrapper = (UpdateableTypeNodeWrapper)this.wrapperMap_.get(taxNode);
            if (wrapper == null) {
                wrapper = new UpdateableTypeNodeWrapper(taxNode);
                this.wrapperMap_.put(taxNode, wrapper);
            }
            return wrapper;
        }
    }

    @Override
    public boolean addListener(Taxonomy.Listener<ElkClass> listener) {
        return this.classTaxonomy_.addListener(listener);
    }

    @Override
    public boolean removeListener(Taxonomy.Listener<ElkClass> listener) {
        return this.classTaxonomy_.removeListener(listener);
    }

    @Override
    public boolean addListener(NodeStore.Listener<ElkClass> listener) {
        return this.classTaxonomy_.addListener(listener);
    }

    @Override
    public boolean removeListener(NodeStore.Listener<ElkClass> listener) {
        return this.classTaxonomy_.removeListener(listener);
    }

    @Override
    public boolean addInstanceListener(NodeStore.Listener<ElkNamedIndividual> listener) {
        return this.individualNodeStore_.addListener(listener);
    }

    @Override
    public boolean removeInstanceListener(NodeStore.Listener<ElkNamedIndividual> listener) {
        return this.individualNodeStore_.removeListener(listener);
    }

    @Override
    public boolean addInstanceListener(InstanceTaxonomy.Listener<ElkClass, ElkNamedIndividual> listener) {
        return this.instanceListeners_.add(listener);
    }

    @Override
    public boolean removeInstanceListener(InstanceTaxonomy.Listener<ElkClass, ElkNamedIndividual> listener) {
        return this.instanceListeners_.remove(listener);
    }

    protected void fireDirectTypeAssignment(InstanceNode<ElkClass, ElkNamedIndividual> instanceNode, Collection<? extends TypeNode<ElkClass, ElkNamedIndividual>> typeNodes) {
        for (InstanceTaxonomy.Listener<ElkClass, ElkNamedIndividual> listener : this.instanceListeners_) {
            listener.directTypeNodesAppeared(instanceNode);
            for (TypeNode<ElkClass, ElkNamedIndividual> typeNode : typeNodes) {
                listener.directInstanceNodesAppeared(typeNode);
            }
        }
    }

    protected void fireDirectTypeRemoval(InstanceNode<ElkClass, ElkNamedIndividual> instanceNode, Collection<? extends TypeNode<ElkClass, ElkNamedIndividual>> typeNodes) {
        for (InstanceTaxonomy.Listener<ElkClass, ElkNamedIndividual> listener : this.instanceListeners_) {
            listener.directTypeNodesDisappeared(instanceNode);
            for (TypeNode<ElkClass, ElkNamedIndividual> typeNode : typeNodes) {
                listener.directInstanceNodesDisappeared(typeNode);
            }
        }
    }

    private abstract class TypeNodeWrapper
    implements GenericTypeNode.Projection<ElkClass, ElkNamedIndividual> {
        private TypeNodeWrapper() {
        }

        public abstract TaxonomyNode<ElkClass> getNode();

        @Override
        public ComparatorKeyProvider<? super ElkClass> getKeyProvider() {
            return this.getNode().getKeyProvider();
        }

        @Override
        public boolean contains(ElkClass member) {
            return this.getNode().contains(member);
        }

        @Override
        public int size() {
            return this.getNode().size();
        }

        @Override
        public ElkClass getCanonicalMember() {
            return (ElkClass)this.getNode().getCanonicalMember();
        }

        @Override
        public Iterator<ElkClass> iterator() {
            return this.getNode().iterator();
        }

        @Override
        public Taxonomy<ElkClass> getTaxonomy() {
            return this.getNode().getTaxonomy();
        }

        @Override
        public Set<TypeNodeWrapper> getDirectSuperNodes() {
            return Operations.map(this.getNode().getDirectSuperNodes(), (Operations.FunctorEx)ConcurrentInstanceTaxonomy.this.functor_);
        }

        @Override
        public Set<TypeNodeWrapper> getAllSuperNodes() {
            return Operations.map(this.getNode().getAllSuperNodes(), (Operations.FunctorEx)ConcurrentInstanceTaxonomy.this.functor_);
        }

        @Override
        public Set<TypeNodeWrapper> getDirectSubNodes() {
            return Operations.map(this.getNode().getDirectSubNodes(), (Operations.FunctorEx)ConcurrentInstanceTaxonomy.this.functor_);
        }

        @Override
        public Set<TypeNodeWrapper> getAllSubNodes() {
            return Operations.map(this.getNode().getAllSubNodes(), (Operations.FunctorEx)ConcurrentInstanceTaxonomy.this.functor_);
        }
    }

    private class UpdateableTypeNodeWrapper
    extends TypeNodeWrapper
    implements UpdateableTypeNode.Projection<ElkClass, ElkNamedIndividual> {
        protected final NonBottomTaxonomyNode<ElkClass> classNode_;
        private final Set<UpdateableInstanceNode.Projection<ElkClass, ElkNamedIndividual>> directInstanceNodes_;

        UpdateableTypeNodeWrapper(NonBottomTaxonomyNode<ElkClass> node) {
            this.classNode_ = node;
            this.directInstanceNodes_ = Collections.newSetFromMap(new ConcurrentHashMap());
        }

        public NonBottomTaxonomyNode<ElkClass> getNode() {
            return this.classNode_;
        }

        @Override
        public Set<? extends UpdateableInstanceNode.Projection<ElkClass, ElkNamedIndividual>> getDirectInstanceNodes() {
            return Collections.unmodifiableSet(this.directInstanceNodes_);
        }

        @Override
        public Set<? extends GenericInstanceNode.Projection<ElkClass, ElkNamedIndividual>> getAllInstanceNodes() {
            return TaxonomyNodeUtils.getAllInstanceNodes(this);
        }

        @Override
        public Set<? extends UpdateableTypeNode.Projection<ElkClass, ElkNamedIndividual>> getDirectNonBottomSuperNodes() {
            return Operations.map(this.getNode().getDirectNonBottomSuperNodes(), (Operations.FunctorEx)ConcurrentInstanceTaxonomy.this.nonBottomFunctor_);
        }

        @Override
        public Set<? extends UpdateableTypeNode.Projection<ElkClass, ElkNamedIndividual>> getDirectNonBottomSubNodes() {
            return Operations.map(this.getNode().getDirectNonBottomSubNodes(), (Operations.FunctorEx)ConcurrentInstanceTaxonomy.this.nonBottomFunctor_);
        }

        @Override
        public void addDirectInstanceNode(UpdateableInstanceNode.Projection<ElkClass, ElkNamedIndividual> instanceNode) {
            LOGGER_.trace("{}: new direct instance-node {}", this.classNode_, instanceNode);
            this.directInstanceNodes_.add(instanceNode);
        }

        @Override
        public void removeDirectInstanceNode(UpdateableInstanceNode.Projection<ElkClass, ElkNamedIndividual> instanceNode) {
            LOGGER_.trace("{}: direct instance node removed {}", this.classNode_, instanceNode);
            this.directInstanceNodes_.remove(instanceNode);
        }

        public String toString() {
            return this.classNode_.toString();
        }

        public int hashCode() {
            return this.classNode_.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof UpdateableTypeNodeWrapper) {
                return this.classNode_ == ((UpdateableTypeNodeWrapper)obj).classNode_;
            }
            return false;
        }
    }
}

