/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Iterator;
import java.util.Map;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.model.ComparatorKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.util.collections.ArrayHashMap;

public abstract class OrphanNode<T extends ElkEntity>
implements Node<T> {
    private final Map<Object, T> members;
    private final T canonical;

    public OrphanNode(Iterable<? extends T> members, int size, T canonical, ComparatorKeyProvider<? super T> keyProvider) {
        this.members = new ArrayHashMap(size);
        for (ElkEntity member : members) {
            this.members.put(keyProvider.getKey(member), member);
        }
        this.canonical = canonical;
    }

    @Override
    public Iterator<T> iterator() {
        return this.members.values().iterator();
    }

    @Override
    public boolean contains(T member) {
        return this.members.containsKey(this.getKeyProvider().getKey(member));
    }

    @Override
    public int size() {
        return this.members.size();
    }

    @Override
    public T getCanonicalMember() {
        return this.canonical;
    }
}

