/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.impl.AbstractTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.ComparatorKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeStore;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.hashing.HashGenerator;

public class ReverseTaxonomy<T extends ElkEntity>
extends AbstractTaxonomy<T> {
    protected final Taxonomy<T> original_;
    protected final List<Taxonomy.Listener<T>> taxonomyListeners_ = new ArrayList<Taxonomy.Listener<T>>();
    private final Operations.FunctorEx<TaxonomyNode<T>, ReverseTaxonomyNode> wrapNode_ = new Operations.FunctorEx<TaxonomyNode<T>, ReverseTaxonomyNode>(){

        public ReverseTaxonomyNode apply(TaxonomyNode<T> node) {
            if (node == null) {
                return null;
            }
            return new ReverseTaxonomyNode(node);
        }

        public TaxonomyNode<T> deapply(Object element) {
            if (element == null) {
                return null;
            }
            if (element instanceof ReverseTaxonomyNode) {
                return ((ReverseTaxonomyNode)element).originalNode_;
            }
            return null;
        }
    };
    private final Taxonomy.Listener<T> reverseListener_ = new Taxonomy.Listener<T>(){

        @Override
        public void directSuperNodesAppeared(TaxonomyNode<T> subNode) {
            for (Taxonomy.Listener listener : ReverseTaxonomy.this.taxonomyListeners_) {
                listener.directSubNodesAppeared(subNode);
            }
        }

        @Override
        public void directSuperNodesDisappeared(TaxonomyNode<T> subNode) {
            for (Taxonomy.Listener listener : ReverseTaxonomy.this.taxonomyListeners_) {
                listener.directSubNodesDisappeared(subNode);
            }
        }

        @Override
        public void directSubNodesAppeared(TaxonomyNode<T> superNode) {
            for (Taxonomy.Listener listener : ReverseTaxonomy.this.taxonomyListeners_) {
                listener.directSuperNodesAppeared(superNode);
            }
        }

        @Override
        public void directSubNodesDisappeared(TaxonomyNode<T> superNode) {
            for (Taxonomy.Listener listener : ReverseTaxonomy.this.taxonomyListeners_) {
                listener.directSuperNodesDisappeared(superNode);
            }
        }
    };

    public ReverseTaxonomy(Taxonomy<T> original) {
        this.original_ = original;
    }

    @Override
    public ComparatorKeyProvider<? super T> getKeyProvider() {
        return this.original_.getKeyProvider();
    }

    @Override
    public TaxonomyNode<T> getNode(T elkEntity) {
        return (TaxonomyNode)this.wrapNode_.apply(this.original_.getNode(elkEntity));
    }

    @Override
    public Set<? extends TaxonomyNode<T>> getNodes() {
        return Operations.map(this.original_.getNodes(), this.wrapNode_);
    }

    @Override
    public TaxonomyNode<T> getTopNode() {
        return (TaxonomyNode)this.wrapNode_.apply(this.original_.getBottomNode());
    }

    @Override
    public TaxonomyNode<T> getBottomNode() {
        return (TaxonomyNode)this.wrapNode_.apply(this.original_.getTopNode());
    }

    @Override
    public boolean addListener(NodeStore.Listener<T> listener) {
        return this.original_.addListener(listener);
    }

    @Override
    public boolean removeListener(NodeStore.Listener<T> listener) {
        return this.original_.removeListener(listener);
    }

    @Override
    public boolean addListener(Taxonomy.Listener<T> listener) {
        boolean wasEmpty = this.taxonomyListeners_.isEmpty();
        boolean ret = this.taxonomyListeners_.add(listener);
        if (wasEmpty && ret && !this.original_.addListener(this.reverseListener_)) {
            this.taxonomyListeners_.remove(listener);
            return false;
        }
        return ret;
    }

    @Override
    public boolean removeListener(Taxonomy.Listener<T> listener) {
        boolean ret = this.taxonomyListeners_.remove(listener);
        if (this.taxonomyListeners_.isEmpty() && ret && !this.original_.removeListener(this.reverseListener_)) {
            this.taxonomyListeners_.add(listener);
            return false;
        }
        return ret;
    }

    protected class ReverseTaxonomyNode
    implements TaxonomyNode<T> {
        protected final TaxonomyNode<T> originalNode_;

        public ReverseTaxonomyNode(TaxonomyNode<T> original) {
            this.originalNode_ = original;
        }

        @Override
        public ComparatorKeyProvider<? super T> getKeyProvider() {
            return this.originalNode_.getKeyProvider();
        }

        @Override
        public boolean contains(T member) {
            return this.originalNode_.contains(member);
        }

        @Override
        public int size() {
            return this.originalNode_.size();
        }

        @Override
        public T getCanonicalMember() {
            return (ElkEntity)this.originalNode_.getCanonicalMember();
        }

        @Override
        public Iterator<T> iterator() {
            return this.originalNode_.iterator();
        }

        @Override
        public Taxonomy<T> getTaxonomy() {
            return ReverseTaxonomy.this.original_;
        }

        @Override
        public Set<? extends TaxonomyNode<T>> getDirectSuperNodes() {
            return Operations.map(this.originalNode_.getDirectSubNodes(), (Operations.FunctorEx)ReverseTaxonomy.this.wrapNode_);
        }

        @Override
        public Set<? extends TaxonomyNode<T>> getAllSuperNodes() {
            return Operations.map(this.originalNode_.getAllSubNodes(), (Operations.FunctorEx)ReverseTaxonomy.this.wrapNode_);
        }

        @Override
        public Set<? extends TaxonomyNode<T>> getDirectSubNodes() {
            return Operations.map(this.originalNode_.getDirectSuperNodes(), (Operations.FunctorEx)ReverseTaxonomy.this.wrapNode_);
        }

        @Override
        public Set<? extends TaxonomyNode<T>> getAllSubNodes() {
            return Operations.map(this.originalNode_.getAllSuperNodes(), (Operations.FunctorEx)ReverseTaxonomy.this.wrapNode_);
        }

        public int hashCode() {
            return HashGenerator.combinedHashCode((Object[])new Object[]{this.getClass().hashCode(), this.originalNode_.hashCode()});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReverseTaxonomyNode other = (ReverseTaxonomyNode)obj;
            return this.originalNode_ == null ? other.originalNode_ == null : this.originalNode_.equals(other.originalNode_);
        }

        public String toString() {
            return this.originalNode_.toString();
        }
    }
}

