/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.OrphanTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.SingletoneTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.hashing.InstanceTaxonomyEqualator;
import org.semanticweb.elk.reasoner.taxonomy.hashing.InstanceTaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.ComparatorKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeStore;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNodeFactory;
import org.semanticweb.elk.util.collections.ArrayHashMap;

public class SingletoneInstanceTaxonomy<T extends ElkEntity, I extends ElkEntity, N extends OrphanTypeNode<T, I>>
extends SingletoneTaxonomy<T, N>
implements InstanceTaxonomy<T, I> {
    final Map<Object, InstanceNode<T, I>> instanceNodeLookup;
    private final ComparatorKeyProvider<? super I> individualKeyProvider_;

    public SingletoneInstanceTaxonomy(ComparatorKeyProvider<? super T> keyProvider, Collection<? extends T> allMembers, TaxonomyNodeFactory<T, N, Taxonomy<T>> nodeFactory, ComparatorKeyProvider<? super I> individualKeyProvider) {
        super(keyProvider, allMembers, nodeFactory);
        this.individualKeyProvider_ = individualKeyProvider;
        this.instanceNodeLookup = new ArrayHashMap(((OrphanTypeNode)this.node).getAllInstanceNodes().size());
        for (InstanceNode instanceNode : ((OrphanTypeNode)this.node).getAllInstanceNodes()) {
            for (ElkEntity instance : instanceNode) {
                this.instanceNodeLookup.put(this.individualKeyProvider_.getKey(instance), instanceNode);
            }
        }
    }

    @Override
    public ComparatorKeyProvider<? super I> getInstanceKeyProvider() {
        return this.individualKeyProvider_;
    }

    @Override
    public InstanceNode<T, I> getInstanceNode(I elkObject) {
        return this.instanceNodeLookup.get(this.individualKeyProvider_.getKey(elkObject));
    }

    @Override
    public Set<? extends InstanceNode<T, I>> getInstanceNodes() {
        return ((OrphanTypeNode)this.node).instanceNodes;
    }

    @Override
    public int hashCode() {
        return InstanceTaxonomyHasher.hash(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Taxonomy)) {
            return false;
        }
        try {
            return InstanceTaxonomyEqualator.equals(this, (Taxonomy)obj);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean addInstanceListener(NodeStore.Listener<I> listener) {
        return true;
    }

    @Override
    public boolean removeInstanceListener(NodeStore.Listener<I> listener) {
        return true;
    }

    @Override
    public boolean addInstanceListener(InstanceTaxonomy.Listener<T, I> listener) {
        return true;
    }

    @Override
    public boolean removeInstanceListener(InstanceTaxonomy.Listener<T, I> listener) {
        return true;
    }
}

